/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Locale;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;
import sun.security.action.GetPropertyAction;

public abstract class SSLSocketFactory
extends SocketFactory {
    static final boolean DEBUG;

    public static SocketFactory getDefault() {
        if (DefaultFactoryHolder.defaultFactory != null) {
            return DefaultFactoryHolder.defaultFactory;
        }
        try {
            return SSLContext.getDefault().getSocketFactory();
        }
        catch (UnsupportedOperationException | NoSuchAlgorithmException e) {
            return new DefaultSSLSocketFactory(e);
        }
    }

    static String getSecurityProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String s = Security.getProperty(name);
                if (s != null && (s = s.trim()).isEmpty()) {
                    s = null;
                }
                return s;
            }
        });
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        String s = GetPropertyAction.privilegedGetProperty("javax.net.debug", "").toLowerCase(Locale.ENGLISH);
        DEBUG = s.contains("all") || s.contains("ssl");
    }

    private static final class DefaultFactoryHolder {
        private static final SSLSocketFactory defaultFactory;

        private DefaultFactoryHolder() {
        }

        private static void log(String msg) {
            if (DEBUG) {
                System.out.println(msg);
            }
        }

        static {
            SSLSocketFactory mediator = null;
            String clsName = SSLSocketFactory.getSecurityProperty("ssl.SocketFactory.provider");
            if (clsName != null) {
                DefaultFactoryHolder.log("setting up default SSLSocketFactory");
                try {
                    Class<?> cls;
                    block5: {
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block5;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    DefaultFactoryHolder.log("class " + clsName + " is loaded");
                    mediator = (SSLSocketFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DefaultFactoryHolder.log("instantiated an instance of class " + clsName);
                }
                catch (Exception e) {
                    DefaultFactoryHolder.log("SSLSocketFactory instantiation failed: " + e);
                    mediator = new DefaultSSLSocketFactory(e);
                }
            }
            defaultFactory = mediator;
        }
    }
}

