/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private final String prompt;
    private final String[] choices;
    private final int defaultChoice;
    private final boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String prompt, String[] choices, int defaultChoice, boolean multipleSelectionsAllowed) {
        if (prompt == null || prompt.isEmpty() || choices == null || choices.length == 0 || defaultChoice < 0 || defaultChoice >= choices.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < choices.length; ++i) {
            if (choices[i] != null && !choices[i].isEmpty()) continue;
            throw new IllegalArgumentException();
        }
        this.prompt = prompt;
        this.choices = (String[])choices.clone();
        this.defaultChoice = defaultChoice;
        this.multipleSelectionsAllowed = multipleSelectionsAllowed;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return (String[])this.choices.clone();
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int selection) {
        this.selections = new int[1];
        this.selections[0] = selection;
    }

    public void setSelectedIndexes(int[] selections) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = selections == null ? null : (int[])selections.clone();
    }

    public int[] getSelectedIndexes() {
        return this.selections == null ? null : (int[])this.selections.clone();
    }
}

