/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import sun.security.util.Debug;
import sun.security.util.PendingException;
import sun.security.util.ResourcesMgr;

public class LoginContext {
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map<String, ?> state = new HashMap();
    private Configuration config;
    private AccessControlContext creatorAcc = null;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private int moduleIndex = 0;
    private LoginException firstError = null;
    private LoginException firstRequiredError = null;
    private boolean success = false;
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");
    private static final WeakHashMap<ClassLoader, Set<ServiceLoader.Provider<LoginModule>>> providersCache = new WeakHashMap();

    private void init(String name) throws LoginException {
        AppConfigurationEntry[] entries;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.creatorAcc == null) {
            sm.checkPermission(new AuthPermission("createLoginContext." + name));
        }
        if (name == null) {
            throw new LoginException(ResourcesMgr.getString("Invalid.null.input.name"));
        }
        if (this.config == null) {
            this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

                @Override
                public Configuration run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        if ((entries = this.config.getAppConfigurationEntry(name)) == null) {
            if (sm != null && this.creatorAcc == null) {
                sm.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((entries = this.config.getAppConfigurationEntry(OTHER)) == null) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("No.LoginModules.configured.for.name"));
                Object[] source = new Object[]{name};
                throw new LoginException(form.format(source));
            }
        }
        this.moduleStack = new ModuleInfo[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            this.moduleStack[i] = new ModuleInfo(new AppConfigurationEntry(entries[i].getLoginModuleName(), entries[i].getControlFlag(), entries[i].getOptions()), null);
        }
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                return loader;
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader finalLoader = this.contextClassLoader;
            this.callbackHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                @Override
                public CallbackHandler run() throws Exception {
                    String defaultHandler = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (defaultHandler == null || defaultHandler.isEmpty()) {
                        return null;
                    }
                    Class<CallbackHandler> c = Class.forName(defaultHandler, true, finalLoader).asSubclass(CallbackHandler.class);
                    CallbackHandler result = c.newInstance();
                    return result;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new LoginException(pae.getException().toString());
        }
        if (this.callbackHandler != null && this.creatorAcc == null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String name) throws LoginException {
        this.init(name);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this.init(name);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.Subject.provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, CallbackHandler callbackHandler) throws LoginException {
        this.init(name);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(name, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler, Configuration config) throws LoginException {
        this.config = config;
        if (config != null) {
            this.creatorAcc = AccessController.getContext();
        }
        this.init(name);
        if (subject != null) {
            this.subject = subject;
            this.subjectProvided = true;
        }
        if (callbackHandler == null) {
            this.loadDefaultCallbackHandler();
        } else {
            this.callbackHandler = this.creatorAcc == null ? new SecureCallbackHandler(AccessController.getContext(), callbackHandler) : callbackHandler;
        }
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokePriv(LOGIN_METHOD);
            this.invokePriv(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException le) {
            try {
                this.invokePriv(ABORT_METHOD);
            }
            catch (LoginException le2) {
                throw le;
            }
            throw le;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException(ResourcesMgr.getString("null.subject.logout.called.before.login"));
        }
        this.invokePriv(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void clearState() {
        this.moduleIndex = 0;
        this.firstError = null;
        this.firstRequiredError = null;
        this.success = false;
    }

    private void throwException(LoginException originalError, LoginException le) throws LoginException {
        this.clearState();
        LoginException error = originalError != null ? originalError : le;
        throw error;
    }

    private void invokePriv(final String methodName) throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws LoginException {
                    LoginContext.this.invoke(methodName);
                    return null;
                }
            }, this.creatorAcc);
        }
        catch (PrivilegedActionException pae) {
            throw (LoginException)pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(String methodName) throws LoginException {
        int i = this.moduleIndex;
        while (i < this.moduleStack.length) {
            block54: {
                try {
                    if (this.moduleStack[i].module == null) {
                        Set<ServiceLoader.Provider> lmProviders;
                        String name = this.moduleStack[i].entry.getLoginModuleName();
                        WeakHashMap<ClassLoader, Set<ServiceLoader.Provider<LoginModule>>> weakHashMap = providersCache;
                        synchronized (weakHashMap) {
                            lmProviders = providersCache.get(this.contextClassLoader);
                            if (lmProviders == null) {
                                if (debug != null) {
                                    debug.println("Build ServiceProviders cache for ClassLoader: " + this.contextClassLoader.getName());
                                }
                                ServiceLoader sc = AccessController.doPrivileged(() -> ServiceLoader.load(LoginModule.class, this.contextClassLoader));
                                lmProviders = sc.stream().collect(Collectors.toSet());
                                if (debug != null) {
                                    debug.println("Discovered ServiceProviders for ClassLoader: " + this.contextClassLoader.getName());
                                    lmProviders.forEach(System.err::println);
                                }
                                providersCache.put(this.contextClassLoader, lmProviders);
                            }
                        }
                        for (ServiceLoader.Provider lm : lmProviders) {
                            if (!lm.type().getName().equals(name)) continue;
                            this.moduleStack[i].module = (LoginModule)lm.get();
                            if (debug == null) break;
                            debug.println(name + " loaded as a service");
                            break;
                        }
                        if (this.moduleStack[i].module == null) {
                            try {
                                Object tmp = Class.forName(name, false, this.contextClassLoader).newInstance();
                                this.moduleStack[i].module = (LoginModule)tmp;
                                if (debug != null) {
                                    debug.println(name + " loaded via reflection");
                                }
                            }
                            catch (ClassNotFoundException e) {
                                throw new LoginException("No LoginModule found for " + name);
                            }
                        }
                        this.moduleStack[i].module.initialize(this.subject, this.callbackHandler, this.state, this.moduleStack[i].entry.getOptions());
                    }
                    if (switch (methodName) {
                        case LOGIN_METHOD -> this.moduleStack[i].module.login();
                        case COMMIT_METHOD -> this.moduleStack[i].module.commit();
                        case LOGOUT_METHOD -> this.moduleStack[i].module.logout();
                        case ABORT_METHOD -> this.moduleStack[i].module.abort();
                        default -> throw new AssertionError((Object)("Unknown method " + methodName));
                    }) {
                        if (!methodName.equals(ABORT_METHOD) && !methodName.equals(LOGOUT_METHOD) && this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && this.firstRequiredError == null) {
                            this.clearState();
                            if (debug != null) {
                                debug.println(methodName + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(methodName + " success");
                        }
                        this.success = true;
                    } else if (debug != null) {
                        debug.println(methodName + " ignored");
                    }
                }
                catch (Exception ite) {
                    LoginException le;
                    if (ite instanceof PendingException && methodName.equals(LOGIN_METHOD)) {
                        throw (PendingException)ite;
                    }
                    if (ite instanceof LoginException) {
                        le = (LoginException)ite;
                    } else if (ite instanceof SecurityException) {
                        le = new LoginException("Security Exception");
                        le.initCause(new SecurityException());
                        if (debug != null) {
                            debug.println("original security exception with detail msg replaced by new exception with empty detail msg");
                            debug.println("original security exception: " + ite.toString());
                        }
                    } else {
                        StringWriter sw = new StringWriter();
                        ite.printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        le = new LoginException(sw.toString());
                    }
                    if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(methodName + " REQUISITE failure");
                        }
                        if (methodName.equals(ABORT_METHOD) || methodName.equals(LOGOUT_METHOD)) {
                            if (this.firstRequiredError == null) {
                                this.firstRequiredError = le;
                            }
                        } else {
                            this.throwException(this.firstRequiredError, le);
                        }
                    }
                    if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(methodName + " REQUIRED failure");
                        }
                        if (this.firstRequiredError == null) {
                            this.firstRequiredError = le;
                        }
                    }
                    if (debug != null) {
                        debug.println(methodName + " OPTIONAL failure");
                    }
                    if (this.firstError != null) break block54;
                    this.firstError = le;
                }
            }
            ++i;
            ++this.moduleIndex;
        }
        if (this.firstRequiredError != null) {
            this.throwException(this.firstRequiredError, null);
        } else if (!this.success && this.firstError != null) {
            this.throwException(this.firstError, null);
        } else if (!this.success) {
            this.throwException(new LoginException(ResourcesMgr.getString("Login.Failure.all.modules.ignored")), null);
        } else {
            this.clearState();
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        LoginModule module;

        ModuleInfo(AppConfigurationEntry newEntry, LoginModule newModule) {
            this.entry = newEntry;
            this.module = newModule;
        }
    }

    private static class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext acc, CallbackHandler ch) {
            this.acc = acc;
            this.ch = ch;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, UnsupportedCallbackException {
                        ch.handle(callbacks);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof IOException) {
                    throw (IOException)pae.getException();
                }
                throw (UnsupportedCallbackException)pae.getException();
            }
        }
    }
}

