/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.icu.text;

import java.text.Bidi;
import java.util.Arrays;
import jdk.internal.icu.text.BidiBase;
import jdk.internal.icu.text.BidiRun;

final class BidiLine {
    BidiLine() {
    }

    static void setTrailingWSStart(BidiBase bidiBase) {
        int start;
        byte[] dirProps = bidiBase.dirProps;
        byte[] levels = bidiBase.levels;
        byte paraLevel = bidiBase.paraLevel;
        if (dirProps[start - 1] == 7) {
            bidiBase.trailingWSStart = start;
            return;
        }
        for (start = bidiBase.length; start > 0 && (BidiBase.DirPropFlag(dirProps[start - 1]) & BidiBase.MASK_WS) != 0; --start) {
        }
        while (start > 0 && levels[start - 1] == paraLevel) {
            --start;
        }
        bidiBase.trailingWSStart = start;
    }

    static Bidi setLine(BidiBase paraBidi, Bidi newBidi, BidiBase lineBidi, int start, int limit) {
        lineBidi.originalLength = lineBidi.resultLength = limit - start;
        lineBidi.length = lineBidi.resultLength;
        int length = lineBidi.resultLength;
        lineBidi.text = new char[length];
        System.arraycopy(paraBidi.text, start, lineBidi.text, 0, length);
        lineBidi.paraLevel = paraBidi.GetParaLevelAt(start);
        lineBidi.paraCount = paraBidi.paraCount;
        lineBidi.runs = new BidiRun[0];
        lineBidi.reorderingMode = paraBidi.reorderingMode;
        lineBidi.reorderingOptions = paraBidi.reorderingOptions;
        if (paraBidi.controlCount > 0) {
            for (int j = start; j < limit; ++j) {
                if (!BidiBase.IsBidiControlChar(paraBidi.text[j])) continue;
                ++lineBidi.controlCount;
            }
            lineBidi.resultLength -= lineBidi.controlCount;
        }
        lineBidi.getDirPropsMemory(length);
        lineBidi.dirProps = lineBidi.dirPropsMemory;
        System.arraycopy(paraBidi.dirProps, start, lineBidi.dirProps, 0, length);
        lineBidi.getLevelsMemory(length);
        lineBidi.levels = lineBidi.levelsMemory;
        System.arraycopy(paraBidi.levels, start, lineBidi.levels, 0, length);
        lineBidi.runCount = -1;
        if (paraBidi.direction != 2) {
            lineBidi.direction = paraBidi.direction;
            lineBidi.trailingWSStart = paraBidi.trailingWSStart <= start ? 0 : (paraBidi.trailingWSStart < limit ? paraBidi.trailingWSStart - start : length);
        } else {
            byte[] levels = lineBidi.levels;
            BidiLine.setTrailingWSStart(lineBidi);
            int trailingWSStart = lineBidi.trailingWSStart;
            if (trailingWSStart == 0) {
                lineBidi.direction = (byte)(lineBidi.paraLevel & 1);
            } else {
                byte level = (byte)(levels[0] & 1);
                if (trailingWSStart < length && (lineBidi.paraLevel & 1) != level) {
                    lineBidi.direction = (byte)2;
                } else {
                    int i = 1;
                    while (true) {
                        if (i == trailingWSStart) {
                            lineBidi.direction = level;
                            break;
                        }
                        if ((levels[i] & 1) != level) {
                            lineBidi.direction = (byte)2;
                            break;
                        }
                        ++i;
                    }
                }
            }
            switch (lineBidi.direction) {
                case 0: {
                    lineBidi.paraLevel = (byte)(lineBidi.paraLevel + 1 & 0xFFFFFFFE);
                    lineBidi.trailingWSStart = 0;
                    break;
                }
                case 1: {
                    lineBidi.paraLevel = (byte)(lineBidi.paraLevel | 1);
                    lineBidi.trailingWSStart = 0;
                    break;
                }
            }
        }
        lineBidi.paraBidi = paraBidi;
        return newBidi;
    }

    static byte getLevelAt(BidiBase bidiBase, int charIndex) {
        if (bidiBase.direction != 2 || charIndex >= bidiBase.trailingWSStart) {
            return bidiBase.GetParaLevelAt(charIndex);
        }
        return bidiBase.levels[charIndex];
    }

    static byte[] getLevels(BidiBase bidiBase) {
        int start = bidiBase.trailingWSStart;
        int length = bidiBase.length;
        if (start != length) {
            Arrays.fill(bidiBase.levels, start, length, bidiBase.paraLevel);
            bidiBase.trailingWSStart = length;
        }
        if (length < bidiBase.levels.length) {
            byte[] levels = new byte[length];
            System.arraycopy(bidiBase.levels, 0, levels, 0, length);
            return levels;
        }
        return bidiBase.levels;
    }

    static BidiRun getVisualRun(BidiBase bidiBase, int runIndex) {
        int start = bidiBase.runs[runIndex].start;
        byte level = bidiBase.runs[runIndex].level;
        int limit = runIndex > 0 ? start + bidiBase.runs[runIndex].limit - bidiBase.runs[runIndex - 1].limit : start + bidiBase.runs[0].limit;
        return new BidiRun(start, limit, level);
    }

    private static void getSingleRun(BidiBase bidiBase, byte level) {
        bidiBase.runs = bidiBase.simpleRuns;
        bidiBase.runCount = 1;
        bidiBase.runs[0] = new BidiRun(0, bidiBase.length, level);
    }

    private static void reorderLine(BidiBase bidiBase, byte minLevel, byte maxLevel) {
        BidiRun tempRun;
        int firstRun;
        if (maxLevel <= (minLevel | 1)) {
            return;
        }
        minLevel = (byte)(minLevel + 1);
        BidiRun[] runs = bidiBase.runs;
        byte[] levels = bidiBase.levels;
        int runCount = bidiBase.runCount;
        if (bidiBase.trailingWSStart < bidiBase.length) {
            --runCount;
        }
        block0: while ((maxLevel = (byte)(maxLevel - 1)) >= minLevel) {
            firstRun = 0;
            while (true) {
                if (firstRun < runCount && levels[runs[firstRun].start] < maxLevel) {
                    ++firstRun;
                    continue;
                }
                if (firstRun >= runCount) continue block0;
                int limitRun = firstRun;
                while (++limitRun < runCount && levels[runs[limitRun].start] >= maxLevel) {
                }
                for (int endRun = limitRun - 1; firstRun < endRun; ++firstRun, --endRun) {
                    tempRun = runs[firstRun];
                    runs[firstRun] = runs[endRun];
                    runs[endRun] = tempRun;
                }
                if (limitRun == runCount) continue block0;
                firstRun = limitRun + 1;
            }
        }
        if ((minLevel & 1) == 0) {
            firstRun = 0;
            if (bidiBase.trailingWSStart == bidiBase.length) {
                --runCount;
            }
            while (firstRun < runCount) {
                tempRun = runs[firstRun];
                runs[firstRun] = runs[runCount];
                runs[runCount] = tempRun;
                ++firstRun;
                --runCount;
            }
        }
    }

    static int getRunFromLogicalIndex(BidiBase bidiBase, int logicalIndex) {
        BidiRun[] runs = bidiBase.runs;
        int runCount = bidiBase.runCount;
        int visualStart = 0;
        for (int i = 0; i < runCount; ++i) {
            int length = runs[i].limit - visualStart;
            int logicalStart = runs[i].start;
            if (logicalIndex >= logicalStart && logicalIndex < logicalStart + length) {
                return i;
            }
            visualStart += length;
        }
        throw new IllegalStateException("Internal ICU error in getRunFromLogicalIndex");
    }

    static void getRuns(BidiBase bidiBase) {
        if (bidiBase.runCount >= 0) {
            return;
        }
        if (bidiBase.direction != 2) {
            BidiLine.getSingleRun(bidiBase, bidiBase.paraLevel);
        } else {
            int i;
            int length = bidiBase.length;
            byte[] levels = bidiBase.levels;
            byte level = -1;
            int limit = bidiBase.trailingWSStart;
            int runCount = 0;
            for (i = 0; i < limit; ++i) {
                if (levels[i] == level) continue;
                ++runCount;
                level = levels[i];
            }
            if (runCount == 1 && limit == length) {
                BidiLine.getSingleRun(bidiBase, levels[0]);
            } else {
                byte minLevel = 126;
                byte maxLevel = 0;
                if (limit < length) {
                    ++runCount;
                }
                bidiBase.getRunsMemory(runCount);
                BidiRun[] runs = bidiBase.runsMemory;
                int runIndex = 0;
                i = 0;
                do {
                    int start = i;
                    level = levels[i];
                    if (level < minLevel) {
                        minLevel = level;
                    }
                    if (level > maxLevel) {
                        maxLevel = level;
                    }
                    while (++i < limit && levels[i] == level) {
                    }
                    runs[runIndex] = new BidiRun(start, i - start, level);
                    ++runIndex;
                } while (i < limit);
                if (limit < length) {
                    runs[runIndex] = new BidiRun(limit, length - limit, bidiBase.paraLevel);
                    if (bidiBase.paraLevel < minLevel) {
                        minLevel = bidiBase.paraLevel;
                    }
                }
                bidiBase.runs = runs;
                bidiBase.runCount = runCount;
                BidiLine.reorderLine(bidiBase, minLevel, maxLevel);
                limit = 0;
                for (i = 0; i < runCount; ++i) {
                    runs[i].level = levels[runs[i].start];
                    limit = runs[i].limit += limit;
                }
                if (runIndex < runCount) {
                    int trailingRun = (bidiBase.paraLevel & 1) != 0 ? 0 : runIndex;
                    runs[trailingRun].level = bidiBase.paraLevel;
                }
            }
        }
        if (bidiBase.insertPoints.size > 0) {
            for (int ip = 0; ip < bidiBase.insertPoints.size; ++ip) {
                BidiBase.Point point = bidiBase.insertPoints.points[ip];
                int runIndex = BidiLine.getRunFromLogicalIndex(bidiBase, point.pos);
                bidiBase.runs[runIndex].insertRemove |= point.flag;
            }
        }
        if (bidiBase.controlCount > 0) {
            for (int ic = 0; ic < bidiBase.length; ++ic) {
                char c = bidiBase.text[ic];
                if (!BidiBase.IsBidiControlChar(c)) continue;
                int runIndex = BidiLine.getRunFromLogicalIndex(bidiBase, ic);
                --bidiBase.runs[runIndex].insertRemove;
            }
        }
    }

    static int[] prepareReorder(byte[] levels, byte[] pMinLevel, byte[] pMaxLevel) {
        if (levels == null || levels.length <= 0) {
            return null;
        }
        byte minLevel = 126;
        byte maxLevel = 0;
        int start = levels.length;
        while (start > 0) {
            byte level;
            if ((level = levels[--start]) < 0 || level > 126) {
                return null;
            }
            if (level < minLevel) {
                minLevel = level;
            }
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        pMinLevel[0] = minLevel;
        pMaxLevel[0] = maxLevel;
        int[] indexMap = new int[levels.length];
        start = levels.length;
        while (start > 0) {
            indexMap[--start] = start;
        }
        return indexMap;
    }

    static int[] reorderVisual(byte[] levels) {
        byte[] aMinLevel = new byte[1];
        byte[] aMaxLevel = new byte[1];
        int[] indexMap = BidiLine.prepareReorder(levels, aMinLevel, aMaxLevel);
        if (indexMap == null) {
            return null;
        }
        byte minLevel = aMinLevel[0];
        byte maxLevel = aMaxLevel[0];
        if (minLevel == maxLevel && (minLevel & 1) == 0) {
            return indexMap;
        }
        minLevel = (byte)(minLevel | 1);
        block0: do {
            int start = 0;
            while (true) {
                if (start < levels.length && levels[start] < maxLevel) {
                    ++start;
                    continue;
                }
                if (start >= levels.length) continue block0;
                int limit = start;
                while (++limit < levels.length && levels[limit] >= maxLevel) {
                }
                for (int end = limit - 1; start < end; ++start, --end) {
                    int temp = indexMap[start];
                    indexMap[start] = indexMap[end];
                    indexMap[end] = temp;
                }
                if (limit == levels.length) continue block0;
                start = limit + 1;
            }
        } while ((maxLevel = (byte)(maxLevel - 1)) >= minLevel);
        return indexMap;
    }

    static int[] getVisualMap(BidiBase bidiBase) {
        int visualLimit;
        int logicalStart;
        BidiRun[] runs = bidiBase.runs;
        int allocLength = bidiBase.length > bidiBase.resultLength ? bidiBase.length : bidiBase.resultLength;
        int[] indexMap = new int[allocLength];
        int visualStart = 0;
        int idx = 0;
        for (int j = 0; j < bidiBase.runCount; ++j) {
            logicalStart = runs[j].start;
            visualLimit = runs[j].limit;
            if (runs[j].isEvenRun()) {
                do {
                    indexMap[idx++] = logicalStart++;
                } while (++visualStart < visualLimit);
                continue;
            }
            logicalStart += visualLimit - visualStart;
            do {
                indexMap[idx++] = --logicalStart;
            } while (++visualStart < visualLimit);
        }
        if (bidiBase.insertPoints.size > 0) {
            int insertRemove;
            int i;
            int markFound = 0;
            int runCount = bidiBase.runCount;
            runs = bidiBase.runs;
            for (i = 0; i < runCount; ++i) {
                insertRemove = runs[i].insertRemove;
                if ((insertRemove & 5) > 0) {
                    ++markFound;
                }
                if ((insertRemove & 0xA) <= 0) continue;
                ++markFound;
            }
            int k = bidiBase.resultLength;
            for (i = runCount - 1; i >= 0 && markFound > 0; --i) {
                insertRemove = runs[i].insertRemove;
                if ((insertRemove & 0xA) > 0) {
                    indexMap[--k] = -1;
                    --markFound;
                }
                visualStart = i > 0 ? runs[i - 1].limit : 0;
                for (int j = runs[i].limit - 1; j >= visualStart && markFound > 0; --j) {
                    indexMap[--k] = indexMap[j];
                }
                if ((insertRemove & 5) <= 0) continue;
                indexMap[--k] = -1;
                --markFound;
            }
        } else if (bidiBase.controlCount > 0) {
            int runCount = bidiBase.runCount;
            runs = bidiBase.runs;
            visualStart = 0;
            int k = 0;
            int i = 0;
            while (i < runCount) {
                int length = runs[i].limit - visualStart;
                int insertRemove = runs[i].insertRemove;
                if (insertRemove == 0 && k == visualStart) {
                    k += length;
                } else if (insertRemove == 0) {
                    visualLimit = runs[i].limit;
                    for (j = visualStart; j < visualLimit; ++j) {
                        indexMap[k++] = indexMap[j];
                    }
                } else {
                    logicalStart = runs[i].start;
                    boolean evenRun = runs[i].isEvenRun();
                    int logicalEnd = logicalStart + length - 1;
                    for (j = 0; j < length; ++j) {
                        int m = evenRun ? logicalStart + j : logicalEnd - j;
                        char uchar = bidiBase.text[m];
                        if (BidiBase.IsBidiControlChar(uchar)) continue;
                        indexMap[k++] = m;
                    }
                }
                ++i;
                visualStart += length;
            }
        }
        if (allocLength == bidiBase.resultLength) {
            return indexMap;
        }
        int[] newMap = new int[bidiBase.resultLength];
        System.arraycopy(indexMap, 0, newMap, 0, bidiBase.resultLength);
        return newMap;
    }
}

