/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.icu.text;

import java.text.CharacterIterator;
import jdk.internal.icu.impl.CharacterIteratorWrapper;
import jdk.internal.icu.impl.ReplaceableUCharacterIterator;
import jdk.internal.icu.impl.UCharacterProperty;
import jdk.internal.icu.text.UTF16;

public abstract class UCharacterIterator
implements Cloneable {
    public static final int DONE = -1;

    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(String source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(StringBuffer source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(CharacterIterator source) {
        return new CharacterIteratorWrapper(source);
    }

    public abstract int getLength();

    public abstract int getIndex();

    public abstract int next();

    public int nextCodePoint() {
        int ch1 = this.next();
        if (UTF16.isLeadSurrogate((char)ch1)) {
            int ch2 = this.next();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return UCharacterProperty.getRawSupplementary((char)ch1, (char)ch2);
            }
            if (ch2 != -1) {
                this.previous();
            }
        }
        return ch1;
    }

    public abstract int previous();

    public int previousCodePoint() {
        int ch1 = this.previous();
        if (UTF16.isTrailSurrogate((char)ch1)) {
            int ch2 = this.previous();
            if (UTF16.isLeadSurrogate((char)ch2)) {
                return UCharacterProperty.getRawSupplementary((char)ch2, (char)ch1);
            }
            if (ch2 != -1) {
                this.next();
            }
        }
        return ch1;
    }

    public abstract void setIndex(int var1);

    public void setToStart() {
        this.setIndex(0);
    }

    public abstract int getText(char[] var1, int var2);

    public final int getText(char[] fillIn) {
        return this.getText(fillIn, 0);
    }

    public String getText() {
        char[] text = new char[this.getLength()];
        this.getText(text);
        return new String(text);
    }

    public int moveCodePointIndex(int delta) {
        if (delta > 0) {
            while (delta > 0 && this.nextCodePoint() != -1) {
                --delta;
            }
        } else {
            while (delta < 0 && this.previousCodePoint() != -1) {
                ++delta;
            }
        }
        if (delta != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getIndex();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

