/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.invoke;

import java.lang.invoke.MethodType;
import java.util.Objects;
import jdk.internal.invoke.ABIDescriptorProxy;
import jdk.internal.invoke.VMStorageProxy;

public class NativeEntryPoint {
    private final int shadowSpace;
    private final long[] argMoves;
    private final long[] returnMoves;
    private final boolean needTransition;
    private final MethodType methodType;
    private final String name;

    private NativeEntryPoint(int shadowSpace, long[] argMoves, long[] returnMoves, boolean needTransition, MethodType methodType, String name) {
        this.shadowSpace = shadowSpace;
        this.argMoves = Objects.requireNonNull(argMoves);
        this.returnMoves = Objects.requireNonNull(returnMoves);
        this.needTransition = needTransition;
        this.methodType = methodType;
        this.name = name;
    }

    public static NativeEntryPoint make(String name, ABIDescriptorProxy abi, VMStorageProxy[] argMoves, VMStorageProxy[] returnMoves, boolean needTransition, MethodType methodType) {
        if (returnMoves.length > 1) {
            throw new IllegalArgumentException("Multiple register return not supported");
        }
        return new NativeEntryPoint(abi.shadowSpaceBytes(), NativeEntryPoint.encodeVMStorages(argMoves), NativeEntryPoint.encodeVMStorages(returnMoves), needTransition, methodType, name);
    }

    private static long[] encodeVMStorages(VMStorageProxy[] moves) {
        long[] out = new long[moves.length];
        for (int i = 0; i < moves.length; ++i) {
            out[i] = NativeEntryPoint.vmStorageToVMReg(moves[i].type(), moves[i].index());
        }
        return out;
    }

    private static native long vmStorageToVMReg(int var0, int var1);

    public MethodType type() {
        return this.methodType;
    }

    private static native void registerNatives();

    static {
        NativeEntryPoint.registerNatives();
    }
}

