/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jmod;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JmodFile
implements AutoCloseable {
    private static final int JMOD_MAJOR_VERSION = 1;
    private static final int JMOD_MINOR_VERSION = 0;
    private static final byte[] JMOD_MAGIC_NUMBER = new byte[]{74, 77, 1, 0};
    private final Path file;
    private final ZipFile zipfile;

    public static void checkMagic(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            byte[] magic = in.readNBytes(4);
            if (magic.length != 4) {
                throw new IOException("Invalid JMOD file: " + file);
            }
            if (magic[0] != JMOD_MAGIC_NUMBER[0] || magic[1] != JMOD_MAGIC_NUMBER[1]) {
                throw new IOException("Invalid JMOD file: " + file.toString());
            }
            if (magic[2] > 1 || magic[2] == 1 && magic[3] > 0) {
                throw new IOException("Unsupported jmod version: " + magic[2] + "." + magic[3] + " in " + file.toString());
            }
        }
    }

    public JmodFile(Path file) throws IOException {
        JmodFile.checkMagic(file);
        this.file = file;
        this.zipfile = new ZipFile(file.toFile());
    }

    public static void writeMagicNumber(OutputStream os) throws IOException {
        os.write(JMOD_MAGIC_NUMBER);
    }

    public Entry getEntry(Section section, String name) {
        String entry = section.jmodDir() + "/" + name;
        ZipEntry ze = this.zipfile.getEntry(entry);
        return ze != null ? new Entry(ze) : null;
    }

    public InputStream getInputStream(Section section, String name) throws IOException {
        String entry = section.jmodDir() + "/" + name;
        ZipEntry e = this.zipfile.getEntry(entry);
        if (e == null) {
            throw new IOException(name + " not found: " + this.file);
        }
        return this.zipfile.getInputStream(e);
    }

    public InputStream getInputStream(Entry entry) throws IOException {
        return this.zipfile.getInputStream(entry.zipEntry());
    }

    public Stream<Entry> stream() {
        return this.zipfile.stream().map(Entry::new);
    }

    @Override
    public void close() throws IOException {
        if (this.zipfile != null) {
            this.zipfile.close();
        }
    }

    public static enum Section {
        CLASSES("classes"),
        CONFIG("conf"),
        HEADER_FILES("include"),
        LEGAL_NOTICES("legal"),
        MAN_PAGES("man"),
        NATIVE_LIBS("lib"),
        NATIVE_CMDS("bin");

        private final String jmodDir;

        private Section(String jmodDir) {
            this.jmodDir = jmodDir;
        }

        public String jmodDir() {
            return this.jmodDir;
        }
    }

    public static class Entry {
        private final ZipEntry zipEntry;
        private final Section section;
        private final String name;
        static final Map<String, Section> NAME_TO_SECTION = Arrays.stream(Section.values()).collect(Collectors.toMap(Section::jmodDir, Function.identity()));

        private Entry(ZipEntry e) {
            String name = e.getName();
            int i = name.indexOf(47);
            if (i <= 1) {
                throw new RuntimeException("invalid jmod entry: " + name);
            }
            this.zipEntry = e;
            this.section = Entry.section(name.substring(0, i));
            this.name = name.substring(i + 1);
        }

        public Section section() {
            return this.section;
        }

        public String name() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public long size() {
            return this.zipEntry.getSize();
        }

        public ZipEntry zipEntry() {
            return this.zipEntry;
        }

        public String toString() {
            return this.section.jmodDir() + "/" + this.name;
        }

        static Section section(String name) {
            if (!NAME_TO_SECTION.containsKey(name)) {
                throw new IllegalArgumentException("invalid section: " + name);
            }
            return NAME_TO_SECTION.get(name);
        }
    }
}

