/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.IOException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryStream;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.internal.jrtfs.JrtPath;

final class JrtDirectoryStream
implements DirectoryStream<Path> {
    private final JrtPath dir;
    private final DirectoryStream.Filter<? super Path> filter;
    private boolean isClosed;
    private Iterator<Path> itr;

    JrtDirectoryStream(JrtPath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        this.dir = dir;
        if (!dir.jrtfs.isDirectory(dir, true)) {
            throw new NotDirectoryException(dir.toString());
        }
        this.filter = filter;
    }

    @Override
    public synchronized Iterator<Path> iterator() {
        if (this.isClosed) {
            throw new ClosedDirectoryStreamException();
        }
        if (this.itr != null) {
            throw new IllegalStateException("Iterator has already been returned");
        }
        try {
            this.itr = this.dir.jrtfs.iteratorOf(this.dir, this.filter);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new Iterator<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                JrtDirectoryStream jrtDirectoryStream = JrtDirectoryStream.this;
                synchronized (jrtDirectoryStream) {
                    if (JrtDirectoryStream.this.isClosed) {
                        return false;
                    }
                    return JrtDirectoryStream.this.itr.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Path next() {
                JrtDirectoryStream jrtDirectoryStream = JrtDirectoryStream.this;
                synchronized (jrtDirectoryStream) {
                    if (JrtDirectoryStream.this.isClosed) {
                        throw new NoSuchElementException();
                    }
                    return JrtDirectoryStream.this.itr.next();
                }
            }
        };
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
    }
}

