/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;

public abstract class AbstractClassLoaderValue<CLV extends AbstractClassLoaderValue<CLV, V>, V> {
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();

    AbstractClassLoaderValue() {
    }

    public abstract Object key();

    public <K> Sub<K> sub(K key) {
        return new Sub<K>(key);
    }

    public abstract boolean isEqualOrDescendantOf(AbstractClassLoaderValue<?, V> var1);

    public V get(ClassLoader cl) {
        Object val = AbstractClassLoaderValue.map(cl).get(this);
        try {
            return this.extractValue(val);
        }
        catch (Memoizer.RecursiveInvocationException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public V putIfAbsent(ClassLoader cl, V v) {
        ConcurrentHashMap<CLV, Object> map = AbstractClassLoaderValue.map(cl);
        AbstractClassLoaderValue clv = this;
        while (true) {
            try {
                Object val = map.putIfAbsent(clv, v);
                return this.extractValue(val);
            }
            catch (Memoizer.RecursiveInvocationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public boolean remove(ClassLoader cl, Object v) {
        return AbstractClassLoaderValue.map(cl).remove(this, v);
    }

    public V computeIfAbsent(ClassLoader cl, BiFunction<? super ClassLoader, ? super CLV, ? extends V> mappingFunction) throws IllegalStateException {
        ConcurrentHashMap<CLV, Object> map = AbstractClassLoaderValue.map(cl);
        AbstractClassLoaderValue clv = this;
        Memoizer<CLV, V> mv = null;
        while (true) {
            Object val;
            Object object2 = val = mv == null ? map.get(clv) : map.putIfAbsent(clv, mv);
            if (val == null) {
                if (mv == null) {
                    mv = new Memoizer<CLV, V>(cl, clv, mappingFunction);
                    continue;
                }
                try {
                    Object v = mv.get();
                    map.replace(clv, mv, v);
                    return v;
                }
                catch (Throwable t) {
                    map.remove(clv, mv);
                    throw t;
                }
            }
            try {
                return this.extractValue(val);
            }
            catch (Memoizer.RecursiveInvocationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void removeAll(ClassLoader cl) {
        ConcurrentHashMap<CLV, Object> map = AbstractClassLoaderValue.map(cl);
        Iterator i = ((ConcurrentHashMap.KeySetView)map.keySet()).iterator();
        while (i.hasNext()) {
            if (!((AbstractClassLoaderValue)i.next()).isEqualOrDescendantOf(this)) continue;
            i.remove();
        }
    }

    private static <CLV extends AbstractClassLoaderValue<CLV, ?>> ConcurrentHashMap<CLV, Object> map(ClassLoader cl) {
        return cl == null ? BootLoader.getClassLoaderValueMap() : JLA.createOrGetClassLoaderValueMap(cl);
    }

    private V extractValue(Object memoizerOrValue) {
        if (memoizerOrValue instanceof Memoizer) {
            return ((Memoizer)memoizerOrValue).get();
        }
        return (V)memoizerOrValue;
    }

    public final class Sub<K>
    extends AbstractClassLoaderValue<Sub<K>, V> {
        private final K key;

        Sub(K key) {
            this.key = key;
        }

        public AbstractClassLoaderValue<CLV, V> parent() {
            return AbstractClassLoaderValue.this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public boolean isEqualOrDescendantOf(AbstractClassLoaderValue<?, V> clv) {
            return this.equals(Objects.requireNonNull(clv)) || this.parent().isEqualOrDescendantOf(clv);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sub)) {
                return false;
            }
            Sub that = (Sub)o;
            return this.parent().equals(that.parent()) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return 31 * this.parent().hashCode() + Objects.hashCode(this.key);
        }
    }

    private static final class Memoizer<CLV extends AbstractClassLoaderValue<CLV, V>, V>
    implements Supplier<V> {
        private final ClassLoader cl;
        private final CLV clv;
        private final BiFunction<? super ClassLoader, ? super CLV, ? extends V> mappingFunction;
        private volatile V v;
        private volatile Throwable t;
        private boolean inCall;

        Memoizer(ClassLoader cl, CLV clv, BiFunction<? super ClassLoader, ? super CLV, ? extends V> mappingFunction) {
            this.cl = cl;
            this.clv = clv;
            this.mappingFunction = mappingFunction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws RecursiveInvocationException {
            V v = this.v;
            if (v != null) {
                return v;
            }
            Throwable t = this.t;
            if (t == null) {
                Memoizer memoizer = this;
                synchronized (memoizer) {
                    v = this.v;
                    if (v == null && (t = this.t) == null) {
                        if (this.inCall) {
                            throw new RecursiveInvocationException();
                        }
                        this.inCall = true;
                        try {
                            this.v = v = Objects.requireNonNull(this.mappingFunction.apply(this.cl, this.clv));
                        }
                        catch (Throwable x) {
                            this.t = t = x;
                        }
                        finally {
                            this.inCall = false;
                        }
                    }
                }
            }
            if (v != null) {
                return v;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }

        static class RecursiveInvocationException
        extends IllegalStateException {
            private static final long serialVersionUID = 1L;

            RecursiveInvocationException() {
                super("Recursive call");
            }
        }
    }
}

