/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.util.Map;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.misc.CDS;
import jdk.internal.module.ServicesCatalog;

class ArchivedClassLoaders {
    private static ArchivedClassLoaders archivedClassLoaders;
    private final ClassLoader bootLoader = ClassLoaders.bootLoader();
    private final ClassLoader platformLoader = ClassLoaders.platformClassLoader();
    private final ClassLoader appLoader = ClassLoaders.appClassLoader();
    private final ServicesCatalog[] servicesCatalogs = new ServicesCatalog[3];
    private final Map<String, ?> packageToModule;

    private ArchivedClassLoaders() {
        this.servicesCatalogs[0] = ServicesCatalog.getServicesCatalog(this.bootLoader);
        this.servicesCatalogs[1] = ServicesCatalog.getServicesCatalog(this.platformLoader);
        this.servicesCatalogs[2] = ServicesCatalog.getServicesCatalog(this.appLoader);
        this.packageToModule = BuiltinClassLoader.packageToModule();
    }

    ClassLoader bootLoader() {
        return this.bootLoader;
    }

    ClassLoader platformLoader() {
        return this.platformLoader;
    }

    ClassLoader appLoader() {
        return this.appLoader;
    }

    ServicesCatalog servicesCatalog(ClassLoader loader) {
        if (loader == this.bootLoader) {
            return this.servicesCatalogs[0];
        }
        if (loader == this.platformLoader) {
            return this.servicesCatalogs[1];
        }
        if (loader == this.appLoader) {
            return this.servicesCatalogs[2];
        }
        throw new InternalError();
    }

    Map<String, ?> packageToModule() {
        return this.packageToModule;
    }

    static void archive() {
        archivedClassLoaders = new ArchivedClassLoaders();
    }

    static ArchivedClassLoaders get() {
        return archivedClassLoaders;
    }

    static {
        CDS.initializeFromArchive(ArchivedClassLoaders.class);
    }
}

