/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.NativeLibraries;
import jdk.internal.module.Modules;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.util.StaticProperty;

public class BootLoader {
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();
    private static final Module UNNAMED_MODULE;
    private static final String JAVA_HOME;
    private static final ConcurrentHashMap<?, ?> CLASS_LOADER_VALUE_MAP;
    private static final NativeLibraries NATIVE_LIBS;

    private BootLoader() {
    }

    public static Module getUnnamedModule() {
        return UNNAMED_MODULE;
    }

    public static ServicesCatalog getServicesCatalog() {
        return ServicesCatalog.getServicesCatalog(ClassLoaders.bootLoader());
    }

    public static ConcurrentHashMap<?, ?> getClassLoaderValueMap() {
        return CLASS_LOADER_VALUE_MAP;
    }

    public static NativeLibraries getNativeLibraries() {
        return NATIVE_LIBS;
    }

    public static boolean hasClassPath() {
        return ClassLoaders.bootLoader().hasClassPath();
    }

    public static void loadModule(ModuleReference mref) {
        ClassLoaders.bootLoader().loadModule(mref);
    }

    public static Class<?> loadClassOrNull(String name) {
        return JLA.findBootstrapClassOrNull(name);
    }

    public static Class<?> loadClass(Module module, String name) {
        Class<?> c = BootLoader.loadClassOrNull(name);
        if (c != null && c.getModule() == module) {
            return c;
        }
        return null;
    }

    public static void loadLibrary(final String name) {
        if (System.getSecurityManager() == null) {
            BootLoader.getNativeLibraries().loadLibrary(name);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    BootLoader.getNativeLibraries().loadLibrary(name);
                    return null;
                }
            });
        }
    }

    public static URL findResource(String mn, String name) throws IOException {
        return ClassLoaders.bootLoader().findResource(mn, name);
    }

    public static InputStream findResourceAsStream(String mn, String name) throws IOException {
        return ClassLoaders.bootLoader().findResourceAsStream(mn, name);
    }

    public static URL findResource(String name) {
        return ClassLoaders.bootLoader().findResource(name);
    }

    public static Enumeration<URL> findResources(String name) throws IOException {
        return ClassLoaders.bootLoader().findResources(name);
    }

    public static Package definePackage(Class<?> c) {
        return BootLoader.getDefinedPackage(c.getPackageName());
    }

    public static Package getDefinedPackage(String pn) {
        String location;
        Package pkg = ClassLoaders.bootLoader().getDefinedPackage(pn);
        if (pkg == null && (location = BootLoader.getSystemPackageLocation(pn.replace('.', '/'))) != null) {
            pkg = PackageHelper.definePackage(pn.intern(), location);
        }
        return pkg;
    }

    public static Stream<Package> packages() {
        return Arrays.stream(BootLoader.getSystemPackageNames()).map(name -> BootLoader.getDefinedPackage(name.replace('/', '.')));
    }

    private static native String[] getSystemPackageNames();

    private static native String getSystemPackageLocation(String var0);

    private static native void setBootLoaderUnnamedModule0(Module var0);

    static {
        JAVA_HOME = StaticProperty.javaHome();
        JavaLangAccess jla = SharedSecrets.getJavaLangAccess();
        UNNAMED_MODULE = jla.defineUnnamedModule(null);
        jla.addEnableNativeAccess(UNNAMED_MODULE);
        BootLoader.setBootLoaderUnnamedModule0(UNNAMED_MODULE);
        CLASS_LOADER_VALUE_MAP = new ConcurrentHashMap();
        NATIVE_LIBS = NativeLibraries.jniNativeLibraries(null);
    }

    static class PackageHelper {
        private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();

        PackageHelper() {
        }

        static Package definePackage(String name, String location) {
            Module module = PackageHelper.findModule(location);
            if (module != null) {
                if (name.isEmpty()) {
                    throw new InternalError("empty package in " + location);
                }
                return JLA.definePackage(ClassLoaders.bootLoader(), name, module);
            }
            URL url = PackageHelper.toFileURL(location);
            Manifest man = url != null ? PackageHelper.getManifest(location) : null;
            return ClassLoaders.bootLoader().defineOrCheckPackage(name, man, url);
        }

        private static Module findModule(String location) {
            String mn = null;
            if (location.startsWith("jrt:/")) {
                mn = location.substring(5, location.length());
            } else if (location.startsWith("file:/")) {
                Path path = Path.of(URI.create(location));
                Path modulesDir = Path.of(JAVA_HOME, "modules");
                if (path.startsWith(modulesDir)) {
                    mn = path.getFileName().toString();
                }
            }
            if (mn != null) {
                String name = mn;
                return Modules.findLoadedModule(mn).orElseThrow(() -> new InternalError(name + " not loaded"));
            }
            return null;
        }

        private static URL toFileURL(final String location) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    Path path = Path.of(location, new String[0]);
                    if (Files.isRegularFile(path, new LinkOption[0])) {
                        try {
                            return path.toUri().toURL();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }

        private static Manifest getManifest(final String location) {
            return AccessController.doPrivileged(new PrivilegedAction<Manifest>(){

                /*
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Manifest run() {
                    Path jar = Path.of(location, new String[0]);
                    try (InputStream in = Files.newInputStream(jar, new OpenOption[0]);){
                        Manifest manifest;
                        try (JarInputStream jis = new JarInputStream(in, false);){
                            manifest = jis.getManifest();
                        }
                        return manifest;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
    }
}

