/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.ArchivedClassLoaders;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.Resource;
import jdk.internal.loader.URLClassPath;
import jdk.internal.misc.VM;
import jdk.internal.module.ModulePatcher;
import jdk.internal.module.Resources;
import jdk.internal.vm.annotation.Stable;
import sun.security.util.LazyCodeSourcePermissionCollection;

public class BuiltinClassLoader
extends SecureClassLoader {
    private final BuiltinClassLoader parent;
    @Stable
    private URLClassPath ucp;
    private static final Map<String, LoadedModule> packageToModule;
    private final Map<String, ModuleReference> nameToModule;
    private final Map<ModuleReference, ModuleReader> moduleToReader;
    private volatile SoftReference<Map<String, List<URL>>> resourceCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    static Map<String, ?> packageToModule() {
        return packageToModule;
    }

    BuiltinClassLoader(String name, BuiltinClassLoader parent, URLClassPath ucp) {
        super(name, parent == null || parent == ClassLoaders.bootLoader() ? null : parent);
        this.parent = parent;
        this.ucp = ucp;
        this.nameToModule = new ConcurrentHashMap<String, ModuleReference>(32);
        this.moduleToReader = new ConcurrentHashMap<ModuleReference, ModuleReader>();
    }

    void appendClassPath(String path) {
        this.ucp.addFile(path);
    }

    void setClassPath(URLClassPath ucp) {
        this.ucp = ucp;
    }

    boolean hasClassPath() {
        return this.ucp != null;
    }

    public void loadModule(ModuleReference mref) {
        ModuleDescriptor descriptor = mref.descriptor();
        String mn = descriptor.name();
        if (this.nameToModule.putIfAbsent(mn, mref) != null) {
            throw new InternalError(mn + " already defined to this loader");
        }
        LoadedModule loadedModule = new LoadedModule(this, mref);
        for (String pn : descriptor.packages()) {
            LoadedModule other = packageToModule.putIfAbsent(pn, loadedModule);
            if (other == null) continue;
            throw new InternalError(pn + " in modules " + mn + " and " + other.name());
        }
        if (this.resourceCache != null && VM.isModuleSystemInited()) {
            this.resourceCache = null;
        }
    }

    protected ModuleReference findModule(String name) {
        return this.nameToModule.get(name);
    }

    @Override
    public URL findResource(String mn, String name) throws IOException {
        URL url = null;
        if (mn != null) {
            ModuleReference mref = this.nameToModule.get(mn);
            if (mref != null) {
                url = this.findResource(mref, name);
            }
        } else {
            url = this.findResourceOnClassPath(name);
        }
        return BuiltinClassLoader.checkURL(url);
    }

    public InputStream findResourceAsStream(String mn, String name) throws IOException {
        if (System.getSecurityManager() != null || mn == null) {
            URL url = this.findResource(mn, name);
            return url != null ? url.openStream() : null;
        }
        ModuleReference mref = this.nameToModule.get(mn);
        if (mref != null) {
            return this.moduleReaderFor(mref).open(name).orElse(null);
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        URL url;
        String pn = Resources.toPackageName(name);
        LoadedModule module = packageToModule.get(pn);
        if (module != null) {
            if (module.loader() == this) {
                try {
                    url = this.findResource(module.name(), name);
                }
                catch (IOException ioe) {
                    return null;
                }
                if (url != null && (name.endsWith(".class") || url.toString().endsWith("/") || this.isOpen(module.mref(), pn))) {
                    return url;
                }
            }
        } else {
            try {
                URL url2;
                List<URL> urls = this.findMiscResource(name);
                if (!urls.isEmpty() && (url2 = urls.get(0)) != null) {
                    return BuiltinClassLoader.checkURL(url2);
                }
            }
            catch (IOException ioe) {
                return null;
            }
        }
        url = this.findResourceOnClassPath(name);
        return BuiltinClassLoader.checkURL(url);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final ArrayList<Object> checked = new ArrayList<Object>();
        String pn = Resources.toPackageName(name);
        LoadedModule module = packageToModule.get(pn);
        if (module != null) {
            Object url;
            if (module.loader() == this && (url = this.findResource(module.name(), name)) != null && (name.endsWith(".class") || ((URL)url).toString().endsWith("/") || this.isOpen(module.mref(), pn))) {
                checked.add(url);
            }
        } else {
            for (URL url : this.findMiscResource(name)) {
                if ((url = BuiltinClassLoader.checkURL(url)) == null) continue;
                checked.add(url);
            }
        }
        final Enumeration<URL> e = this.findResourcesOnClassPath(name);
        return new Enumeration<URL>(){
            final Iterator<URL> iterator;
            URL next;
            {
                this.iterator = checked.iterator();
            }

            private boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    return true;
                }
                while (e.hasMoreElements() && this.next == null) {
                    this.next = BuiltinClassLoader.checkURL((URL)e.nextElement());
                }
                return this.next != null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasNext();
            }

            @Override
            public URL nextElement() {
                if (this.hasNext()) {
                    URL result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private List<URL> findMiscResource(final String name) throws IOException {
        List<URL> urls;
        Map<String, List<URL>> map;
        SoftReference<Map<String, List<URL>>> ref = this.resourceCache;
        Map<String, List<URL>> map2 = map = ref != null ? ref.get() : null;
        if (map == null) {
            if (VM.isModuleSystemInited()) {
                map = new ConcurrentHashMap<String, List<URL>>();
                this.resourceCache = new SoftReference<Map<String, List<URL>>>(map);
            }
        } else {
            urls = map.get(name);
            if (urls != null) {
                return urls;
            }
        }
        try {
            urls = AccessController.doPrivileged(new PrivilegedExceptionAction<List<URL>>(){

                @Override
                public List<URL> run() throws IOException {
                    List<URL> result = null;
                    for (ModuleReference mref : BuiltinClassLoader.this.nameToModule.values()) {
                        URI u = BuiltinClassLoader.this.moduleReaderFor(mref).find(name).orElse(null);
                        if (u == null) continue;
                        try {
                            if (result == null) {
                                result = new ArrayList<URL>();
                            }
                            result.add(u.toURL());
                        }
                        catch (IllegalArgumentException | MalformedURLException exception) {}
                    }
                    return result != null ? result : Collections.emptyList();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        if (map != null) {
            map.putIfAbsent(name, urls);
        }
        return urls;
    }

    private URL findResource(final ModuleReference mref, final String name) throws IOException {
        URI u;
        if (System.getSecurityManager() == null) {
            u = this.moduleReaderFor(mref).find(name).orElse(null);
        } else {
            try {
                u = AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){

                    @Override
                    public URI run() throws IOException {
                        return BuiltinClassLoader.this.moduleReaderFor(mref).find(name).orElse(null);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getCause();
            }
        }
        if (u != null) {
            try {
                return u.toURL();
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private URL findResourceOrNull(ModuleReference mref, String name) {
        try {
            return this.findResource(mref, name);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private URL findResourceOnClassPath(String name) {
        if (this.hasClassPath()) {
            if (System.getSecurityManager() == null) {
                return this.ucp.findResource(name, false);
            }
            PrivilegedAction<URL> pa = () -> this.ucp.findResource(name, false);
            return AccessController.doPrivileged(pa);
        }
        return null;
    }

    private Enumeration<URL> findResourcesOnClassPath(String name) {
        if (this.hasClassPath()) {
            if (System.getSecurityManager() == null) {
                return this.ucp.findResources(name, false);
            }
            PrivilegedAction<Enumeration> pa = () -> this.ucp.findResources(name, false);
            return AccessController.doPrivileged(pa);
        }
        return Collections.emptyEnumeration();
    }

    @Override
    protected Class<?> findClass(String cn) throws ClassNotFoundException {
        if (!VM.isModuleSystemInited()) {
            throw new ClassNotFoundException(cn);
        }
        LoadedModule loadedModule = this.findLoadedModule(cn);
        Class<?> c = null;
        if (loadedModule != null) {
            if (loadedModule.loader() == this) {
                c = this.findClassInModuleOrNull(loadedModule, cn);
            }
        } else if (this.hasClassPath()) {
            c = this.findClassOnClassPathOrNull(cn);
        }
        if (c == null) {
            throw new ClassNotFoundException(cn);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String mn, String cn) {
        if (mn != null) {
            LoadedModule loadedModule = this.findLoadedModule(mn, cn);
            if (loadedModule == null) {
                return null;
            }
            if (!$assertionsDisabled && loadedModule.loader() != this) {
                throw new AssertionError();
            }
            return this.findClassInModuleOrNull(loadedModule, cn);
        }
        if (this.hasClassPath()) {
            return this.findClassOnClassPathOrNull(cn);
        }
        return null;
    }

    @Override
    protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.loadClassOrNull(cn, resolve);
        if (c == null) {
            throw new ClassNotFoundException(cn);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClassOrNull(String cn, boolean resolve) {
        Object object2 = this.getClassLoadingLock(cn);
        synchronized (object2) {
            Class<?> c = this.findLoadedClass(cn);
            if (c == null) {
                LoadedModule loadedModule = this.findLoadedModule(cn);
                if (loadedModule != null) {
                    BuiltinClassLoader loader = loadedModule.loader();
                    if (loader == this) {
                        if (VM.isModuleSystemInited()) {
                            c = this.findClassInModuleOrNull(loadedModule, cn);
                        }
                    } else {
                        c = loader.loadClassOrNull(cn);
                    }
                } else {
                    if (this.parent != null) {
                        c = this.parent.loadClassOrNull(cn);
                    }
                    if (c == null && this.hasClassPath() && VM.isModuleSystemInited()) {
                        c = this.findClassOnClassPathOrNull(cn);
                    }
                }
            }
            if (resolve && c != null) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected final Class<?> loadClassOrNull(String cn) {
        return this.loadClassOrNull(cn, false);
    }

    private LoadedModule findLoadedModule(String cn) {
        int pos = cn.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String pn = cn.substring(0, pos);
        return packageToModule.get(pn);
    }

    private LoadedModule findLoadedModule(String mn, String cn) {
        LoadedModule loadedModule = this.findLoadedModule(cn);
        if (loadedModule != null && mn.equals(loadedModule.name())) {
            return loadedModule;
        }
        return null;
    }

    private Class<?> findClassInModuleOrNull(LoadedModule loadedModule, String cn) {
        if (System.getSecurityManager() == null) {
            return this.defineClass(cn, loadedModule);
        }
        PrivilegedAction<Class> pa = () -> this.defineClass(cn, loadedModule);
        return AccessController.doPrivileged(pa);
    }

    private Class<?> findClassOnClassPathOrNull(final String cn) {
        final String path = cn.replace('.', '/').concat(".class");
        if (System.getSecurityManager() == null) {
            Resource res = this.ucp.getResource(path, false);
            if (res != null) {
                try {
                    return this.defineClass(cn, res);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        PrivilegedAction pa = new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                Resource res = BuiltinClassLoader.this.ucp.getResource(path, false);
                if (res != null) {
                    try {
                        return BuiltinClassLoader.this.defineClass(cn, res);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        return (Class)AccessController.doPrivileged(pa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String cn, LoadedModule loadedModule) {
        ModuleReference mref = loadedModule.mref();
        ModuleReader reader = this.moduleReaderFor(mref);
        ByteBuffer bb = null;
        URL csURL = null;
        String rn = cn.replace('.', '/').concat(".class");
        if (reader instanceof ModulePatcher.PatchedModuleReader) {
            Resource r = ((ModulePatcher.PatchedModuleReader)reader).findResource(rn);
            if (r != null) {
                bb = r.getByteBuffer();
                csURL = r.getCodeSourceURL();
            }
        } else {
            bb = reader.read(rn).orElse(null);
            csURL = loadedModule.codeSourceURL();
        }
        if (bb == null) {
            return null;
        }
        CodeSource cs = new CodeSource(csURL, (CodeSigner[])null);
        try {
            Class<?> clazz = this.defineClass(cn, bb, cs);
            reader.release(bb);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                reader.release(bb);
                throw throwable;
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    private Class<?> defineClass(String cn, Resource res) throws IOException {
        ByteBuffer bb;
        URL url = res.getCodeSourceURL();
        int pos = cn.lastIndexOf(46);
        if (pos != -1) {
            String pn = cn.substring(0, pos);
            Manifest man = res.getManifest();
            this.defineOrCheckPackage(pn, man, url);
        }
        if ((bb = res.getByteBuffer()) != null) {
            CodeSigner[] signers = res.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(cn, bb, cs);
        }
        byte[] b = res.getBytes();
        CodeSigner[] signers = res.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(cn, b, 0, b.length, cs);
    }

    protected Package defineOrCheckPackage(String pn, Manifest man, URL url) {
        Package pkg;
        block3: {
            pkg = this.getAndVerifyPackage(pn, man, url);
            if (pkg == null) {
                try {
                    pkg = man != null ? this.definePackage(pn, man, url) : this.definePackage(pn, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException iae) {
                    pkg = this.getAndVerifyPackage(pn, man, url);
                    if (pkg != null) break block3;
                    throw new InternalError("Cannot find package: " + pn);
                }
            }
        }
        return pkg;
    }

    private Package getAndVerifyPackage(String pn, Manifest man, URL url) {
        Package pkg = this.getDefinedPackage(pn);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("sealing violation: package " + pn + " is sealed");
                }
            } else if (man != null && this.isSealed(pn, man)) {
                throw new SecurityException("sealing violation: can't seal package " + pn + ": already defined");
            }
        }
        return pkg;
    }

    private Package definePackage(String pn, Manifest man, URL url) {
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        if (man != null) {
            Attributes attr = SharedSecrets.javaUtilJarAccess().getTrustedAttributes(man, pn.replace('.', '/').concat("/"));
            if (attr != null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
            if ((attr = man.getMainAttributes()) != null) {
                if (specTitle == null) {
                    specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
                }
                if (specVersion == null) {
                    specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                }
                if (specVendor == null) {
                    specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if (implTitle == null) {
                    implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                }
                if (implVersion == null) {
                    implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if (implVendor == null) {
                    implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
                if (sealed == null) {
                    sealed = attr.getValue(Attributes.Name.SEALED);
                }
            }
            if ("true".equalsIgnoreCase(sealed)) {
                sealBase = url;
            }
        }
        return this.definePackage(pn, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private boolean isSealed(String pn, Manifest man) {
        Attributes attr = SharedSecrets.javaUtilJarAccess().getTrustedAttributes(man, pn.replace('.', '/').concat("/"));
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        return new LazyCodeSourcePermissionCollection(super.getPermissions(cs), cs);
    }

    private ModuleReader moduleReaderFor(final ModuleReference mref) {
        ModuleReader reader = this.moduleToReader.get(mref);
        if (reader == null) {
            Function<ModuleReference, ModuleReader> create = new Function<ModuleReference, ModuleReader>(){

                @Override
                public ModuleReader apply(ModuleReference moduleReference) {
                    try {
                        return mref.open();
                    }
                    catch (IOException e) {
                        return new NullModuleReader();
                    }
                }
            };
            reader = this.moduleToReader.computeIfAbsent(mref, create);
        }
        return reader;
    }

    private boolean isOpen(ModuleReference mref, String pn) {
        ModuleDescriptor descriptor = mref.descriptor();
        if (descriptor.isOpen() || descriptor.isAutomatic()) {
            return true;
        }
        for (ModuleDescriptor.Opens opens : descriptor.opens()) {
            String source = opens.source();
            if (opens.isQualified() || !source.equals(pn)) continue;
            return true;
        }
        return false;
    }

    private static URL checkURL(URL url) {
        return URLClassPath.checkURL(url);
    }

    private void resetArchivedStates() {
        this.ucp = null;
    }

    static {
        boolean bl = $assertionsDisabled = !BuiltinClassLoader.class.desiredAssertionStatus();
        if (!ClassLoader.registerAsParallelCapable()) {
            throw new InternalError("Unable to register as parallel capable");
        }
        ArchivedClassLoaders archivedClassLoaders = ArchivedClassLoaders.get();
        if (archivedClassLoaders != null) {
            Map<String, ?> map = archivedClassLoaders.packageToModule();
            packageToModule = map;
        } else {
            packageToModule = new ConcurrentHashMap<String, LoadedModule>(1024);
        }
    }

    private static class LoadedModule {
        private final BuiltinClassLoader loader;
        private final ModuleReference mref;
        private final URI uri;
        @Stable
        private URL codeSourceURL;

        LoadedModule(BuiltinClassLoader loader, ModuleReference mref) {
            URL url = null;
            this.uri = mref.location().orElse(null);
            if (this.uri != null && !"jrt".equals(this.uri.getScheme())) {
                url = this.createURL(this.uri);
            }
            this.loader = loader;
            this.mref = mref;
            this.codeSourceURL = url;
        }

        BuiltinClassLoader loader() {
            return this.loader;
        }

        ModuleReference mref() {
            return this.mref;
        }

        String name() {
            return this.mref.descriptor().name();
        }

        URL codeSourceURL() {
            URL url = this.codeSourceURL;
            if (url == null && this.uri != null) {
                this.codeSourceURL = url = this.createURL(this.uri);
            }
            return url;
        }

        private URL createURL(URI uri) {
            URL url = null;
            try {
                url = uri.toURL();
            }
            catch (IllegalArgumentException | MalformedURLException exception) {
                // empty catch block
            }
            return url;
        }
    }

    private static class NullModuleReader
    implements ModuleReader {
        private NullModuleReader() {
        }

        @Override
        public Optional<URI> find(String name) {
            return Optional.empty();
        }

        @Override
        public Stream<String> list() {
            return Stream.empty();
        }

        @Override
        public void close() {
            throw new InternalError("Should not get here");
        }
    }
}

