/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.jar.Manifest;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.ArchivedClassLoaders;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.URLClassPath;
import jdk.internal.misc.VM;
import jdk.internal.module.ServicesCatalog;

public class ClassLoaders {
    private static final JavaLangAccess JLA;
    private static final BootClassLoader BOOT_LOADER;
    private static final PlatformClassLoader PLATFORM_LOADER;
    private static final AppClassLoader APP_LOADER;

    private ClassLoaders() {
    }

    private static void setArchivedServicesCatalog(ClassLoader loader) {
        ServicesCatalog catalog = ArchivedClassLoaders.get().servicesCatalog(loader);
        ServicesCatalog.putServicesCatalog(loader, catalog);
    }

    static BuiltinClassLoader bootLoader() {
        return BOOT_LOADER;
    }

    public static ClassLoader platformClassLoader() {
        return PLATFORM_LOADER;
    }

    public static ClassLoader appClassLoader() {
        return APP_LOADER;
    }

    @Deprecated
    private static URL toFileURL(String s) {
        try {
            return Path.of(s, new String[0]).toRealPath(new LinkOption[0]).toFile().toURI().toURL();
        }
        catch (IOException | InvalidPathException ignore) {
            return null;
        }
    }

    static {
        URLClassPath ucp;
        JLA = SharedSecrets.getJavaLangAccess();
        ArchivedClassLoaders archivedClassLoaders = ArchivedClassLoaders.get();
        if (archivedClassLoaders != null) {
            BOOT_LOADER = (BootClassLoader)archivedClassLoaders.bootLoader();
            ClassLoaders.setArchivedServicesCatalog(BOOT_LOADER);
            PLATFORM_LOADER = (PlatformClassLoader)archivedClassLoaders.platformLoader();
            ClassLoaders.setArchivedServicesCatalog(PLATFORM_LOADER);
        } else {
            String append = VM.getSavedProperty("jdk.boot.class.path.append");
            ucp = append != null && !append.isEmpty() ? new URLClassPath(append, true) : null;
            BOOT_LOADER = new BootClassLoader(ucp);
            PLATFORM_LOADER = new PlatformClassLoader(BOOT_LOADER);
        }
        String cp = System.getProperty("java.class.path");
        if (cp == null || cp.isEmpty()) {
            String initialModuleName = System.getProperty("jdk.module.main");
            cp = initialModuleName == null ? "" : null;
        }
        ucp = new URLClassPath(cp, false);
        if (archivedClassLoaders != null) {
            APP_LOADER = (AppClassLoader)archivedClassLoaders.appLoader();
            ClassLoaders.setArchivedServicesCatalog(APP_LOADER);
            APP_LOADER.setClassPath(ucp);
        } else {
            APP_LOADER = new AppClassLoader(PLATFORM_LOADER, ucp);
            ArchivedClassLoaders.archive();
        }
    }

    private static class BootClassLoader
    extends BuiltinClassLoader {
        BootClassLoader(URLClassPath bcp) {
            super(null, null, bcp);
        }

        @Override
        protected Class<?> loadClassOrNull(String cn, boolean resolve) {
            return JLA.findBootstrapClassOrNull(cn);
        }
    }

    private static class PlatformClassLoader
    extends BuiltinClassLoader {
        PlatformClassLoader(BootClassLoader parent) {
            super("platform", parent, null);
        }

        static {
            if (!ClassLoader.registerAsParallelCapable()) {
                throw new InternalError();
            }
        }
    }

    private static class AppClassLoader
    extends BuiltinClassLoader {
        AppClassLoader(BuiltinClassLoader parent, URLClassPath ucp) {
            super("app", parent, ucp);
        }

        @Override
        protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
            int i;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (i = cn.lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(cn.substring(0, i));
            }
            return super.loadClass(cn, resolve);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource cs) {
            PermissionCollection perms = super.getPermissions(cs);
            perms.add(new RuntimePermission("exitVM"));
            return perms;
        }

        void appendToClassPathForInstrumentation(String path) {
            this.appendClassPath(path);
        }

        @Override
        protected Package defineOrCheckPackage(String pn, Manifest man, URL url) {
            return super.defineOrCheckPackage(pn, man, url);
        }

        private void resetArchivedStates() {
            this.setClassPath(null);
        }

        static {
            if (!ClassLoader.registerAsParallelCapable()) {
                throw new InternalError();
            }
        }
    }
}

