/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.LoaderPool;
import jdk.internal.loader.URLClassPath;
import jdk.internal.module.Resources;

public final class Loader
extends SecureClassLoader {
    private final LoaderPool pool;
    private final ClassLoader parent;
    private final Map<String, ModuleReference> nameToModule;
    private final Map<String, LoadedModule> localPackageToModule;
    private final Map<String, ClassLoader> remotePackageToLoader = new ConcurrentHashMap<String, ClassLoader>();
    private final Map<ModuleReference, ModuleReader> moduleToReader = new ConcurrentHashMap<ModuleReference, ModuleReader>();
    private final AccessControlContext acc;

    public Loader(ResolvedModule resolvedModule, LoaderPool pool, ClassLoader parent) {
        super("Loader-" + resolvedModule.name(), parent);
        this.pool = pool;
        this.parent = parent;
        ModuleReference mref = resolvedModule.reference();
        ModuleDescriptor descriptor = mref.descriptor();
        String mn = descriptor.name();
        this.nameToModule = Map.of(mn, mref);
        HashMap<String, LoadedModule> localPackageToModule = new HashMap<String, LoadedModule>();
        LoadedModule lm = new LoadedModule(mref);
        descriptor.packages().forEach(pn -> localPackageToModule.put((String)pn, lm));
        this.localPackageToModule = localPackageToModule;
        this.acc = AccessController.getContext();
    }

    public Loader(Collection<ResolvedModule> modules, ClassLoader parent) {
        super(parent);
        this.pool = null;
        this.parent = parent;
        HashMap<String, ModuleReference> nameToModule = new HashMap<String, ModuleReference>();
        HashMap<String, LoadedModule> localPackageToModule = new HashMap<String, LoadedModule>();
        for (ResolvedModule resolvedModule : modules) {
            ModuleReference mref = resolvedModule.reference();
            ModuleDescriptor descriptor = mref.descriptor();
            nameToModule.put(descriptor.name(), mref);
            descriptor.packages().forEach(pn -> {
                LoadedModule lm = new LoadedModule(mref);
                if (localPackageToModule.put((String)pn, lm) != null) {
                    throw new IllegalArgumentException("Package " + pn + " in more than one module");
                }
            });
        }
        this.nameToModule = nameToModule;
        this.localPackageToModule = localPackageToModule;
        this.acc = AccessController.getContext();
    }

    public Loader initRemotePackageMap(Configuration cf, List<ModuleLayer> parentModuleLayers) {
        for (String name : this.nameToModule.keySet()) {
            ResolvedModule resolvedModule = cf.findModule(name).get();
            assert (resolvedModule.configuration() == cf);
            for (ResolvedModule other : resolvedModule.reads()) {
                ModuleDescriptor descriptor;
                ClassLoader loader;
                String mn = other.name();
                if (other.configuration() == cf) {
                    if (this.pool == null) {
                        assert (this.nameToModule.containsKey(mn));
                        continue;
                    }
                    loader = this.pool.loaderFor(mn);
                    assert (loader != null);
                } else {
                    ModuleLayer layer = (ModuleLayer)parentModuleLayers.stream().map(parent -> this.findModuleLayer((ModuleLayer)parent, other.configuration())).flatMap(Optional::stream).findAny().orElseThrow(() -> new InternalError("Unable to find parent layer"));
                    assert (layer.findModule(mn).isPresent());
                    loader = layer.findLoader(mn);
                    if (loader == null) {
                        loader = ClassLoaders.platformClassLoader();
                    }
                }
                if ((descriptor = other.reference().descriptor()).isAutomatic()) {
                    Loader l = loader;
                    descriptor.packages().forEach(pn -> this.remotePackage((String)pn, l));
                    continue;
                }
                String target = resolvedModule.name();
                for (ModuleDescriptor.Exports e : descriptor.exports()) {
                    boolean delegate = e.isQualified() ? other.configuration() == cf && e.targets().contains(target) : true;
                    if (!delegate) continue;
                    this.remotePackage(e.source(), loader);
                }
            }
        }
        return this;
    }

    private void remotePackage(String pn, ClassLoader loader) {
        ClassLoader l = this.remotePackageToLoader.putIfAbsent(pn, loader);
        if (l != null && l != loader) {
            throw new IllegalStateException("Package " + pn + " cannot be imported from multiple loaders");
        }
    }

    private Optional<ModuleLayer> findModuleLayer(ModuleLayer parent, Configuration cf) {
        return SharedSecrets.getJavaLangAccess().layers(parent).filter(l -> l.configuration() == cf).findAny();
    }

    public LoaderPool pool() {
        return this.pool;
    }

    @Override
    protected URL findResource(String mn, final String name) throws IOException {
        ModuleReference mref;
        ModuleReference moduleReference = mref = mn != null ? this.nameToModule.get(mn) : null;
        if (mref == null) {
            return null;
        }
        URL url = null;
        try {
            url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws IOException {
                    Optional<URI> ouri = Loader.this.moduleReaderFor(mref).find(name);
                    if (ouri.isPresent()) {
                        try {
                            return ouri.get().toURL();
                        }
                        catch (IllegalArgumentException | MalformedURLException exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
        if (url != null && System.getSecurityManager() != null) {
            try {
                final URL urlToCheck = url;
                url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws IOException {
                        return URLClassPath.checkURL(urlToCheck);
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                url = null;
            }
        }
        return url;
    }

    @Override
    public URL findResource(String name) {
        String pn = Resources.toPackageName(name);
        LoadedModule module = this.localPackageToModule.get(pn);
        if (module != null) {
            try {
                URL url = this.findResource(module.name(), name);
                if (url != null && (name.endsWith(".class") || url.toString().endsWith("/") || this.isOpen(module.mref(), pn))) {
                    return url;
                }
            }
            catch (IOException iOException) {}
        } else {
            for (ModuleReference mref : this.nameToModule.values()) {
                try {
                    URL url = this.findResource(mref.descriptor().name(), name);
                    if (url == null) continue;
                    return url;
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return Collections.enumeration(this.findResourcesAsList(name));
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.findResource(name);
        if (url == null) {
            url = this.parent != null ? this.parent.getResource(name) : BootLoader.findResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        final List<URL> urls = this.findResourcesAsList(name);
        final Enumeration<URL> e = this.parent != null ? this.parent.getResources(name) : BootLoader.findResources(name);
        return new Enumeration<URL>(){
            final Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext() || e.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return (URL)e.nextElement();
            }
        };
    }

    private List<URL> findResourcesAsList(String name) throws IOException {
        String pn = Resources.toPackageName(name);
        LoadedModule module = this.localPackageToModule.get(pn);
        if (module != null) {
            URL url = this.findResource(module.name(), name);
            if (url != null && (name.endsWith(".class") || url.toString().endsWith("/") || this.isOpen(module.mref(), pn))) {
                return List.of(url);
            }
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ModuleReference mref : this.nameToModule.values()) {
            URL url = this.findResource(mref.descriptor().name(), name);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    @Override
    protected Class<?> findClass(String cn) throws ClassNotFoundException {
        Class<?> c = null;
        LoadedModule loadedModule = this.findLoadedModule(cn);
        if (loadedModule != null) {
            c = this.findClassInModuleOrNull(loadedModule, cn);
        }
        if (c == null) {
            throw new ClassNotFoundException(cn);
        }
        return c;
    }

    @Override
    protected Class<?> findClass(String mn, String cn) {
        Class<?> c = null;
        LoadedModule loadedModule = this.findLoadedModule(cn);
        if (loadedModule != null && loadedModule.name().equals(mn)) {
            c = this.findClassInModuleOrNull(loadedModule, cn);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
        String pn;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !(pn = this.packageName(cn)).isEmpty()) {
            sm.checkPackageAccess(pn);
        }
        Object object2 = this.getClassLoadingLock(cn);
        synchronized (object2) {
            Class<?> c = this.findLoadedClass(cn);
            if (c == null) {
                LoadedModule loadedModule = this.findLoadedModule(cn);
                if (loadedModule != null) {
                    c = this.findClassInModuleOrNull(loadedModule, cn);
                } else {
                    String pn2 = this.packageName(cn);
                    ClassLoader loader = this.remotePackageToLoader.get(pn2);
                    if (loader == null) {
                        loader = this.parent;
                    }
                    c = loader == null ? BootLoader.loadClassOrNull(cn) : loader.loadClass(cn);
                }
            }
            if (c == null) {
                throw new ClassNotFoundException(cn);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private Class<?> findClassInModuleOrNull(LoadedModule loadedModule, String cn) {
        PrivilegedAction<Class> pa = () -> this.defineClass(cn, loadedModule);
        return AccessController.doPrivileged(pa, this.acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> defineClass(String cn, LoadedModule loadedModule) {
        ModuleReader reader = this.moduleReaderFor(loadedModule.mref());
        String rn = cn.replace('.', '/').concat(".class");
        ByteBuffer bb = reader.read(rn).orElse(null);
        if (bb == null) {
            return null;
        }
        try {
            Class<?> clazz = this.defineClass(cn, bb, loadedModule.codeSource());
            reader.release(bb);
            return clazz;
        }
        catch (Throwable throwable) {
            try {
                reader.release(bb);
                throw throwable;
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection perms = super.getPermissions(cs);
        URL url = cs.getLocation();
        if (url == null) {
            return perms;
        }
        try {
            Permission p = url.openConnection().getPermission();
            if (p != null) {
                String path;
                if (p instanceof FilePermission && (path = p.getName()).endsWith(File.separator)) {
                    path = path + "-";
                    p = new FilePermission(path, "read");
                }
                perms.add(p);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return perms;
    }

    private LoadedModule findLoadedModule(String cn) {
        String pn = this.packageName(cn);
        return pn.isEmpty() ? null : this.localPackageToModule.get(pn);
    }

    private String packageName(String cn) {
        int pos = cn.lastIndexOf(46);
        return pos < 0 ? "" : cn.substring(0, pos);
    }

    private ModuleReader moduleReaderFor(ModuleReference mref) {
        return this.moduleToReader.computeIfAbsent(mref, m -> this.createModuleReader(mref));
    }

    private ModuleReader createModuleReader(ModuleReference mref) {
        try {
            return mref.open();
        }
        catch (IOException e) {
            return new NullModuleReader();
        }
    }

    private boolean isOpen(ModuleReference mref, String pn) {
        ModuleDescriptor descriptor = mref.descriptor();
        if (descriptor.isOpen() || descriptor.isAutomatic()) {
            return true;
        }
        for (ModuleDescriptor.Opens opens : descriptor.opens()) {
            String source = opens.source();
            if (opens.isQualified() || !source.equals(pn)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class LoadedModule {
        private final ModuleReference mref;
        private final URL url;
        private final CodeSource cs;

        LoadedModule(ModuleReference mref) {
            URL url = null;
            if (mref.location().isPresent()) {
                try {
                    url = mref.location().get().toURL();
                }
                catch (IllegalArgumentException | MalformedURLException exception) {
                    // empty catch block
                }
            }
            this.mref = mref;
            this.url = url;
            this.cs = new CodeSource(url, (CodeSigner[])null);
        }

        ModuleReference mref() {
            return this.mref;
        }

        String name() {
            return this.mref.descriptor().name();
        }

        URL location() {
            return this.url;
        }

        CodeSource codeSource() {
            return this.cs;
        }
    }

    private static class NullModuleReader
    implements ModuleReader {
        private NullModuleReader() {
        }

        @Override
        public Optional<URI> find(String name) {
            return Optional.empty();
        }

        @Override
        public Stream<String> list() {
            return Stream.empty();
        }

        @Override
        public void close() {
            throw new InternalError("Should not get here");
        }
    }
}

