/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import jdk.internal.loader.Loader;

public final class LoaderPool {
    private final Map<String, Loader> loaders;

    public LoaderPool(Configuration cf, List<ModuleLayer> parentLayers, ClassLoader parentLoader) {
        HashMap<String, Loader> loaders = new HashMap<String, Loader>();
        for (ResolvedModule resolvedModule : cf.modules()) {
            Loader loader = new Loader(resolvedModule, this, parentLoader);
            String mn = resolvedModule.name();
            loaders.put(mn, loader);
        }
        this.loaders = loaders;
        loaders.values().forEach(l -> l.initRemotePackageMap(cf, parentLayers));
    }

    public Loader loaderFor(String name) {
        Loader loader = this.loaders.get(name);
        assert (loader != null);
        return loader;
    }

    public Stream<Loader> loaders() {
        return this.loaders.values().stream();
    }
}

