/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.loader.ClassLoaderHelper;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.NativeLibrary;
import jdk.internal.misc.VM;
import jdk.internal.ref.CleanerFactory;
import jdk.internal.util.StaticProperty;

public final class NativeLibraries {
    private static final boolean loadLibraryOnlyIfPresent = ClassLoaderHelper.loadLibraryOnlyIfPresent();
    private final Map<String, NativeLibraryImpl> libraries = new ConcurrentHashMap<String, NativeLibraryImpl>();
    private final ClassLoader loader;
    private final Class<?> caller;
    private final boolean searchJavaLibraryPath;
    private final boolean isJNI;
    private static final Set<String> loadedLibraryNames = new HashSet<String>();
    private static Deque<NativeLibraryImpl> nativeLibraryContext = new ArrayDeque<NativeLibraryImpl>(8);

    public static NativeLibraries jniNativeLibraries(ClassLoader loader) {
        return new NativeLibraries(loader);
    }

    public static NativeLibraries rawNativeLibraries(Class<?> trustedCaller, boolean searchJavaLibraryPath) {
        return new NativeLibraries(trustedCaller, searchJavaLibraryPath);
    }

    private NativeLibraries(ClassLoader loader) {
        this.loader = loader;
        this.caller = loader != null ? null : NativeLibraries.class;
        this.searchJavaLibraryPath = loader != null;
        this.isJNI = true;
    }

    private NativeLibraries(Class<?> caller, boolean searchJavaLibraryPath) {
        Objects.requireNonNull(caller);
        if (!VM.isSystemDomainLoader(caller.getClassLoader())) {
            throw new IllegalArgumentException("must be JDK trusted class");
        }
        this.loader = caller.getClassLoader();
        this.caller = caller;
        this.searchJavaLibraryPath = searchJavaLibraryPath;
        this.isJNI = false;
    }

    public long find(String name) {
        if (this.libraries.isEmpty()) {
            return 0L;
        }
        for (NativeLibrary nativeLibrary : this.libraries.values()) {
            long entry = nativeLibrary.find(name);
            if (entry == 0L) continue;
            return entry;
        }
        return 0L;
    }

    public NativeLibrary loadLibrary(Class<?> fromClass, final File file) {
        boolean isBuiltin;
        String name = NativeLibraries.findBuiltinLib(file.getName());
        boolean bl = isBuiltin = name != null;
        if (!isBuiltin && (name = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    if (loadLibraryOnlyIfPresent && !file.exists()) {
                        return null;
                    }
                    return file.getCanonicalPath();
                }
                catch (IOException e) {
                    return null;
                }
            }
        })) == null) {
            return null;
        }
        return this.loadLibrary(fromClass, name, isBuiltin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NativeLibrary loadLibrary(Class<?> fromClass, String name, boolean isBuiltin) {
        ClassLoader loader;
        ClassLoader classLoader = loader = fromClass == null ? null : fromClass.getClassLoader();
        if (this.loader != loader) {
            throw new InternalError(fromClass.getName() + " not allowed to load library");
        }
        Set<String> set = loadedLibraryNames;
        synchronized (set) {
            NativeLibrary cached = this.libraries.get(name);
            if (cached != null) {
                return cached;
            }
            if (loadedLibraryNames.contains(name)) {
                throw new UnsatisfiedLinkError("Native Library " + name + " already loaded in another classloader");
            }
            for (NativeLibraryImpl lib2222 : nativeLibraryContext) {
                if (!name.equals(lib2222.name())) continue;
                if (loader == lib2222.fromClass.getClassLoader()) {
                    return lib2222;
                }
                throw new UnsatisfiedLinkError("Native Library " + name + " is being loaded in another classloader");
            }
            NativeLibraryImpl lib = new NativeLibraryImpl(fromClass, name, isBuiltin, this.isJNI);
            nativeLibraryContext.push(lib);
            try {
                boolean autoUnload;
                if (!lib.open()) {
                    NativeLibraryImpl lib2222;
                    lib2222 = null;
                    return lib2222;
                }
                boolean bl = autoUnload = this.isJNI && !VM.isSystemDomainLoader(loader) && loader != ClassLoaders.appClassLoader();
                if (autoUnload) {
                    CleanerFactory.cleaner().register(loader, lib.unloader());
                }
            }
            finally {
                nativeLibraryContext.pop();
            }
            loadedLibraryNames.add(name);
            this.libraries.put(name, lib);
            return lib;
        }
    }

    public NativeLibrary loadLibrary(String name) {
        assert (name.indexOf(File.separatorChar) < 0);
        assert (this.caller != null);
        return this.loadLibrary(this.caller, name);
    }

    public NativeLibrary loadLibrary(Class<?> fromClass, String name) {
        assert (name.indexOf(File.separatorChar) < 0);
        NativeLibrary lib = this.findFromPaths(LibraryPaths.SYS_PATHS, fromClass, name);
        if (lib == null && this.searchJavaLibraryPath) {
            lib = this.findFromPaths(LibraryPaths.USER_PATHS, fromClass, name);
        }
        return lib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(NativeLibrary lib) {
        if (this.isJNI) {
            throw new UnsupportedOperationException("explicit unloading cannot be used with auto unloading");
        }
        Objects.requireNonNull(lib);
        Set<String> set = loadedLibraryNames;
        synchronized (set) {
            NativeLibraryImpl nl = this.libraries.remove(lib.name());
            if (nl != lib) {
                throw new IllegalArgumentException(lib.name() + " not loaded by this NativeLibraries instance");
            }
            nl.unloader().run();
        }
    }

    private NativeLibrary findFromPaths(String[] paths, Class<?> fromClass, String name) {
        for (String path : paths) {
            File libfile = new File(path, System.mapLibraryName(name));
            NativeLibrary nl = this.loadLibrary(fromClass, libfile);
            if (nl != null) {
                return nl;
            }
            if ((libfile = ClassLoaderHelper.mapAlternativeName(libfile)) == null || (nl = this.loadLibrary(fromClass, libfile)) == null) continue;
            return nl;
        }
        return null;
    }

    private static Class<?> getFromClass() {
        if (nativeLibraryContext.isEmpty()) {
            return Object.class;
        }
        return NativeLibraries.nativeLibraryContext.peek().fromClass;
    }

    private static native boolean load(NativeLibraryImpl var0, String var1, boolean var2, boolean var3, boolean var4);

    private static native void unload(String var0, boolean var1, boolean var2, long var3);

    private static native String findBuiltinLib(String var0);

    private static native long findEntry0(NativeLibraryImpl var0, String var1);

    static class NativeLibraryImpl
    implements NativeLibrary {
        final Class<?> fromClass;
        final String name;
        final boolean isBuiltin;
        final boolean isJNI;
        long handle;
        int jniVersion;

        NativeLibraryImpl(Class<?> fromClass, String name, boolean isBuiltin, boolean isJNI) {
            assert (!isBuiltin || isJNI) : "a builtin native library must be JNI library";
            this.fromClass = fromClass;
            this.name = name;
            this.isBuiltin = isBuiltin;
            this.isJNI = isJNI;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public long find(String name) {
            return NativeLibraries.findEntry0(this, name);
        }

        Runnable unloader() {
            return new Unloader(this.name, this.handle, this.isBuiltin, this.isJNI);
        }

        boolean open() {
            if (this.handle != 0L) {
                throw new InternalError("Native library " + this.name + " has been loaded");
            }
            return NativeLibraries.load(this, this.name, this.isBuiltin, this.isJNI, loadLibraryOnlyIfPresent);
        }
    }

    static class LibraryPaths {
        static final String[] SYS_PATHS = ClassLoaderHelper.parsePath(StaticProperty.sunBootLibraryPath());
        static final String[] USER_PATHS = ClassLoaderHelper.parsePath(StaticProperty.javaLibraryPath());

        LibraryPaths() {
        }
    }

    static class Unloader
    implements Runnable {
        static final NativeLibraryImpl UNLOADER = new NativeLibraryImpl(null, "dummy", false, false);
        final String name;
        final long handle;
        final boolean isBuiltin;
        final boolean isJNI;

        Unloader(String name, long handle, boolean isBuiltin, boolean isJNI) {
            assert (!isBuiltin || isJNI) : "a builtin native library must be JNI library";
            if (handle == 0L) {
                throw new IllegalArgumentException("Invalid handle for native library " + name);
            }
            this.name = name;
            this.handle = handle;
            this.isBuiltin = isBuiltin;
            this.isJNI = isJNI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<String> set = loadedLibraryNames;
            synchronized (set) {
                if (!loadedLibraryNames.remove(this.name)) {
                    throw new IllegalStateException(this.name + " has already been unloaded");
                }
                nativeLibraryContext.push(UNLOADER);
                try {
                    NativeLibraries.unload(this.name, this.isBuiltin, this.isJNI, this.handle);
                }
                finally {
                    nativeLibraryContext.pop();
                }
            }
        }
    }
}

