/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.loader;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import jdk.internal.access.JavaNetURLAccess;
import jdk.internal.access.JavaUtilZipFileAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.FileURLMapper;
import jdk.internal.loader.Resource;
import jdk.internal.util.jar.InvalidJarIndexError;
import jdk.internal.util.jar.JarIndex;
import sun.net.util.URLUtil;
import sun.net.www.ParseUtil;
import sun.net.www.protocol.jar.Handler;
import sun.security.action.GetPropertyAction;

public class URLClassPath {
    private static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    private static final String JAVA_VERSION;
    private static final boolean DEBUG;
    private static final boolean DISABLE_JAR_CHECKING;
    private static final boolean DISABLE_ACC_CHECKING;
    private static final boolean DISABLE_CP_URL_CHECK;
    private static final boolean DEBUG_CP_URL_CHECK;
    private final ArrayList<URL> path;
    private final ArrayDeque<URL> unopenedUrls;
    private final ArrayList<Loader> loaders = new ArrayList();
    private final HashMap<String, Loader> lmap = new HashMap();
    private final URLStreamHandler jarHandler;
    private boolean closed = false;
    private final AccessControlContext acc;
    private static final JavaNetURLAccess JNUA;

    public URLClassPath(URL[] urls, URLStreamHandlerFactory factory, AccessControlContext acc) {
        ArrayList<URL> path = new ArrayList<URL>(urls.length);
        ArrayDeque<URL> unopenedUrls = new ArrayDeque<URL>(urls.length);
        for (URL url : urls) {
            path.add(url);
            unopenedUrls.add(url);
        }
        this.path = path;
        this.unopenedUrls = unopenedUrls;
        this.jarHandler = factory != null ? factory.createURLStreamHandler("jar") : null;
        this.acc = DISABLE_ACC_CHECKING ? null : acc;
    }

    public URLClassPath(URL[] urls, AccessControlContext acc) {
        this(urls, null, acc);
    }

    URLClassPath(String cp, boolean skipEmptyElements) {
        ArrayList<URL> path = new ArrayList<URL>();
        if (cp != null) {
            int next;
            int off = 0;
            do {
                URL url;
                String element;
                String string = element = (next = cp.indexOf(File.pathSeparator, off)) == -1 ? cp.substring(off) : cp.substring(off, next);
                if (!(element.isEmpty() && skipEmptyElements || (url = URLClassPath.toFileURL(element)) == null)) {
                    path.add(url);
                }
                off = next + 1;
            } while (next != -1);
        }
        int size = path.size();
        ArrayDeque<URL> unopenedUrls = new ArrayDeque<URL>(size);
        for (int i = 0; i < size; ++i) {
            unopenedUrls.add((URL)path.get(i));
        }
        this.unopenedUrls = unopenedUrls;
        this.path = path;
        this.jarHandler = null;
        this.acc = null;
    }

    public synchronized List<IOException> closeLoaders() {
        if (this.closed) {
            return Collections.emptyList();
        }
        LinkedList<IOException> result = new LinkedList<IOException>();
        for (Loader loader : this.loaders) {
            try {
                loader.close();
            }
            catch (IOException e) {
                result.add(e);
            }
        }
        this.closed = true;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addURL(URL url) {
        if (this.closed || url == null) {
            return;
        }
        ArrayDeque<URL> arrayDeque = this.unopenedUrls;
        synchronized (arrayDeque) {
            if (!this.path.contains(url)) {
                this.unopenedUrls.addLast(url);
                this.path.add(url);
            }
        }
    }

    public void addFile(String s) {
        URL url = URLClassPath.toFileURL(s);
        if (url != null) {
            this.addURL(url);
        }
    }

    private static URL toFileURL(String s) {
        try {
            File f = new File(s).getCanonicalFile();
            return ParseUtil.fileToEncodedURL(f);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        ArrayDeque<URL> arrayDeque = this.unopenedUrls;
        synchronized (arrayDeque) {
            return this.path.toArray(new URL[0]);
        }
    }

    public URL findResource(String name, boolean check) {
        Loader loader;
        int i = 0;
        while ((loader = this.getLoader(i)) != null) {
            URL url = loader.findResource(name, check);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    public Resource getResource(String name, boolean check) {
        Loader loader;
        if (DEBUG) {
            System.err.println("URLClassPath.getResource(\"" + name + "\")");
        }
        int i = 0;
        while ((loader = this.getLoader(i)) != null) {
            Resource res = loader.getResource(name, check);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public Enumeration<URL> findResources(final String name, final boolean check) {
        return new Enumeration<URL>(){
            private int index = 0;
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.url = loader.findResource(name, check);
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }
        };
    }

    public Resource getResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<Resource> getResources(final String name, final boolean check) {
        return new Enumeration<Resource>(){
            private int index = 0;
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.res = loader.getResource(name, check);
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public Resource nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource r = this.res;
                this.res = null;
                return r;
            }
        };
    }

    public Enumeration<Resource> getResources(String name) {
        return this.getResources(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(int index) {
        if (this.closed) {
            return null;
        }
        while (this.loaders.size() < index + 1) {
            Loader loader;
            String urlNoFragString;
            block9: {
                URL url;
                ArrayDeque<URL> arrayDeque = this.unopenedUrls;
                synchronized (arrayDeque) {
                    url = this.unopenedUrls.pollFirst();
                    if (url == null) {
                        return null;
                    }
                }
                urlNoFragString = URLUtil.urlNoFragString(url);
                if (this.lmap.containsKey(urlNoFragString)) continue;
                try {
                    loader = this.getLoader(url);
                    URL[] urls = loader.getClassPath();
                    if (urls == null) break block9;
                    this.push(urls);
                }
                catch (IOException e) {
                    continue;
                }
                catch (SecurityException se) {
                    if (!DEBUG) continue;
                    System.err.println("Failed to access " + url + ", " + se);
                    continue;
                }
            }
            this.loaders.add(loader);
            this.lmap.put(urlNoFragString, loader);
        }
        return this.loaders.get(index);
    }

    private Loader getLoader(final URL url) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Loader>(){

                @Override
                public Loader run() throws IOException {
                    String protocol = url.getProtocol();
                    String file = url.getFile();
                    if (file != null && file.endsWith("/")) {
                        if ("file".equals(protocol)) {
                            return new FileLoader(url);
                        }
                        if ("jar".equals(protocol) && URLClassPath.isDefaultJarHandler(url) && file.endsWith("!/")) {
                            URL nestedUrl = new URL(file.substring(0, file.length() - 2));
                            return new JarLoader(nestedUrl, URLClassPath.this.jarHandler, URLClassPath.this.lmap, URLClassPath.this.acc);
                        }
                        return new Loader(url);
                    }
                    return new JarLoader(url, URLClassPath.this.jarHandler, URLClassPath.this.lmap, URLClassPath.this.acc);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private static boolean isDefaultJarHandler(URL u) {
        URLStreamHandler h = JNUA.getHandler(u);
        return h instanceof Handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] urls) {
        ArrayDeque<URL> arrayDeque = this.unopenedUrls;
        synchronized (arrayDeque) {
            for (int i = urls.length - 1; i >= 0; --i) {
                this.unopenedUrls.addFirst(urls[i]);
            }
        }
    }

    public static URL checkURL(URL url) {
        if (url != null) {
            try {
                URLClassPath.check(url);
            }
            catch (Exception e) {
                return null;
            }
        }
        return url;
    }

    public static void check(URL url) throws IOException {
        URLConnection urlConnection;
        Permission perm;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (perm = (urlConnection = url.openConnection()).getPermission()) != null) {
            try {
                security.checkPermission(perm);
            }
            catch (SecurityException se) {
                if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                    security.checkRead(perm.getName());
                }
                if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                    URL locUrl = url;
                    if (urlConnection instanceof JarURLConnection) {
                        locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
                    }
                    security.checkConnect(locUrl.getHost(), locUrl.getPort());
                }
                throw se;
            }
        }
    }

    static {
        Properties props = GetPropertyAction.privilegedGetProperties();
        JAVA_VERSION = props.getProperty("java.version");
        DEBUG = props.getProperty("sun.misc.URLClassPath.debug") != null;
        String p = props.getProperty("sun.misc.URLClassPath.disableJarChecking");
        DISABLE_JAR_CHECKING = p != null ? p.equals("true") || p.isEmpty() : false;
        p = props.getProperty("jdk.net.URLClassPath.disableRestrictedPermissions");
        DISABLE_ACC_CHECKING = p != null ? p.equals("true") || p.isEmpty() : false;
        p = props.getProperty("jdk.net.URLClassPath.disableClassPathURLCheck");
        DISABLE_CP_URL_CHECK = p != null ? p.equals("true") || p.isEmpty() : false;
        p = props.getProperty("jdk.net.URLClassPath.showIgnoredClassPathEntries");
        DEBUG_CP_URL_CHECK = p != null ? p.equals("true") || p.isEmpty() : false;
        JNUA = SharedSecrets.getJavaNetURLAccess();
    }

    private static class Loader
    implements Closeable {
        private final URL base;
        private JarFile jarfile;

        Loader(URL url) {
            this.base = url;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL findResource(String name, boolean check) {
            URL url;
            try {
                url = new URL(this.base, ParseUtil.encodePath(name, false));
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                URLConnection uc;
                if (check) {
                    URLClassPath.check(url);
                }
                if ((uc = url.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection hconn = (HttpURLConnection)uc;
                    hconn.setRequestMethod("HEAD");
                    if (hconn.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    uc.setUseCaches(false);
                    InputStream is = uc.getInputStream();
                    is.close();
                }
                return url;
            }
            catch (Exception e) {
                return null;
            }
        }

        Resource getResource(final String name, boolean check) {
            URLConnection uc;
            URL url;
            try {
                url = new URL(this.base, ParseUtil.encodePath(name, false));
            }
            catch (MalformedURLException e) {
                return null;
            }
            try {
                Object juc;
                if (check) {
                    URLClassPath.check(url);
                }
                if ((uc = url.openConnection()) instanceof JarURLConnection) {
                    juc = (JarURLConnection)uc;
                    this.jarfile = JarLoader.checkJar(((JarURLConnection)juc).getJarFile());
                }
                juc = uc.getInputStream();
            }
            catch (Exception e) {
                return null;
            }
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return base;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return uc.getInputStream();
                }

                @Override
                public int getContentLength() throws IOException {
                    return uc.getContentLength();
                }
            };
        }

        Resource getResource(String name) {
            return this.getResource(name, true);
        }

        @Override
        public void close() throws IOException {
            if (this.jarfile != null) {
                this.jarfile.close();
            }
        }

        URL[] getClassPath() throws IOException {
            return null;
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        private FileLoader(URL url) throws IOException {
            super(url);
            String path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
            this.dir = new File(path).getCanonicalFile();
        }

        @Override
        URL findResource(String name, boolean check) {
            Resource rsc = this.getResource(name, check);
            if (rsc != null) {
                return rsc.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(final String name, boolean check) {
            try {
                File file;
                URL normalizedBase = new URL(this.getBaseURL(), ".");
                final URL url = new URL(this.getBaseURL(), ParseUtil.encodePath(name, false));
                if (!url.getFile().startsWith(normalizedBase.getFile())) {
                    return null;
                }
                if (check) {
                    URLClassPath.check(url);
                }
                if (name.indexOf("..") != -1) {
                    file = new File(this.dir, name.replace('/', File.separatorChar)).getCanonicalFile();
                    if (!file.getPath().startsWith(this.dir.getPath())) {
                        return null;
                    }
                } else {
                    file = new File(this.dir, name.replace('/', File.separatorChar));
                }
                if (file.exists()) {
                    return new Resource(){

                        @Override
                        public String getName() {
                            return name;
                        }

                        @Override
                        public URL getURL() {
                            return url;
                        }

                        @Override
                        public URL getCodeSourceURL() {
                            return this.getBaseURL();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(file);
                        }

                        @Override
                        public int getContentLength() throws IOException {
                            return (int)file.length();
                        }
                    };
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private final URL csu;
        private JarIndex index;
        private URLStreamHandler handler;
        private final HashMap<String, Loader> lmap;
        private final AccessControlContext acc;
        private boolean closed = false;
        private static final JavaUtilZipFileAccess zipAccess = SharedSecrets.getJavaUtilZipFileAccess();

        private JarLoader(URL url, URLStreamHandler jarHandler, HashMap<String, Loader> loaderMap, AccessControlContext acc) throws IOException {
            super(new URL("jar", "", -1, url + "!/", jarHandler));
            this.csu = url;
            this.handler = jarHandler;
            this.lmap = loaderMap;
            this.acc = acc;
            this.ensureOpen();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ensureOpen();
                this.jar.close();
            }
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private boolean isOptimizable(URL url) {
            return "file".equals(url.getProtocol());
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Void run() throws IOException {
                            if (DEBUG) {
                                System.err.println("Opening " + csu);
                                Thread.dumpStack();
                            }
                            jar = this.getJarFile(csu);
                            index = JarIndex.getJarIndex(jar);
                            if (index != null) {
                                String[] jarfiles = index.getJarFiles();
                                for (int i = 0; i < jarfiles.length; ++i) {
                                    try {
                                        URL jarURL = new URL(csu, jarfiles[i]);
                                        String urlNoFragString = URLUtil.urlNoFragString(jarURL);
                                        if (lmap.containsKey(urlNoFragString)) continue;
                                        lmap.put(urlNoFragString, null);
                                        continue;
                                    }
                                    catch (MalformedURLException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    }, this.acc);
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
            }
        }

        static JarFile checkJar(JarFile jar) throws IOException {
            if (System.getSecurityManager() != null && !DISABLE_JAR_CHECKING && !zipAccess.startsWithLocHeader(jar)) {
                IOException x = new IOException("Invalid Jar file");
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    x.addSuppressed(ex);
                }
                throw x;
            }
            return jar;
        }

        private JarFile getJarFile(URL url) throws IOException {
            if (this.isOptimizable(url)) {
                FileURLMapper p = new FileURLMapper(url);
                if (!p.exists()) {
                    throw new FileNotFoundException(p.getPath());
                }
                return JarLoader.checkJar(new JarFile(new File(p.getPath()), true, 1, JarFile.runtimeVersion()));
            }
            URLConnection uc = new URL(this.getBaseURL(), "#runtime").openConnection();
            uc.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            JarFile jarFile = ((JarURLConnection)uc).getJarFile();
            return JarLoader.checkJar(jarFile);
        }

        JarIndex getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
            return this.index;
        }

        Resource checkResource(final String name, boolean check, final JarEntry entry) {
            URL url;
            try {
                String nm = this.jar.isMultiRelease() ? entry.getRealName() : name;
                url = new URL(this.getBaseURL(), ParseUtil.encodePath(nm, false));
                if (check) {
                    URLClassPath.check(url);
                }
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            catch (AccessControlException e) {
                return null;
            }
            return new Resource(){
                private Exception dataError = null;

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    return url;
                }

                @Override
                public URL getCodeSourceURL() {
                    return csu;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return jar.getInputStream(entry);
                }

                @Override
                public int getContentLength() {
                    return (int)entry.getSize();
                }

                @Override
                public Manifest getManifest() throws IOException {
                    SharedSecrets.javaUtilJarAccess().ensureInitialization(jar);
                    return jar.getManifest();
                }

                @Override
                public Certificate[] getCertificates() {
                    return entry.getCertificates();
                }

                @Override
                public CodeSigner[] getCodeSigners() {
                    return entry.getCodeSigners();
                }

                @Override
                public Exception getDataError() {
                    return this.dataError;
                }

                @Override
                public byte[] getBytes() throws IOException {
                    byte[] bytes = super.getBytes();
                    CRC32 crc32 = new CRC32();
                    crc32.update(bytes);
                    if (crc32.getValue() != entry.getCrc()) {
                        this.dataError = new IOException("CRC error while extracting entry from JAR file");
                    }
                    return bytes;
                }
            };
        }

        boolean validIndex(String name) {
            String packageName = name;
            int pos = name.lastIndexOf(47);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Enumeration<JarEntry> enum_ = this.jar.entries();
            while (enum_.hasMoreElements()) {
                ZipEntry entry = enum_.nextElement();
                String entryName = entry.getName();
                pos = entryName.lastIndexOf(47);
                if (pos != -1) {
                    entryName = entryName.substring(0, pos);
                }
                if (!entryName.equals(packageName)) continue;
                return true;
            }
            return false;
        }

        @Override
        URL findResource(String name, boolean check) {
            Resource rsc = this.getResource(name, check);
            if (rsc != null) {
                return rsc.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(String name, boolean check) {
            try {
                this.ensureOpen();
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
            JarEntry entry = this.jar.getJarEntry(name);
            if (entry != null) {
                return this.checkResource(name, check, entry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet<String> visited = new HashSet<String>();
            return this.getResource(name, check, visited);
        }

        Resource getResource(String name, boolean check, Set<String> visited) {
            int count = 0;
            LinkedList<String> jarFilesList = null;
            jarFilesList = this.index.get(name);
            if (jarFilesList == null) {
                return null;
            }
            do {
                int size = jarFilesList.size();
                String[] jarFiles = jarFilesList.toArray(new String[size]);
                while (count < size) {
                    Resource res;
                    boolean visitedURL;
                    JarLoader newLoader;
                    URL url;
                    block12: {
                        String jarName = jarFiles[count++];
                        try {
                            url = new URL(this.csu, jarName);
                            String urlNoFragString = URLUtil.urlNoFragString(url);
                            newLoader = (JarLoader)this.lmap.get(urlNoFragString);
                            if (newLoader != null) break block12;
                            newLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<JarLoader>(){

                                @Override
                                public JarLoader run() throws IOException {
                                    return new JarLoader(url, handler, lmap, acc);
                                }
                            }, this.acc);
                            JarIndex newIndex = newLoader.getIndex();
                            if (newIndex != null) {
                                int pos = jarName.lastIndexOf(47);
                                newIndex.merge(this.index, pos == -1 ? null : jarName.substring(0, pos + 1));
                            }
                            this.lmap.put(urlNoFragString, newLoader);
                        }
                        catch (PrivilegedActionException pae) {
                            continue;
                        }
                        catch (MalformedURLException e) {
                            continue;
                        }
                    }
                    boolean bl = visitedURL = !visited.add(URLUtil.urlNoFragString(url));
                    if (!visitedURL) {
                        try {
                            newLoader.ensureOpen();
                        }
                        catch (IOException e) {
                            throw new InternalError(e);
                        }
                        JarEntry entry = newLoader.jar.getJarEntry(name);
                        if (entry != null) {
                            return newLoader.checkResource(name, check, entry);
                        }
                        if (!newLoader.validIndex(name)) {
                            throw new InvalidJarIndexError("Invalid index");
                        }
                    }
                    if (visitedURL || newLoader == this || newLoader.getIndex() == null || (res = newLoader.getResource(name, check, visited)) == null) continue;
                    return res;
                }
            } while (count < (jarFilesList = this.index.get(name)).size());
            return null;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String value;
            Attributes attr;
            Manifest man;
            if (this.index != null) {
                return null;
            }
            this.ensureOpen();
            if (SharedSecrets.javaUtilJarAccess().jarFileHasClassPathAttribute(this.jar) && (man = this.jar.getManifest()) != null && (attr = man.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return JarLoader.parseClassPath(this.csu, value);
            }
            return null;
        }

        private static URL[] parseClassPath(URL base, String value) throws MalformedURLException {
            StringTokenizer st = new StringTokenizer(value);
            URL[] urls = new URL[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                URL url;
                String path = st.nextToken();
                URL uRL = url = DISABLE_CP_URL_CHECK ? new URL(base, path) : JarLoader.tryResolve(base, path);
                if (url != null) {
                    urls[i] = url;
                    ++i;
                    continue;
                }
                if (!DEBUG_CP_URL_CHECK) continue;
                System.err.println("Class-Path entry: \"" + path + "\" ignored in JAR file " + base);
            }
            if (i == 0) {
                urls = null;
            } else if (i != urls.length) {
                urls = Arrays.copyOf(urls, i);
            }
            return urls;
        }

        static URL tryResolve(URL base, String input) throws MalformedURLException {
            if ("file".equalsIgnoreCase(base.getProtocol())) {
                return JarLoader.tryResolveFile(base, input);
            }
            return JarLoader.tryResolveNonFile(base, input);
        }

        static URL tryResolveFile(URL base, String input) throws MalformedURLException {
            URL retVal = new URL(base, input);
            if (input.indexOf(58) >= 0 && !"file".equalsIgnoreCase(retVal.getProtocol())) {
                return null;
            }
            return retVal;
        }

        static URL tryResolveNonFile(URL base, String input) throws MalformedURLException {
            String child = input.replace(File.separatorChar, '/');
            if (JarLoader.isRelative(child)) {
                URL url = new URL(base, child);
                String bp = base.getPath();
                String urlp = url.getPath();
                int pos = bp.lastIndexOf(47);
                if (pos == -1) {
                    pos = bp.length() - 1;
                }
                if (urlp.regionMatches(0, bp, 0, pos + 1) && urlp.indexOf("..", pos) == -1) {
                    return url;
                }
            }
            return null;
        }

        static boolean isRelative(String child) {
            try {
                return !URI.create(child).isAbsolute();
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

