/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.logger;

import java.util.ResourceBundle;
import java.util.function.Supplier;
import jdk.internal.logger.LoggerWrapper;
import sun.util.logging.PlatformLogger;

public class LocalizedLoggerWrapper<L extends System.Logger>
extends LoggerWrapper<L> {
    private final ResourceBundle bundle;

    public LocalizedLoggerWrapper(L wrapped, ResourceBundle bundle) {
        super(wrapped);
        this.bundle = bundle;
    }

    public final ResourceBundle getBundle() {
        return this.bundle;
    }

    @Override
    public final void log(System.Logger.Level level, String msg) {
        this.log(level, this.bundle, msg, (Object[])null);
    }

    @Override
    public final void log(System.Logger.Level level, String msg, Throwable thrown) {
        this.log(level, this.bundle, msg, thrown);
    }

    @Override
    public final void log(System.Logger.Level level, String format, Object ... params) {
        this.log(level, this.bundle, format, params);
    }

    @Override
    public final void log(System.Logger.Level level, Object obj) {
        this.wrapped.log(level, obj);
    }

    @Override
    public final void log(System.Logger.Level level, Supplier<String> msgSupplier) {
        this.wrapped.log(level, msgSupplier);
    }

    @Override
    public final void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
        this.wrapped.log(level, msgSupplier, thrown);
    }

    @Override
    public final void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        this.wrapped.log(level, bundle, format, params);
    }

    @Override
    public final void log(System.Logger.Level level, ResourceBundle bundle, String key, Throwable thrown) {
        this.wrapped.log(level, bundle, key, thrown);
    }

    @Override
    public final boolean isLoggable(System.Logger.Level level) {
        return this.wrapped.isLoggable(level);
    }

    @Override
    public final void logp(PlatformLogger.Level level, String sourceClass, String sourceMethod, String key) {
        this.logrb(level, sourceClass, sourceMethod, this.bundle, key, (Object[])null);
    }

    @Override
    public final void logp(PlatformLogger.Level level, String sourceClass, String sourceMethod, String key, Throwable thrown) {
        this.logrb(level, sourceClass, sourceMethod, this.bundle, key, thrown);
    }

    @Override
    public final void logp(PlatformLogger.Level level, String sourceClass, String sourceMethod, String key, Object ... params) {
        this.logrb(level, sourceClass, sourceMethod, this.bundle, key, params);
    }

    @Override
    public final void log(PlatformLogger.Level level, String msg, Throwable thrown) {
        this.logrb(level, this.bundle, msg, thrown);
    }

    @Override
    public final void log(PlatformLogger.Level level, String msg) {
        this.logrb(level, this.bundle, msg, (Object[])null);
    }

    @Override
    public final void log(PlatformLogger.Level level, String format, Object ... params) {
        this.logrb(level, this.bundle, format, params);
    }
}

