/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class ExtendedMapMode {
    static final MethodHandle MAP_MODE_CONSTRUCTOR;
    public static final FileChannel.MapMode READ_ONLY_SYNC;
    public static final FileChannel.MapMode READ_WRITE_SYNC;

    private static FileChannel.MapMode newMapMode(String name) {
        try {
            return MAP_MODE_CONSTRUCTOR.invoke(name);
        }
        catch (Throwable e) {
            throw new InternalError(e);
        }
    }

    private ExtendedMapMode() {
    }

    static {
        try {
            PrivilegedExceptionAction<MethodHandles.Lookup> pae = () -> MethodHandles.privateLookupIn(FileChannel.MapMode.class, MethodHandles.lookup());
            MethodHandles.Lookup lookup = AccessController.doPrivileged(pae);
            MethodType methodType = MethodType.methodType(Void.TYPE, String.class);
            MAP_MODE_CONSTRUCTOR = lookup.findConstructor(FileChannel.MapMode.class, methodType);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
        READ_ONLY_SYNC = ExtendedMapMode.newMapMode("READ_ONLY_SYNC");
        READ_WRITE_SYNC = ExtendedMapMode.newMapMode("READ_WRITE_SYNC");
    }
}

