/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.misc.Unsafe;

public final class InnocuousThread
extends Thread {
    private static final Unsafe UNSAFE;
    private static final long THREAD_LOCALS;
    private static final long INHERITABLE_THREAD_LOCALS;
    private static final ThreadGroup INNOCUOUSTHREADGROUP;
    private static final AccessControlContext ACC;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private static final long CONTEXTCLASSLOADER;
    private static final AtomicInteger threadNumber;
    private volatile boolean hasRun;

    private static String newName() {
        return "InnocuousThread-" + threadNumber.getAndIncrement();
    }

    public static Thread newThread(Runnable target) {
        return InnocuousThread.newThread(InnocuousThread.newName(), target);
    }

    public static Thread newThread(String name, Runnable target) {
        return InnocuousThread.newThread(name, target, -1);
    }

    public static Thread newThread(final String name, final Runnable target, final int priority) {
        if (System.getSecurityManager() == null) {
            return InnocuousThread.createThread(name, target, ClassLoader.getSystemClassLoader(), priority);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return InnocuousThread.createThread(name, target, ClassLoader.getSystemClassLoader(), priority);
            }
        });
    }

    public static Thread newSystemThread(Runnable target) {
        return InnocuousThread.newSystemThread(InnocuousThread.newName(), target);
    }

    public static Thread newSystemThread(String name, Runnable target) {
        return InnocuousThread.newSystemThread(name, target, -1);
    }

    public static Thread newSystemThread(final String name, final Runnable target, final int priority) {
        if (System.getSecurityManager() == null) {
            return InnocuousThread.createThread(name, target, null, priority);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return InnocuousThread.createThread(name, target, null, priority);
            }
        });
    }

    private static Thread createThread(String name, Runnable target, ClassLoader loader, int priority) {
        InnocuousThread t = new InnocuousThread(INNOCUOUSTHREADGROUP, target, name, loader);
        if (priority >= 0) {
            t.setPriority(priority);
        }
        return t;
    }

    private InnocuousThread(ThreadGroup group, Runnable target, String name, ClassLoader tccl) {
        super(group, target, name, 0L, false);
        UNSAFE.putReferenceRelease(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        UNSAFE.putReferenceRelease(this, CONTEXTCLASSLOADER, tccl);
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        if (cl != null) {
            throw new SecurityException("setContextClassLoader");
        }
        super.setContextClassLoader(null);
    }

    public final void eraseThreadLocals() {
        UNSAFE.putReference(this, THREAD_LOCALS, null);
        UNSAFE.putReference(this, INHERITABLE_THREAD_LOCALS, null);
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this && !this.hasRun) {
            this.hasRun = true;
            super.run();
        }
    }

    static {
        threadNumber = new AtomicInteger(1);
        try {
            ThreadGroup parent;
            ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> tk = Thread.class;
            Class<ThreadGroup> gk = ThreadGroup.class;
            THREAD_LOCALS = UNSAFE.objectFieldOffset(tk, "threadLocals");
            INHERITABLE_THREAD_LOCALS = UNSAFE.objectFieldOffset(tk, "inheritableThreadLocals");
            INHERITEDACCESSCONTROLCONTEXT = UNSAFE.objectFieldOffset(tk, "inheritedAccessControlContext");
            CONTEXTCLASSLOADER = UNSAFE.objectFieldOffset(tk, "contextClassLoader");
            long tg = UNSAFE.objectFieldOffset(tk, "group");
            long gp = UNSAFE.objectFieldOffset(gk, "parent");
            ThreadGroup group = (ThreadGroup)UNSAFE.getReference(Thread.currentThread(), tg);
            while (group != null && (parent = (ThreadGroup)UNSAFE.getReference(group, gp)) != null) {
                group = parent;
            }
            final ThreadGroup root = group;
            INNOCUOUSTHREADGROUP = System.getSecurityManager() == null ? new ThreadGroup(root, "InnocuousThreadGroup") : AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    return new ThreadGroup(root, "InnocuousThreadGroup");
                }
            });
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

