/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.io.FileDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jdk.internal.access.JavaNioAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.access.foreign.MemorySegmentProxy;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.ArraysSupport;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.vector.VectorSupport;

public class ScopedMemoryAccess {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final ScopedMemoryAccess theScopedMemoryAccess;

    private static native void registerNatives();

    public boolean closeScope(Scope scope) {
        return this.closeScope0(scope, Scope.ScopedAccessError.INSTANCE);
    }

    native boolean closeScope0(Scope var1, Scope.ScopedAccessError var2);

    private ScopedMemoryAccess() {
    }

    public static ScopedMemoryAccess getScopedMemoryAccess() {
        return theScopedMemoryAccess;
    }

    @ForceInline
    public void copyMemory(Scope srcScope, Scope dstScope, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        try {
            this.copyMemoryInternal(srcScope, dstScope, srcBase, srcOffset, destBase, destOffset, bytes);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void copyMemoryInternal(Scope srcScope, Scope dstScope, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        try {
            if (srcScope != null) {
                srcScope.checkValidState();
            }
            if (dstScope != null) {
                dstScope.checkValidState();
            }
            UNSAFE.copyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
        }
        finally {
            Reference.reachabilityFence(srcScope);
            Reference.reachabilityFence(dstScope);
        }
    }

    @ForceInline
    public void copySwapMemory(Scope srcScope, Scope dstScope, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        try {
            this.copySwapMemoryInternal(srcScope, dstScope, srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void copySwapMemoryInternal(Scope srcScope, Scope dstScope, Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        try {
            if (srcScope != null) {
                srcScope.checkValidState();
            }
            if (dstScope != null) {
                dstScope.checkValidState();
            }
            UNSAFE.copySwapMemory(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
        }
        finally {
            Reference.reachabilityFence(srcScope);
            Reference.reachabilityFence(dstScope);
        }
    }

    @ForceInline
    public void setMemory(Scope scope, Object o, long offset, long bytes, byte value) {
        try {
            this.setMemoryInternal(scope, o, offset, bytes, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void setMemoryInternal(Scope scope, Object o, long offset, long bytes, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.setMemory(o, offset, bytes, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int vectorizedMismatch(Scope aScope, Scope bScope, Object a, long aOffset, Object b, long bOffset, int length, int log2ArrayIndexScale) {
        try {
            return this.vectorizedMismatchInternal(aScope, bScope, a, aOffset, b, bOffset, length, log2ArrayIndexScale);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int vectorizedMismatchInternal(Scope aScope, Scope bScope, Object a, long aOffset, Object b, long bOffset, int length, int log2ArrayIndexScale) {
        try {
            if (aScope != null) {
                aScope.checkValidState();
            }
            if (bScope != null) {
                bScope.checkValidState();
            }
            int n = ArraysSupport.vectorizedMismatch(a, aOffset, b, bOffset, length, log2ArrayIndexScale);
            return n;
        }
        finally {
            Reference.reachabilityFence(aScope);
            Reference.reachabilityFence(bScope);
        }
    }

    @ForceInline
    public boolean isLoaded(Scope scope, long address, boolean isSync, long size) {
        try {
            return this.isLoadedInternal(scope, address, isSync, size);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    public boolean isLoadedInternal(Scope scope, long address, boolean isSync, long size) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = SharedSecrets.getJavaNioAccess().isLoaded(address, isSync, size);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void load(Scope scope, long address, boolean isSync, long size) {
        try {
            this.loadInternal(scope, address, isSync, size);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    public void loadInternal(Scope scope, long address, boolean isSync, long size) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            SharedSecrets.getJavaNioAccess().load(address, isSync, size);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void unload(Scope scope, long address, boolean isSync, long size) {
        try {
            this.unloadInternal(scope, address, isSync, size);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    public void unloadInternal(Scope scope, long address, boolean isSync, long size) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            SharedSecrets.getJavaNioAccess().unload(address, isSync, size);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void force(Scope scope, FileDescriptor fd, long address, boolean isSync, long index, long length) {
        try {
            this.forceInternal(scope, fd, address, isSync, index, length);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    public void forceInternal(Scope scope, FileDescriptor fd, long address, boolean isSync, long index, long length) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            SharedSecrets.getJavaNioAccess().force(fd, address, isSync, index, length);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public static <V extends VectorSupport.Vector<E>, E, S extends VectorSupport.VectorSpecies<E>> V loadFromByteBuffer(Class<? extends V> vmClass, Class<E> e, int length, ByteBuffer bb, int offset, S s, VectorSupport.LoadOperation<ByteBuffer, V, E, S> defaultImpl) {
        try {
            return ScopedMemoryAccess.loadFromByteBufferScoped(BufferAccess.scope(bb), vmClass, e, length, bb, offset, s, defaultImpl);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scoped
    @ForceInline
    private static <V extends VectorSupport.Vector<E>, E, S extends VectorSupport.VectorSpecies<E>> V loadFromByteBufferScoped(Scope scope, Class<? extends V> vmClass, Class<E> e, int length, ByteBuffer bb, int offset, S s, VectorSupport.LoadOperation<ByteBuffer, V, E, S> defaultImpl) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            VectorSupport.Vector vector = (VectorSupport.Vector)VectorSupport.load(vmClass, e, length, BufferAccess.bufferBase(bb), BufferAccess.bufferAddress(bb, offset), bb, offset, s, defaultImpl);
            return (V)vector;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public static <V extends VectorSupport.Vector<E>, E> void storeIntoByteBuffer(Class<? extends V> vmClass, Class<E> e, int length, V v, ByteBuffer bb, int offset, VectorSupport.StoreVectorOperation<ByteBuffer, V> defaultImpl) {
        try {
            ScopedMemoryAccess.storeIntoByteBufferScoped(BufferAccess.scope(bb), vmClass, e, length, v, bb, offset, defaultImpl);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scoped
    @ForceInline
    private static <V extends VectorSupport.Vector<E>, E> void storeIntoByteBufferScoped(Scope scope, Class<? extends V> vmClass, Class<E> e, int length, V v, ByteBuffer bb, int offset, VectorSupport.StoreVectorOperation<ByteBuffer, V> defaultImpl) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            VectorSupport.store(vmClass, e, length, BufferAccess.bufferBase(bb), BufferAccess.bufferAddress(bb, offset), v, bb, offset, defaultImpl);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getByte(Scope scope, Object base, long offset) {
        try {
            return this.getByteInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getByteInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getByte(base, offset);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putByte(Scope scope, Object base, long offset, byte value) {
        try {
            this.putByteInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putByteInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putByte(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getByteVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getByteVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getByteVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getByteVolatile(base, offset);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putByteVolatile(Scope scope, Object base, long offset, byte value) {
        try {
            this.putByteVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putByteVolatileInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putByteVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getByteAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getByteAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getByteAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getByteAcquire(base, offset);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putByteRelease(Scope scope, Object base, long offset, byte value) {
        try {
            this.putByteReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putByteReleaseInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putByteRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getByteOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getByteOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getByteOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getByteOpaque(base, offset);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putByteOpaque(Scope scope, Object base, long offset, byte value) {
        try {
            this.putByteOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putByteOpaqueInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putByteOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndAddByte(Scope scope, Object base, long offset, byte delta) {
        try {
            return this.getAndAddByteInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndAddByteInternal(Scope scope, Object base, long offset, byte delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndAddByte(base, offset, delta);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndAddByteAcquire(Scope scope, Object base, long offset, byte delta) {
        try {
            return this.getAndAddByteAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndAddByteAcquireInternal(Scope scope, Object base, long offset, byte delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndAddByteAcquire(base, offset, delta);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndAddByteRelease(Scope scope, Object base, long offset, byte delta) {
        try {
            return this.getAndAddByteReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndAddByteReleaseInternal(Scope scope, Object base, long offset, byte delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndAddByteRelease(base, offset, delta);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseOrByte(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseOrByteInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseOrByteInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseOrByte(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseOrByteAcquire(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseOrByteAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseOrByteAcquireInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseOrByteAcquire(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseOrByteRelease(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseOrByteReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseOrByteReleaseInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseOrByteRelease(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseAndByte(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseAndByteInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseAndByteInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseAndByte(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseAndByteAcquire(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseAndByteAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseAndByteAcquireInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseAndByteAcquire(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseAndByteRelease(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseAndByteReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseAndByteReleaseInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseAndByteRelease(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseXorByte(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseXorByteInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseXorByteInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseXorByte(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseXorByteAcquire(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseXorByteAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseXorByteAcquireInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseXorByteAcquire(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public byte getAndBitwiseXorByteRelease(Scope scope, Object base, long offset, byte value) {
        try {
            return this.getAndBitwiseXorByteReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private byte getAndBitwiseXorByteReleaseInternal(Scope scope, Object base, long offset, byte value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            byte by = UNSAFE.getAndBitwiseXorByteRelease(base, offset, value);
            return by;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getShort(Scope scope, Object base, long offset) {
        try {
            return this.getShortInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getShortInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getShort(base, offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putShort(Scope scope, Object base, long offset, short value) {
        try {
            this.putShortInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putShortInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putShort(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getShortUnaligned(Scope scope, Object base, long offset, boolean be) {
        try {
            return this.getShortUnalignedInternal(scope, base, offset, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getShortUnalignedInternal(Scope scope, Object base, long offset, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getShortUnaligned(base, offset, be);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putShortUnaligned(Scope scope, Object base, long offset, short value, boolean be) {
        try {
            this.putShortUnalignedInternal(scope, base, offset, value, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putShortUnalignedInternal(Scope scope, Object base, long offset, short value, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putShortUnaligned(base, offset, value, be);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getShortVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getShortVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getShortVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getShortVolatile(base, offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putShortVolatile(Scope scope, Object base, long offset, short value) {
        try {
            this.putShortVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putShortVolatileInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putShortVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getShortAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getShortAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getShortAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getShortAcquire(base, offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putShortRelease(Scope scope, Object base, long offset, short value) {
        try {
            this.putShortReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putShortReleaseInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putShortRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getShortOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getShortOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getShortOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getShortOpaque(base, offset);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putShortOpaque(Scope scope, Object base, long offset, short value) {
        try {
            this.putShortOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putShortOpaqueInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putShortOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndAddShort(Scope scope, Object base, long offset, short delta) {
        try {
            return this.getAndAddShortInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndAddShortInternal(Scope scope, Object base, long offset, short delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndAddShort(base, offset, delta);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndAddShortAcquire(Scope scope, Object base, long offset, short delta) {
        try {
            return this.getAndAddShortAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndAddShortAcquireInternal(Scope scope, Object base, long offset, short delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndAddShortAcquire(base, offset, delta);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndAddShortRelease(Scope scope, Object base, long offset, short delta) {
        try {
            return this.getAndAddShortReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndAddShortReleaseInternal(Scope scope, Object base, long offset, short delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndAddShortRelease(base, offset, delta);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseOrShort(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseOrShortInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseOrShortInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseOrShort(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseOrShortAcquire(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseOrShortAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseOrShortAcquireInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseOrShortAcquire(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseOrShortRelease(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseOrShortReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseOrShortReleaseInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseOrShortRelease(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseAndShort(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseAndShortInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseAndShortInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseAndShort(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseAndShortAcquire(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseAndShortAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseAndShortAcquireInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseAndShortAcquire(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseAndShortRelease(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseAndShortReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseAndShortReleaseInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseAndShortRelease(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseXorShort(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseXorShortInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseXorShortInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseXorShort(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseXorShortAcquire(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseXorShortAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseXorShortAcquireInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseXorShortAcquire(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public short getAndBitwiseXorShortRelease(Scope scope, Object base, long offset, short value) {
        try {
            return this.getAndBitwiseXorShortReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private short getAndBitwiseXorShortReleaseInternal(Scope scope, Object base, long offset, short value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            short s = UNSAFE.getAndBitwiseXorShortRelease(base, offset, value);
            return s;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getChar(Scope scope, Object base, long offset) {
        try {
            return this.getCharInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getCharInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getChar(base, offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putChar(Scope scope, Object base, long offset, char value) {
        try {
            this.putCharInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putCharInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putChar(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getCharUnaligned(Scope scope, Object base, long offset, boolean be) {
        try {
            return this.getCharUnalignedInternal(scope, base, offset, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getCharUnalignedInternal(Scope scope, Object base, long offset, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getCharUnaligned(base, offset, be);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putCharUnaligned(Scope scope, Object base, long offset, char value, boolean be) {
        try {
            this.putCharUnalignedInternal(scope, base, offset, value, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putCharUnalignedInternal(Scope scope, Object base, long offset, char value, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putCharUnaligned(base, offset, value, be);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getCharVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getCharVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getCharVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getCharVolatile(base, offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putCharVolatile(Scope scope, Object base, long offset, char value) {
        try {
            this.putCharVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putCharVolatileInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putCharVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getCharAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getCharAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getCharAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getCharAcquire(base, offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putCharRelease(Scope scope, Object base, long offset, char value) {
        try {
            this.putCharReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putCharReleaseInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putCharRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getCharOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getCharOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getCharOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getCharOpaque(base, offset);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putCharOpaque(Scope scope, Object base, long offset, char value) {
        try {
            this.putCharOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putCharOpaqueInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putCharOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndAddChar(Scope scope, Object base, long offset, char delta) {
        try {
            return this.getAndAddCharInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndAddCharInternal(Scope scope, Object base, long offset, char delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndAddChar(base, offset, delta);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndAddCharAcquire(Scope scope, Object base, long offset, char delta) {
        try {
            return this.getAndAddCharAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndAddCharAcquireInternal(Scope scope, Object base, long offset, char delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndAddCharAcquire(base, offset, delta);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndAddCharRelease(Scope scope, Object base, long offset, char delta) {
        try {
            return this.getAndAddCharReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndAddCharReleaseInternal(Scope scope, Object base, long offset, char delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndAddCharRelease(base, offset, delta);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseOrChar(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseOrCharInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseOrCharInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseOrChar(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseOrCharAcquire(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseOrCharAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseOrCharAcquireInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseOrCharAcquire(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseOrCharRelease(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseOrCharReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseOrCharReleaseInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseOrCharRelease(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseAndChar(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseAndCharInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseAndCharInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseAndChar(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseAndCharAcquire(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseAndCharAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseAndCharAcquireInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseAndCharAcquire(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseAndCharRelease(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseAndCharReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseAndCharReleaseInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseAndCharRelease(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseXorChar(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseXorCharInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseXorCharInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseXorChar(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseXorCharAcquire(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseXorCharAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseXorCharAcquireInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseXorCharAcquire(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public char getAndBitwiseXorCharRelease(Scope scope, Object base, long offset, char value) {
        try {
            return this.getAndBitwiseXorCharReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private char getAndBitwiseXorCharReleaseInternal(Scope scope, Object base, long offset, char value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            char c = UNSAFE.getAndBitwiseXorCharRelease(base, offset, value);
            return c;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getInt(Scope scope, Object base, long offset) {
        try {
            return this.getIntInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getIntInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getInt(base, offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putInt(Scope scope, Object base, long offset, int value) {
        try {
            this.putIntInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putIntInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putInt(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getIntUnaligned(Scope scope, Object base, long offset, boolean be) {
        try {
            return this.getIntUnalignedInternal(scope, base, offset, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getIntUnalignedInternal(Scope scope, Object base, long offset, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getIntUnaligned(base, offset, be);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putIntUnaligned(Scope scope, Object base, long offset, int value, boolean be) {
        try {
            this.putIntUnalignedInternal(scope, base, offset, value, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putIntUnalignedInternal(Scope scope, Object base, long offset, int value, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putIntUnaligned(base, offset, value, be);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getIntVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getIntVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getIntVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getIntVolatile(base, offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putIntVolatile(Scope scope, Object base, long offset, int value) {
        try {
            this.putIntVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putIntVolatileInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putIntVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getIntAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getIntAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getIntAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getIntAcquire(base, offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putIntRelease(Scope scope, Object base, long offset, int value) {
        try {
            this.putIntReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putIntReleaseInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putIntRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getIntOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getIntOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getIntOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getIntOpaque(base, offset);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putIntOpaque(Scope scope, Object base, long offset, int value) {
        try {
            this.putIntOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putIntOpaqueInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putIntOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean compareAndSetInt(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.compareAndSetIntInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean compareAndSetIntInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.compareAndSetInt(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int compareAndExchangeInt(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.compareAndExchangeIntInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int compareAndExchangeIntInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.compareAndExchangeInt(base, offset, expected, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int compareAndExchangeIntAcquire(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.compareAndExchangeIntAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int compareAndExchangeIntAcquireInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.compareAndExchangeIntAcquire(base, offset, expected, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int compareAndExchangeIntRelease(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.compareAndExchangeIntReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int compareAndExchangeIntReleaseInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.compareAndExchangeIntRelease(base, offset, expected, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetIntPlain(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.weakCompareAndSetIntPlainInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetIntPlainInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetIntPlain(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetInt(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.weakCompareAndSetIntInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetIntInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetInt(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetIntAcquire(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.weakCompareAndSetIntAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetIntAcquireInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetIntAcquire(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetIntRelease(Scope scope, Object base, long offset, int expected, int value) {
        try {
            return this.weakCompareAndSetIntReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetIntReleaseInternal(Scope scope, Object base, long offset, int expected, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetIntRelease(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndSetInt(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndSetIntInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndSetIntInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndSetInt(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndSetIntAcquire(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndSetIntAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndSetIntAcquireInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndSetIntAcquire(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndSetIntRelease(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndSetIntReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndSetIntReleaseInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndSetIntRelease(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndAddInt(Scope scope, Object base, long offset, int delta) {
        try {
            return this.getAndAddIntInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndAddIntInternal(Scope scope, Object base, long offset, int delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndAddInt(base, offset, delta);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndAddIntAcquire(Scope scope, Object base, long offset, int delta) {
        try {
            return this.getAndAddIntAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndAddIntAcquireInternal(Scope scope, Object base, long offset, int delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndAddIntAcquire(base, offset, delta);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndAddIntRelease(Scope scope, Object base, long offset, int delta) {
        try {
            return this.getAndAddIntReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndAddIntReleaseInternal(Scope scope, Object base, long offset, int delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndAddIntRelease(base, offset, delta);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseOrInt(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseOrIntInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseOrIntInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseOrInt(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseOrIntAcquire(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseOrIntAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseOrIntAcquireInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseOrIntAcquire(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseOrIntRelease(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseOrIntReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseOrIntReleaseInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseOrIntRelease(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseAndInt(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseAndIntInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseAndIntInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseAndInt(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseAndIntAcquire(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseAndIntAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseAndIntAcquireInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseAndIntAcquire(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseAndIntRelease(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseAndIntReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseAndIntReleaseInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseAndIntRelease(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseXorInt(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseXorIntInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseXorIntInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseXorInt(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseXorIntAcquire(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseXorIntAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseXorIntAcquireInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseXorIntAcquire(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public int getAndBitwiseXorIntRelease(Scope scope, Object base, long offset, int value) {
        try {
            return this.getAndBitwiseXorIntReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private int getAndBitwiseXorIntReleaseInternal(Scope scope, Object base, long offset, int value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            int n = UNSAFE.getAndBitwiseXorIntRelease(base, offset, value);
            return n;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getLong(Scope scope, Object base, long offset) {
        try {
            return this.getLongInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getLongInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getLong(base, offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putLong(Scope scope, Object base, long offset, long value) {
        try {
            this.putLongInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putLongInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putLong(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getLongUnaligned(Scope scope, Object base, long offset, boolean be) {
        try {
            return this.getLongUnalignedInternal(scope, base, offset, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getLongUnalignedInternal(Scope scope, Object base, long offset, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getLongUnaligned(base, offset, be);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putLongUnaligned(Scope scope, Object base, long offset, long value, boolean be) {
        try {
            this.putLongUnalignedInternal(scope, base, offset, value, be);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putLongUnalignedInternal(Scope scope, Object base, long offset, long value, boolean be) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putLongUnaligned(base, offset, value, be);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getLongVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getLongVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getLongVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getLongVolatile(base, offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putLongVolatile(Scope scope, Object base, long offset, long value) {
        try {
            this.putLongVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putLongVolatileInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putLongVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getLongAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getLongAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getLongAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getLongAcquire(base, offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putLongRelease(Scope scope, Object base, long offset, long value) {
        try {
            this.putLongReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putLongReleaseInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putLongRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getLongOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getLongOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getLongOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getLongOpaque(base, offset);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putLongOpaque(Scope scope, Object base, long offset, long value) {
        try {
            this.putLongOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putLongOpaqueInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putLongOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean compareAndSetLong(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.compareAndSetLongInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean compareAndSetLongInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.compareAndSetLong(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long compareAndExchangeLong(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.compareAndExchangeLongInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long compareAndExchangeLongInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.compareAndExchangeLong(base, offset, expected, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long compareAndExchangeLongAcquire(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.compareAndExchangeLongAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long compareAndExchangeLongAcquireInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.compareAndExchangeLongAcquire(base, offset, expected, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long compareAndExchangeLongRelease(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.compareAndExchangeLongReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long compareAndExchangeLongReleaseInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.compareAndExchangeLongRelease(base, offset, expected, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetLongPlain(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.weakCompareAndSetLongPlainInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetLongPlainInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetLongPlain(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetLong(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.weakCompareAndSetLongInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetLongInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetLong(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetLongAcquire(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.weakCompareAndSetLongAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetLongAcquireInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetLongAcquire(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetLongRelease(Scope scope, Object base, long offset, long expected, long value) {
        try {
            return this.weakCompareAndSetLongReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetLongReleaseInternal(Scope scope, Object base, long offset, long expected, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetLongRelease(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndSetLong(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndSetLongInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndSetLongInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndSetLong(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndSetLongAcquire(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndSetLongAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndSetLongAcquireInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndSetLongAcquire(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndSetLongRelease(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndSetLongReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndSetLongReleaseInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndSetLongRelease(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndAddLong(Scope scope, Object base, long offset, long delta) {
        try {
            return this.getAndAddLongInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndAddLongInternal(Scope scope, Object base, long offset, long delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndAddLong(base, offset, delta);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndAddLongAcquire(Scope scope, Object base, long offset, long delta) {
        try {
            return this.getAndAddLongAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndAddLongAcquireInternal(Scope scope, Object base, long offset, long delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndAddLongAcquire(base, offset, delta);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndAddLongRelease(Scope scope, Object base, long offset, long delta) {
        try {
            return this.getAndAddLongReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndAddLongReleaseInternal(Scope scope, Object base, long offset, long delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndAddLongRelease(base, offset, delta);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseOrLong(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseOrLongInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseOrLongInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseOrLong(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseOrLongAcquire(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseOrLongAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseOrLongAcquireInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseOrLongAcquire(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseOrLongRelease(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseOrLongReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseOrLongReleaseInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseOrLongRelease(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseAndLong(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseAndLongInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseAndLongInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseAndLong(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseAndLongAcquire(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseAndLongAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseAndLongAcquireInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseAndLongAcquire(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseAndLongRelease(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseAndLongReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseAndLongReleaseInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseAndLongRelease(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseXorLong(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseXorLongInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseXorLongInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseXorLong(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseXorLongAcquire(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseXorLongAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseXorLongAcquireInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseXorLongAcquire(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public long getAndBitwiseXorLongRelease(Scope scope, Object base, long offset, long value) {
        try {
            return this.getAndBitwiseXorLongReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private long getAndBitwiseXorLongReleaseInternal(Scope scope, Object base, long offset, long value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            long l = UNSAFE.getAndBitwiseXorLongRelease(base, offset, value);
            return l;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getFloat(Scope scope, Object base, long offset) {
        try {
            return this.getFloatInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getFloatInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getFloat(base, offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putFloat(Scope scope, Object base, long offset, float value) {
        try {
            this.putFloatInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putFloatInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putFloat(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getFloatVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getFloatVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getFloatVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getFloatVolatile(base, offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putFloatVolatile(Scope scope, Object base, long offset, float value) {
        try {
            this.putFloatVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putFloatVolatileInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putFloatVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getFloatAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getFloatAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getFloatAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getFloatAcquire(base, offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putFloatRelease(Scope scope, Object base, long offset, float value) {
        try {
            this.putFloatReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putFloatReleaseInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putFloatRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getFloatOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getFloatOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getFloatOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getFloatOpaque(base, offset);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putFloatOpaque(Scope scope, Object base, long offset, float value) {
        try {
            this.putFloatOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putFloatOpaqueInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putFloatOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean compareAndSetFloat(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.compareAndSetFloatInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean compareAndSetFloatInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.compareAndSetFloat(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float compareAndExchangeFloat(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.compareAndExchangeFloatInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float compareAndExchangeFloatInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.compareAndExchangeFloat(base, offset, expected, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float compareAndExchangeFloatAcquire(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.compareAndExchangeFloatAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float compareAndExchangeFloatAcquireInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.compareAndExchangeFloatAcquire(base, offset, expected, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float compareAndExchangeFloatRelease(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.compareAndExchangeFloatReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float compareAndExchangeFloatReleaseInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.compareAndExchangeFloatRelease(base, offset, expected, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetFloatPlain(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.weakCompareAndSetFloatPlainInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetFloatPlainInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetFloatPlain(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetFloat(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.weakCompareAndSetFloatInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetFloatInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetFloat(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetFloatAcquire(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.weakCompareAndSetFloatAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetFloatAcquireInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetFloatAcquire(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetFloatRelease(Scope scope, Object base, long offset, float expected, float value) {
        try {
            return this.weakCompareAndSetFloatReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetFloatReleaseInternal(Scope scope, Object base, long offset, float expected, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetFloatRelease(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndSetFloat(Scope scope, Object base, long offset, float value) {
        try {
            return this.getAndSetFloatInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndSetFloatInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndSetFloat(base, offset, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndSetFloatAcquire(Scope scope, Object base, long offset, float value) {
        try {
            return this.getAndSetFloatAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndSetFloatAcquireInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndSetFloatAcquire(base, offset, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndSetFloatRelease(Scope scope, Object base, long offset, float value) {
        try {
            return this.getAndSetFloatReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndSetFloatReleaseInternal(Scope scope, Object base, long offset, float value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndSetFloatRelease(base, offset, value);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndAddFloat(Scope scope, Object base, long offset, float delta) {
        try {
            return this.getAndAddFloatInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndAddFloatInternal(Scope scope, Object base, long offset, float delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndAddFloat(base, offset, delta);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndAddFloatAcquire(Scope scope, Object base, long offset, float delta) {
        try {
            return this.getAndAddFloatAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndAddFloatAcquireInternal(Scope scope, Object base, long offset, float delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndAddFloatAcquire(base, offset, delta);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public float getAndAddFloatRelease(Scope scope, Object base, long offset, float delta) {
        try {
            return this.getAndAddFloatReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private float getAndAddFloatReleaseInternal(Scope scope, Object base, long offset, float delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            float f = UNSAFE.getAndAddFloatRelease(base, offset, delta);
            return f;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getDouble(Scope scope, Object base, long offset) {
        try {
            return this.getDoubleInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getDoubleInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getDouble(base, offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putDouble(Scope scope, Object base, long offset, double value) {
        try {
            this.putDoubleInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putDoubleInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putDouble(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getDoubleVolatile(Scope scope, Object base, long offset) {
        try {
            return this.getDoubleVolatileInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getDoubleVolatileInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getDoubleVolatile(base, offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putDoubleVolatile(Scope scope, Object base, long offset, double value) {
        try {
            this.putDoubleVolatileInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putDoubleVolatileInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putDoubleVolatile(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getDoubleAcquire(Scope scope, Object base, long offset) {
        try {
            return this.getDoubleAcquireInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getDoubleAcquireInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getDoubleAcquire(base, offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putDoubleRelease(Scope scope, Object base, long offset, double value) {
        try {
            this.putDoubleReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putDoubleReleaseInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putDoubleRelease(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getDoubleOpaque(Scope scope, Object base, long offset) {
        try {
            return this.getDoubleOpaqueInternal(scope, base, offset);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getDoubleOpaqueInternal(Scope scope, Object base, long offset) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getDoubleOpaque(base, offset);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public void putDoubleOpaque(Scope scope, Object base, long offset, double value) {
        try {
            this.putDoubleOpaqueInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private void putDoubleOpaqueInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            UNSAFE.putDoubleOpaque(base, offset, value);
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean compareAndSetDouble(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.compareAndSetDoubleInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean compareAndSetDoubleInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.compareAndSetDouble(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double compareAndExchangeDouble(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.compareAndExchangeDoubleInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double compareAndExchangeDoubleInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.compareAndExchangeDouble(base, offset, expected, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double compareAndExchangeDoubleAcquire(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.compareAndExchangeDoubleAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double compareAndExchangeDoubleAcquireInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.compareAndExchangeDoubleAcquire(base, offset, expected, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double compareAndExchangeDoubleRelease(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.compareAndExchangeDoubleReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double compareAndExchangeDoubleReleaseInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.compareAndExchangeDoubleRelease(base, offset, expected, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetDoublePlain(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.weakCompareAndSetDoublePlainInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetDoublePlainInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetDoublePlain(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetDouble(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.weakCompareAndSetDoubleInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetDoubleInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetDouble(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetDoubleAcquire(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.weakCompareAndSetDoubleAcquireInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetDoubleAcquireInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetDoubleAcquire(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public boolean weakCompareAndSetDoubleRelease(Scope scope, Object base, long offset, double expected, double value) {
        try {
            return this.weakCompareAndSetDoubleReleaseInternal(scope, base, offset, expected, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private boolean weakCompareAndSetDoubleReleaseInternal(Scope scope, Object base, long offset, double expected, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            boolean bl = UNSAFE.weakCompareAndSetDoubleRelease(base, offset, expected, value);
            return bl;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndSetDouble(Scope scope, Object base, long offset, double value) {
        try {
            return this.getAndSetDoubleInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndSetDoubleInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndSetDouble(base, offset, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndSetDoubleAcquire(Scope scope, Object base, long offset, double value) {
        try {
            return this.getAndSetDoubleAcquireInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndSetDoubleAcquireInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndSetDoubleAcquire(base, offset, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndSetDoubleRelease(Scope scope, Object base, long offset, double value) {
        try {
            return this.getAndSetDoubleReleaseInternal(scope, base, offset, value);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndSetDoubleReleaseInternal(Scope scope, Object base, long offset, double value) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndSetDoubleRelease(base, offset, value);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndAddDouble(Scope scope, Object base, long offset, double delta) {
        try {
            return this.getAndAddDoubleInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndAddDoubleInternal(Scope scope, Object base, long offset, double delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndAddDouble(base, offset, delta);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndAddDoubleAcquire(Scope scope, Object base, long offset, double delta) {
        try {
            return this.getAndAddDoubleAcquireInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndAddDoubleAcquireInternal(Scope scope, Object base, long offset, double delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndAddDoubleAcquire(base, offset, delta);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    @ForceInline
    public double getAndAddDoubleRelease(Scope scope, Object base, long offset, double delta) {
        try {
            return this.getAndAddDoubleReleaseInternal(scope, base, offset, delta);
        }
        catch (Scope.ScopedAccessError ex) {
            throw new IllegalStateException("This segment is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    @Scoped
    private double getAndAddDoubleReleaseInternal(Scope scope, Object base, long offset, double delta) {
        try {
            if (scope != null) {
                scope.checkValidState();
            }
            double d = UNSAFE.getAndAddDoubleRelease(base, offset, delta);
            return d;
        }
        finally {
            Reference.reachabilityFence(scope);
        }
    }

    static {
        ScopedMemoryAccess.registerNatives();
        theScopedMemoryAccess = new ScopedMemoryAccess();
    }

    public static interface Scope {
        public void checkValidState();

        public Thread ownerThread();

        public boolean isImplicit();

        public Handle acquire();

        public void release(Handle var1);

        public static final class ScopedAccessError
        extends Error {
            static final long serialVersionUID = 1L;
            public static final ScopedAccessError INSTANCE = new ScopedAccessError();

            private ScopedAccessError() {
                super("Attempt to access an already released memory resource", null, false, false);
            }
        }

        public static interface Handle {
            public Scope scope();
        }
    }

    static final class BufferAccess {
        static final long BUFFER_ADDRESS = UNSAFE.objectFieldOffset(Buffer.class, "address");
        static final long BYTE_BUFFER_HB = UNSAFE.objectFieldOffset(ByteBuffer.class, "hb");
        static final JavaNioAccess NIO_ACCESS = SharedSecrets.getJavaNioAccess();

        BufferAccess() {
        }

        @ForceInline
        static Object bufferBase(ByteBuffer bb) {
            return UNSAFE.getReference(bb, BYTE_BUFFER_HB);
        }

        @ForceInline
        static long bufferAddress(ByteBuffer bb, long offset) {
            return UNSAFE.getLong(bb, BUFFER_ADDRESS) + offset;
        }

        @ForceInline
        static Scope scope(ByteBuffer bb) {
            MemorySegmentProxy segmentProxy = NIO_ACCESS.bufferSegment(bb);
            return segmentProxy != null ? segmentProxy.scope() : null;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Scoped {
    }
}

