/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.util.Hashtable;
import java.util.Objects;

public final class Signal {
    private static Hashtable<Signal, Handler> handlers = new Hashtable(4);
    private static Hashtable<Integer, Signal> signals = new Hashtable(4);
    private int number;
    private String name;

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Signal) {
            Signal other = (Signal)obj;
            return this.name.equals(other.name) && this.number == other.number;
        }
        return false;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "SIG" + this.name;
    }

    public Signal(String name) {
        Objects.requireNonNull(name, "name");
        if (name.startsWith("SIG")) {
            throw new IllegalArgumentException("Unknown signal: " + name);
        }
        this.name = name;
        this.number = Signal.findSignal0(name);
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Handler handle(Signal sig, Handler handler) throws IllegalArgumentException {
        Objects.requireNonNull(sig, "sig");
        Objects.requireNonNull(handler, "handler");
        long newH = handler instanceof NativeHandler ? ((NativeHandler)handler).getHandler() : 2L;
        long oldH = Signal.handle0(sig.number, newH);
        if (oldH == -1L) {
            throw new IllegalArgumentException("Signal already used by VM or OS: " + sig);
        }
        signals.put(sig.number, sig);
        Hashtable<Signal, Handler> hashtable = handlers;
        synchronized (hashtable) {
            Handler oldHandler = handlers.get(sig);
            handlers.remove(sig);
            if (newH == 2L) {
                handlers.put(sig, handler);
            }
            if (oldH == 0L) {
                return Handler.SIG_DFL;
            }
            if (oldH == 1L) {
                return Handler.SIG_IGN;
            }
            if (oldH == 2L) {
                return oldHandler;
            }
            return new NativeHandler(oldH);
        }
    }

    public static void raise(Signal sig) throws IllegalArgumentException {
        Objects.requireNonNull(sig, "sig");
        if (handlers.get(sig) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + sig);
        }
        Signal.raise0(sig.number);
    }

    private static void dispatch(int number) {
        final Signal sig = signals.get(number);
        final Handler handler = handlers.get(sig);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                handler.handle(sig);
            }
        };
        if (handler != null) {
            new Thread(null, runnable, sig + " handler", 0L, false).start();
        }
    }

    private static native int findSignal0(String var0);

    private static native long handle0(int var0, long var1);

    private static native void raise0(int var0);

    static final class NativeHandler
    implements Handler {
        private final long handler;

        long getHandler() {
            return this.handler;
        }

        NativeHandler(long handler) {
            this.handler = handler;
        }

        @Override
        public void handle(Signal sig) {
            throw new UnsupportedOperationException("invoking native signal handle not supported");
        }

        public String toString() {
            return this == SIG_DFL ? "SIG_DFL" : (this == SIG_IGN ? "SIG_IGN" : super.toString());
        }
    }

    public static interface Handler {
        public static final Handler SIG_DFL = new NativeHandler(0L);
        public static final Handler SIG_IGN = new NativeHandler(1L);

        public void handle(Signal var1);
    }
}

