/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;

public class TerminatingThreadLocal<T>
extends ThreadLocal<T> {
    public static final ThreadLocal<Collection<TerminatingThreadLocal<?>>> REGISTRY = new ThreadLocal<Collection<TerminatingThreadLocal<?>>>(){

        @Override
        protected Collection<TerminatingThreadLocal<?>> initialValue() {
            return Collections.newSetFromMap(new IdentityHashMap(4));
        }
    };

    @Override
    public void set(T value) {
        super.set(value);
        TerminatingThreadLocal.register(this);
    }

    @Override
    public void remove() {
        super.remove();
        TerminatingThreadLocal.unregister(this);
    }

    protected void threadTerminated(T value) {
    }

    public static void threadTerminated() {
        for (TerminatingThreadLocal<?> ttl : REGISTRY.get()) {
            ttl._threadTerminated();
        }
    }

    private void _threadTerminated() {
        this.threadTerminated(this.get());
    }

    public static void register(TerminatingThreadLocal<?> tl) {
        REGISTRY.get().add(tl);
    }

    private static void unregister(TerminatingThreadLocal<?> tl) {
        REGISTRY.get().remove(tl);
    }
}

