/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.misc;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import jdk.internal.misc.UnsafeConstants;
import jdk.internal.ref.Cleaner;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import sun.nio.ch.DirectBuffer;

public final class Unsafe {
    private static final Unsafe theUnsafe;
    public static final int INVALID_FIELD_OFFSET = -1;
    public static final int ARRAY_BOOLEAN_BASE_OFFSET;
    public static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int ARRAY_SHORT_BASE_OFFSET;
    public static final int ARRAY_CHAR_BASE_OFFSET;
    public static final int ARRAY_INT_BASE_OFFSET;
    public static final int ARRAY_LONG_BASE_OFFSET;
    public static final int ARRAY_FLOAT_BASE_OFFSET;
    public static final int ARRAY_DOUBLE_BASE_OFFSET;
    public static final int ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE;
    public static final int ARRAY_BYTE_INDEX_SCALE;
    public static final int ARRAY_SHORT_INDEX_SCALE;
    public static final int ARRAY_CHAR_INDEX_SCALE;
    public static final int ARRAY_INT_INDEX_SCALE;
    public static final int ARRAY_LONG_INDEX_SCALE;
    public static final int ARRAY_FLOAT_INDEX_SCALE;
    public static final int ARRAY_DOUBLE_INDEX_SCALE;
    public static final int ARRAY_OBJECT_INDEX_SCALE;
    public static final int ADDRESS_SIZE;

    private static native void registerNatives();

    private Unsafe() {
    }

    public static Unsafe getUnsafe() {
        return theUnsafe;
    }

    @IntrinsicCandidate
    public native int getInt(Object var1, long var2);

    @IntrinsicCandidate
    public native void putInt(Object var1, long var2, int var4);

    @IntrinsicCandidate
    public native Object getReference(Object var1, long var2);

    @IntrinsicCandidate
    public native void putReference(Object var1, long var2, Object var4);

    @IntrinsicCandidate
    public native boolean getBoolean(Object var1, long var2);

    @IntrinsicCandidate
    public native void putBoolean(Object var1, long var2, boolean var4);

    @IntrinsicCandidate
    public native byte getByte(Object var1, long var2);

    @IntrinsicCandidate
    public native void putByte(Object var1, long var2, byte var4);

    @IntrinsicCandidate
    public native short getShort(Object var1, long var2);

    @IntrinsicCandidate
    public native void putShort(Object var1, long var2, short var4);

    @IntrinsicCandidate
    public native char getChar(Object var1, long var2);

    @IntrinsicCandidate
    public native void putChar(Object var1, long var2, char var4);

    @IntrinsicCandidate
    public native long getLong(Object var1, long var2);

    @IntrinsicCandidate
    public native void putLong(Object var1, long var2, long var4);

    @IntrinsicCandidate
    public native float getFloat(Object var1, long var2);

    @IntrinsicCandidate
    public native void putFloat(Object var1, long var2, float var4);

    @IntrinsicCandidate
    public native double getDouble(Object var1, long var2);

    @IntrinsicCandidate
    public native void putDouble(Object var1, long var2, double var4);

    @ForceInline
    public long getAddress(Object o, long offset) {
        if (ADDRESS_SIZE == 4) {
            return Integer.toUnsignedLong(this.getInt(o, offset));
        }
        return this.getLong(o, offset);
    }

    @ForceInline
    public void putAddress(Object o, long offset, long x) {
        if (ADDRESS_SIZE == 4) {
            this.putInt(o, offset, (int)x);
        } else {
            this.putLong(o, offset, x);
        }
    }

    public native Object getUncompressedObject(long var1);

    @ForceInline
    public byte getByte(long address) {
        return this.getByte(null, address);
    }

    @ForceInline
    public void putByte(long address, byte x) {
        this.putByte(null, address, x);
    }

    @ForceInline
    public short getShort(long address) {
        return this.getShort(null, address);
    }

    @ForceInline
    public void putShort(long address, short x) {
        this.putShort(null, address, x);
    }

    @ForceInline
    public char getChar(long address) {
        return this.getChar(null, address);
    }

    @ForceInline
    public void putChar(long address, char x) {
        this.putChar(null, address, x);
    }

    @ForceInline
    public int getInt(long address) {
        return this.getInt(null, address);
    }

    @ForceInline
    public void putInt(long address, int x) {
        this.putInt(null, address, x);
    }

    @ForceInline
    public long getLong(long address) {
        return this.getLong(null, address);
    }

    @ForceInline
    public void putLong(long address, long x) {
        this.putLong(null, address, x);
    }

    @ForceInline
    public float getFloat(long address) {
        return this.getFloat(null, address);
    }

    @ForceInline
    public void putFloat(long address, float x) {
        this.putFloat(null, address, x);
    }

    @ForceInline
    public double getDouble(long address) {
        return this.getDouble(null, address);
    }

    @ForceInline
    public void putDouble(long address, double x) {
        this.putDouble(null, address, x);
    }

    @ForceInline
    public long getAddress(long address) {
        return this.getAddress(null, address);
    }

    @ForceInline
    public void putAddress(long address, long x) {
        this.putAddress(null, address, x);
    }

    private RuntimeException invalidInput() {
        return new IllegalArgumentException();
    }

    private boolean is32BitClean(long value) {
        return value >>> 32 == 0L;
    }

    private void checkSize(long size) {
        if (ADDRESS_SIZE == 4 ? !this.is32BitClean(size) : size < 0L) {
            throw this.invalidInput();
        }
    }

    private void checkNativeAddress(long address) {
        if (ADDRESS_SIZE == 4 && ((address >> 32) + 1L & 0xFFFFFFFFFFFFFFFEL) != 0L) {
            throw this.invalidInput();
        }
    }

    private void checkOffset(Object o, long offset) {
        if (ADDRESS_SIZE == 4 ? !this.is32BitClean(offset) : offset < 0L) {
            throw this.invalidInput();
        }
    }

    private void checkPointer(Object o, long offset) {
        if (o == null) {
            this.checkNativeAddress(offset);
        } else {
            this.checkOffset(o, offset);
        }
    }

    private void checkPrimitiveArray(Class<?> c) {
        Class<?> componentType = c.getComponentType();
        if (componentType == null || !componentType.isPrimitive()) {
            throw this.invalidInput();
        }
    }

    private void checkPrimitivePointer(Object o, long offset) {
        this.checkPointer(o, offset);
        if (o != null) {
            this.checkPrimitiveArray(o.getClass());
        }
    }

    private long alignToHeapWordSize(long bytes) {
        if (bytes >= 0L) {
            return bytes + (long)ADDRESS_SIZE - 1L & (long)(~(ADDRESS_SIZE - 1));
        }
        throw this.invalidInput();
    }

    public long allocateMemory(long bytes) {
        bytes = this.alignToHeapWordSize(bytes);
        this.allocateMemoryChecks(bytes);
        if (bytes == 0L) {
            return 0L;
        }
        long p = this.allocateMemory0(bytes);
        if (p == 0L) {
            throw new OutOfMemoryError("Unable to allocate " + bytes + " bytes");
        }
        return p;
    }

    private void allocateMemoryChecks(long bytes) {
        this.checkSize(bytes);
    }

    public long reallocateMemory(long address, long bytes) {
        long p;
        bytes = this.alignToHeapWordSize(bytes);
        this.reallocateMemoryChecks(address, bytes);
        if (bytes == 0L) {
            this.freeMemory(address);
            return 0L;
        }
        long l = p = address == 0L ? this.allocateMemory0(bytes) : this.reallocateMemory0(address, bytes);
        if (p == 0L) {
            throw new OutOfMemoryError("Unable to allocate " + bytes + " bytes");
        }
        return p;
    }

    private void reallocateMemoryChecks(long address, long bytes) {
        this.checkPointer(null, address);
        this.checkSize(bytes);
    }

    public void setMemory(Object o, long offset, long bytes, byte value) {
        this.setMemoryChecks(o, offset, bytes, value);
        if (bytes == 0L) {
            return;
        }
        this.setMemory0(o, offset, bytes, value);
    }

    public void setMemory(long address, long bytes, byte value) {
        this.setMemory(null, address, bytes, value);
    }

    private void setMemoryChecks(Object o, long offset, long bytes, byte value) {
        this.checkPrimitivePointer(o, offset);
        this.checkSize(bytes);
    }

    public void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        this.copyMemoryChecks(srcBase, srcOffset, destBase, destOffset, bytes);
        if (bytes == 0L) {
            return;
        }
        this.copyMemory0(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    public void copyMemory(long srcAddress, long destAddress, long bytes) {
        this.copyMemory(null, srcAddress, null, destAddress, bytes);
    }

    private void copyMemoryChecks(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        this.checkSize(bytes);
        this.checkPrimitivePointer(srcBase, srcOffset);
        this.checkPrimitivePointer(destBase, destOffset);
    }

    public void copySwapMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        this.copySwapMemoryChecks(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
        if (bytes == 0L) {
            return;
        }
        this.copySwapMemory0(srcBase, srcOffset, destBase, destOffset, bytes, elemSize);
    }

    private void copySwapMemoryChecks(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        this.checkSize(bytes);
        if (elemSize != 2L && elemSize != 4L && elemSize != 8L) {
            throw this.invalidInput();
        }
        if (bytes % elemSize != 0L) {
            throw this.invalidInput();
        }
        this.checkPrimitivePointer(srcBase, srcOffset);
        this.checkPrimitivePointer(destBase, destOffset);
    }

    public void copySwapMemory(long srcAddress, long destAddress, long bytes, long elemSize) {
        this.copySwapMemory(null, srcAddress, null, destAddress, bytes, elemSize);
    }

    public void freeMemory(long address) {
        this.freeMemoryChecks(address);
        if (address == 0L) {
            return;
        }
        this.freeMemory0(address);
    }

    private void freeMemoryChecks(long address) {
        this.checkPointer(null, address);
    }

    public void writebackMemory(long address, long length) {
        this.checkWritebackEnabled();
        this.checkWritebackMemory(address, length);
        this.writebackPreSync0();
        long end = address + length;
        for (long line = this.dataCacheLineAlignDown(address); line < end; line += (long)this.dataCacheLineFlushSize()) {
            this.writeback0(line);
        }
        this.writebackPostSync0();
    }

    private void checkWritebackMemory(long address, long length) {
        this.checkNativeAddress(address);
        this.checkSize(length);
    }

    private void checkWritebackEnabled() {
        if (!Unsafe.isWritebackEnabled()) {
            throw new RuntimeException("writebackMemory not enabled!");
        }
    }

    @IntrinsicCandidate
    private native void writeback0(long var1);

    @IntrinsicCandidate
    private native void writebackPreSync0();

    @IntrinsicCandidate
    private native void writebackPostSync0();

    public long objectFieldOffset(Field f) {
        if (f == null) {
            throw new NullPointerException();
        }
        return this.objectFieldOffset0(f);
    }

    public long objectFieldOffset(Class<?> c, String name) {
        if (c == null || name == null) {
            throw new NullPointerException();
        }
        return this.objectFieldOffset1(c, name);
    }

    public long staticFieldOffset(Field f) {
        if (f == null) {
            throw new NullPointerException();
        }
        return this.staticFieldOffset0(f);
    }

    public Object staticFieldBase(Field f) {
        if (f == null) {
            throw new NullPointerException();
        }
        return this.staticFieldBase0(f);
    }

    public boolean shouldBeInitialized(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.shouldBeInitialized0(c);
    }

    public void ensureClassInitialized(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.ensureClassInitialized0(c);
    }

    public int arrayBaseOffset(Class<?> arrayClass) {
        if (arrayClass == null) {
            throw new NullPointerException();
        }
        return this.arrayBaseOffset0(arrayClass);
    }

    public int arrayIndexScale(Class<?> arrayClass) {
        if (arrayClass == null) {
            throw new NullPointerException();
        }
        return this.arrayIndexScale0(arrayClass);
    }

    public int addressSize() {
        return ADDRESS_SIZE;
    }

    public int pageSize() {
        return UnsafeConstants.PAGE_SIZE;
    }

    public int dataCacheLineFlushSize() {
        return UnsafeConstants.DATA_CACHE_LINE_FLUSH_SIZE;
    }

    public long dataCacheLineAlignDown(long address) {
        return address & (long)(~(UnsafeConstants.DATA_CACHE_LINE_FLUSH_SIZE - 1));
    }

    public static boolean isWritebackEnabled() {
        return UnsafeConstants.DATA_CACHE_LINE_FLUSH_SIZE != 0;
    }

    public Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.defineClass0(name, b, off, len, loader, protectionDomain);
    }

    public native Class<?> defineClass0(String var1, byte[] var2, int var3, int var4, ClassLoader var5, ProtectionDomain var6);

    @IntrinsicCandidate
    public native Object allocateInstance(Class<?> var1) throws InstantiationException;

    public Object allocateUninitializedArray(Class<?> componentType, int length) {
        if (componentType == null) {
            throw new IllegalArgumentException("Component type is null");
        }
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("Component type is not primitive");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        return this.allocateUninitializedArray0(componentType, length);
    }

    @IntrinsicCandidate
    private Object allocateUninitializedArray0(Class<?> componentType, int length) {
        if (componentType == Byte.TYPE) {
            return new byte[length];
        }
        if (componentType == Boolean.TYPE) {
            return new boolean[length];
        }
        if (componentType == Short.TYPE) {
            return new short[length];
        }
        if (componentType == Character.TYPE) {
            return new char[length];
        }
        if (componentType == Integer.TYPE) {
            return new int[length];
        }
        if (componentType == Float.TYPE) {
            return new float[length];
        }
        if (componentType == Long.TYPE) {
            return new long[length];
        }
        if (componentType == Double.TYPE) {
            return new double[length];
        }
        return null;
    }

    public native void throwException(Throwable var1);

    @IntrinsicCandidate
    public final native boolean compareAndSetReference(Object var1, long var2, Object var4, Object var5);

    @IntrinsicCandidate
    public final native Object compareAndExchangeReference(Object var1, long var2, Object var4, Object var5);

    @IntrinsicCandidate
    public final Object compareAndExchangeReferenceAcquire(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final Object compareAndExchangeReferenceRelease(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetReferencePlain(Object o, long offset, Object expected, Object x) {
        return this.compareAndSetReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetReferenceAcquire(Object o, long offset, Object expected, Object x) {
        return this.compareAndSetReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetReferenceRelease(Object o, long offset, Object expected, Object x) {
        return this.compareAndSetReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetReference(Object o, long offset, Object expected, Object x) {
        return this.compareAndSetReference(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final native boolean compareAndSetInt(Object var1, long var2, int var4, int var5);

    @IntrinsicCandidate
    public final native int compareAndExchangeInt(Object var1, long var2, int var4, int var5);

    @IntrinsicCandidate
    public final int compareAndExchangeIntAcquire(Object o, long offset, int expected, int x) {
        return this.compareAndExchangeInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final int compareAndExchangeIntRelease(Object o, long offset, int expected, int x) {
        return this.compareAndExchangeInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetIntPlain(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetIntAcquire(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetIntRelease(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetInt(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final byte compareAndExchangeByte(Object o, long offset, byte expected, byte x) {
        int fullWord;
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (UnsafeConstants.BIG_ENDIAN) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (x & 0xFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!this.weakCompareAndSetInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @IntrinsicCandidate
    public final boolean compareAndSetByte(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x) == expected;
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetByte(Object o, long offset, byte expected, byte x) {
        return this.compareAndSetByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetByteAcquire(Object o, long offset, byte expected, byte x) {
        return this.weakCompareAndSetByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetByteRelease(Object o, long offset, byte expected, byte x) {
        return this.weakCompareAndSetByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetBytePlain(Object o, long offset, byte expected, byte x) {
        return this.weakCompareAndSetByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final byte compareAndExchangeByteAcquire(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final byte compareAndExchangeByteRelease(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final short compareAndExchangeShort(Object o, long offset, short expected, short x) {
        int fullWord;
        if ((offset & 3L) == 3L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (UnsafeConstants.BIG_ENDIAN) {
            shift = 16 - shift;
        }
        int mask = 65535 << shift;
        int maskedExpected = (expected & 0xFFFF) << shift;
        int maskedX = (x & 0xFFFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (short)((fullWord & mask) >> shift);
        } while (!this.weakCompareAndSetInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @IntrinsicCandidate
    public final boolean compareAndSetShort(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x) == expected;
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetShort(Object o, long offset, short expected, short x) {
        return this.compareAndSetShort(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetShortAcquire(Object o, long offset, short expected, short x) {
        return this.weakCompareAndSetShort(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetShortRelease(Object o, long offset, short expected, short x) {
        return this.weakCompareAndSetShort(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetShortPlain(Object o, long offset, short expected, short x) {
        return this.weakCompareAndSetShort(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final short compareAndExchangeShortAcquire(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final short compareAndExchangeShortRelease(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x);
    }

    @ForceInline
    private char s2c(short s) {
        return (char)s;
    }

    @ForceInline
    private short c2s(char s) {
        return (short)s;
    }

    @ForceInline
    public final boolean compareAndSetChar(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, this.c2s(expected), this.c2s(x));
    }

    @ForceInline
    public final char compareAndExchangeChar(Object o, long offset, char expected, char x) {
        return this.s2c(this.compareAndExchangeShort(o, offset, this.c2s(expected), this.c2s(x)));
    }

    @ForceInline
    public final char compareAndExchangeCharAcquire(Object o, long offset, char expected, char x) {
        return this.s2c(this.compareAndExchangeShortAcquire(o, offset, this.c2s(expected), this.c2s(x)));
    }

    @ForceInline
    public final char compareAndExchangeCharRelease(Object o, long offset, char expected, char x) {
        return this.s2c(this.compareAndExchangeShortRelease(o, offset, this.c2s(expected), this.c2s(x)));
    }

    @ForceInline
    public final boolean weakCompareAndSetChar(Object o, long offset, char expected, char x) {
        return this.weakCompareAndSetShort(o, offset, this.c2s(expected), this.c2s(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetCharAcquire(Object o, long offset, char expected, char x) {
        return this.weakCompareAndSetShortAcquire(o, offset, this.c2s(expected), this.c2s(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetCharRelease(Object o, long offset, char expected, char x) {
        return this.weakCompareAndSetShortRelease(o, offset, this.c2s(expected), this.c2s(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetCharPlain(Object o, long offset, char expected, char x) {
        return this.weakCompareAndSetShortPlain(o, offset, this.c2s(expected), this.c2s(x));
    }

    @ForceInline
    private boolean byte2bool(byte b) {
        return b != 0;
    }

    @ForceInline
    private byte bool2byte(boolean b) {
        return b ? (byte)1 : 0;
    }

    @ForceInline
    public final boolean compareAndSetBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, this.bool2byte(expected), this.bool2byte(x));
    }

    @ForceInline
    public final boolean compareAndExchangeBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.byte2bool(this.compareAndExchangeByte(o, offset, this.bool2byte(expected), this.bool2byte(x)));
    }

    @ForceInline
    public final boolean compareAndExchangeBooleanAcquire(Object o, long offset, boolean expected, boolean x) {
        return this.byte2bool(this.compareAndExchangeByteAcquire(o, offset, this.bool2byte(expected), this.bool2byte(x)));
    }

    @ForceInline
    public final boolean compareAndExchangeBooleanRelease(Object o, long offset, boolean expected, boolean x) {
        return this.byte2bool(this.compareAndExchangeByteRelease(o, offset, this.bool2byte(expected), this.bool2byte(x)));
    }

    @ForceInline
    public final boolean weakCompareAndSetBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.weakCompareAndSetByte(o, offset, this.bool2byte(expected), this.bool2byte(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetBooleanAcquire(Object o, long offset, boolean expected, boolean x) {
        return this.weakCompareAndSetByteAcquire(o, offset, this.bool2byte(expected), this.bool2byte(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetBooleanRelease(Object o, long offset, boolean expected, boolean x) {
        return this.weakCompareAndSetByteRelease(o, offset, this.bool2byte(expected), this.bool2byte(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetBooleanPlain(Object o, long offset, boolean expected, boolean x) {
        return this.weakCompareAndSetBytePlain(o, offset, this.bool2byte(expected), this.bool2byte(x));
    }

    @ForceInline
    public final boolean compareAndSetFloat(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @ForceInline
    public final float compareAndExchangeFloat(Object o, long offset, float expected, float x) {
        int w = this.compareAndExchangeInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
        return Float.intBitsToFloat(w);
    }

    @ForceInline
    public final float compareAndExchangeFloatAcquire(Object o, long offset, float expected, float x) {
        int w = this.compareAndExchangeIntAcquire(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
        return Float.intBitsToFloat(w);
    }

    @ForceInline
    public final float compareAndExchangeFloatRelease(Object o, long offset, float expected, float x) {
        int w = this.compareAndExchangeIntRelease(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
        return Float.intBitsToFloat(w);
    }

    @ForceInline
    public final boolean weakCompareAndSetFloatPlain(Object o, long offset, float expected, float x) {
        return this.weakCompareAndSetIntPlain(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetFloatAcquire(Object o, long offset, float expected, float x) {
        return this.weakCompareAndSetIntAcquire(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetFloatRelease(Object o, long offset, float expected, float x) {
        return this.weakCompareAndSetIntRelease(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetFloat(Object o, long offset, float expected, float x) {
        return this.weakCompareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @ForceInline
    public final boolean compareAndSetDouble(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @ForceInline
    public final double compareAndExchangeDouble(Object o, long offset, double expected, double x) {
        long w = this.compareAndExchangeLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
        return Double.longBitsToDouble(w);
    }

    @ForceInline
    public final double compareAndExchangeDoubleAcquire(Object o, long offset, double expected, double x) {
        long w = this.compareAndExchangeLongAcquire(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
        return Double.longBitsToDouble(w);
    }

    @ForceInline
    public final double compareAndExchangeDoubleRelease(Object o, long offset, double expected, double x) {
        long w = this.compareAndExchangeLongRelease(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
        return Double.longBitsToDouble(w);
    }

    @ForceInline
    public final boolean weakCompareAndSetDoublePlain(Object o, long offset, double expected, double x) {
        return this.weakCompareAndSetLongPlain(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetDoubleAcquire(Object o, long offset, double expected, double x) {
        return this.weakCompareAndSetLongAcquire(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetDoubleRelease(Object o, long offset, double expected, double x) {
        return this.weakCompareAndSetLongRelease(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @ForceInline
    public final boolean weakCompareAndSetDouble(Object o, long offset, double expected, double x) {
        return this.weakCompareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @IntrinsicCandidate
    public final native boolean compareAndSetLong(Object var1, long var2, long var4, long var6);

    @IntrinsicCandidate
    public final native long compareAndExchangeLong(Object var1, long var2, long var4, long var6);

    @IntrinsicCandidate
    public final long compareAndExchangeLongAcquire(Object o, long offset, long expected, long x) {
        return this.compareAndExchangeLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final long compareAndExchangeLongRelease(Object o, long offset, long expected, long x) {
        return this.compareAndExchangeLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetLongPlain(Object o, long offset, long expected, long x) {
        return this.compareAndSetLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetLongAcquire(Object o, long offset, long expected, long x) {
        return this.compareAndSetLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetLongRelease(Object o, long offset, long expected, long x) {
        return this.compareAndSetLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public final boolean weakCompareAndSetLong(Object o, long offset, long expected, long x) {
        return this.compareAndSetLong(o, offset, expected, x);
    }

    @IntrinsicCandidate
    public native Object getReferenceVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putReferenceVolatile(Object var1, long var2, Object var4);

    @IntrinsicCandidate
    public native int getIntVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putIntVolatile(Object var1, long var2, int var4);

    @IntrinsicCandidate
    public native boolean getBooleanVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putBooleanVolatile(Object var1, long var2, boolean var4);

    @IntrinsicCandidate
    public native byte getByteVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putByteVolatile(Object var1, long var2, byte var4);

    @IntrinsicCandidate
    public native short getShortVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putShortVolatile(Object var1, long var2, short var4);

    @IntrinsicCandidate
    public native char getCharVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putCharVolatile(Object var1, long var2, char var4);

    @IntrinsicCandidate
    public native long getLongVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putLongVolatile(Object var1, long var2, long var4);

    @IntrinsicCandidate
    public native float getFloatVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putFloatVolatile(Object var1, long var2, float var4);

    @IntrinsicCandidate
    public native double getDoubleVolatile(Object var1, long var2);

    @IntrinsicCandidate
    public native void putDoubleVolatile(Object var1, long var2, double var4);

    @IntrinsicCandidate
    public final Object getReferenceAcquire(Object o, long offset) {
        return this.getReferenceVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final boolean getBooleanAcquire(Object o, long offset) {
        return this.getBooleanVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final byte getByteAcquire(Object o, long offset) {
        return this.getByteVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final short getShortAcquire(Object o, long offset) {
        return this.getShortVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final char getCharAcquire(Object o, long offset) {
        return this.getCharVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final int getIntAcquire(Object o, long offset) {
        return this.getIntVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final float getFloatAcquire(Object o, long offset) {
        return this.getFloatVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final long getLongAcquire(Object o, long offset) {
        return this.getLongVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final double getDoubleAcquire(Object o, long offset) {
        return this.getDoubleVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final void putReferenceRelease(Object o, long offset, Object x) {
        this.putReferenceVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putBooleanRelease(Object o, long offset, boolean x) {
        this.putBooleanVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putByteRelease(Object o, long offset, byte x) {
        this.putByteVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putShortRelease(Object o, long offset, short x) {
        this.putShortVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putCharRelease(Object o, long offset, char x) {
        this.putCharVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putIntRelease(Object o, long offset, int x) {
        this.putIntVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putFloatRelease(Object o, long offset, float x) {
        this.putFloatVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putLongRelease(Object o, long offset, long x) {
        this.putLongVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putDoubleRelease(Object o, long offset, double x) {
        this.putDoubleVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final Object getReferenceOpaque(Object o, long offset) {
        return this.getReferenceVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final boolean getBooleanOpaque(Object o, long offset) {
        return this.getBooleanVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final byte getByteOpaque(Object o, long offset) {
        return this.getByteVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final short getShortOpaque(Object o, long offset) {
        return this.getShortVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final char getCharOpaque(Object o, long offset) {
        return this.getCharVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final int getIntOpaque(Object o, long offset) {
        return this.getIntVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final float getFloatOpaque(Object o, long offset) {
        return this.getFloatVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final long getLongOpaque(Object o, long offset) {
        return this.getLongVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final double getDoubleOpaque(Object o, long offset) {
        return this.getDoubleVolatile(o, offset);
    }

    @IntrinsicCandidate
    public final void putReferenceOpaque(Object o, long offset, Object x) {
        this.putReferenceVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putBooleanOpaque(Object o, long offset, boolean x) {
        this.putBooleanVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putByteOpaque(Object o, long offset, byte x) {
        this.putByteVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putShortOpaque(Object o, long offset, short x) {
        this.putShortVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putCharOpaque(Object o, long offset, char x) {
        this.putCharVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putIntOpaque(Object o, long offset, int x) {
        this.putIntVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putFloatOpaque(Object o, long offset, float x) {
        this.putFloatVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putLongOpaque(Object o, long offset, long x) {
        this.putLongVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public final void putDoubleOpaque(Object o, long offset, double x) {
        this.putDoubleVolatile(o, offset, x);
    }

    @IntrinsicCandidate
    public native void unpark(Object var1);

    @IntrinsicCandidate
    public native void park(boolean var1, long var2);

    public int getLoadAverage(double[] loadavg, int nelems) {
        if (nelems < 0 || nelems > 3 || nelems > loadavg.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getLoadAverage0(loadavg, nelems);
    }

    @IntrinsicCandidate
    public final int getAndAddInt(Object o, long offset, int delta) {
        int v;
        while (!this.weakCompareAndSetInt(o, offset, v = this.getIntVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    @ForceInline
    public final int getAndAddIntRelease(Object o, long offset, int delta) {
        int v;
        while (!this.weakCompareAndSetIntRelease(o, offset, v = this.getInt(o, offset), v + delta)) {
        }
        return v;
    }

    @ForceInline
    public final int getAndAddIntAcquire(Object o, long offset, int delta) {
        int v;
        while (!this.weakCompareAndSetIntAcquire(o, offset, v = this.getIntAcquire(o, offset), v + delta)) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final long getAndAddLong(Object o, long offset, long delta) {
        long v;
        while (!this.weakCompareAndSetLong(o, offset, v = this.getLongVolatile(o, offset), v + delta)) {
        }
        return v;
    }

    @ForceInline
    public final long getAndAddLongRelease(Object o, long offset, long delta) {
        long v;
        while (!this.weakCompareAndSetLongRelease(o, offset, v = this.getLong(o, offset), v + delta)) {
        }
        return v;
    }

    @ForceInline
    public final long getAndAddLongAcquire(Object o, long offset, long delta) {
        long v;
        while (!this.weakCompareAndSetLongAcquire(o, offset, v = this.getLongAcquire(o, offset), v + delta)) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final byte getAndAddByte(Object o, long offset, byte delta) {
        byte v;
        while (!this.weakCompareAndSetByte(o, offset, v = this.getByteVolatile(o, offset), (byte)(v + delta))) {
        }
        return v;
    }

    @ForceInline
    public final byte getAndAddByteRelease(Object o, long offset, byte delta) {
        byte v;
        while (!this.weakCompareAndSetByteRelease(o, offset, v = this.getByte(o, offset), (byte)(v + delta))) {
        }
        return v;
    }

    @ForceInline
    public final byte getAndAddByteAcquire(Object o, long offset, byte delta) {
        byte v;
        while (!this.weakCompareAndSetByteAcquire(o, offset, v = this.getByteAcquire(o, offset), (byte)(v + delta))) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final short getAndAddShort(Object o, long offset, short delta) {
        short v;
        while (!this.weakCompareAndSetShort(o, offset, v = this.getShortVolatile(o, offset), (short)(v + delta))) {
        }
        return v;
    }

    @ForceInline
    public final short getAndAddShortRelease(Object o, long offset, short delta) {
        short v;
        while (!this.weakCompareAndSetShortRelease(o, offset, v = this.getShort(o, offset), (short)(v + delta))) {
        }
        return v;
    }

    @ForceInline
    public final short getAndAddShortAcquire(Object o, long offset, short delta) {
        short v;
        while (!this.weakCompareAndSetShortAcquire(o, offset, v = this.getShortAcquire(o, offset), (short)(v + delta))) {
        }
        return v;
    }

    @ForceInline
    public final char getAndAddChar(Object o, long offset, char delta) {
        return (char)this.getAndAddShort(o, offset, (short)delta);
    }

    @ForceInline
    public final char getAndAddCharRelease(Object o, long offset, char delta) {
        return (char)this.getAndAddShortRelease(o, offset, (short)delta);
    }

    @ForceInline
    public final char getAndAddCharAcquire(Object o, long offset, char delta) {
        return (char)this.getAndAddShortAcquire(o, offset, (short)delta);
    }

    @ForceInline
    public final float getAndAddFloat(Object o, long offset, float delta) {
        float v;
        int expectedBits;
        while (!this.weakCompareAndSetInt(o, offset, expectedBits = this.getIntVolatile(o, offset), Float.floatToRawIntBits((v = Float.intBitsToFloat(expectedBits)) + delta))) {
        }
        return v;
    }

    @ForceInline
    public final float getAndAddFloatRelease(Object o, long offset, float delta) {
        float v;
        int expectedBits;
        while (!this.weakCompareAndSetIntRelease(o, offset, expectedBits = this.getInt(o, offset), Float.floatToRawIntBits((v = Float.intBitsToFloat(expectedBits)) + delta))) {
        }
        return v;
    }

    @ForceInline
    public final float getAndAddFloatAcquire(Object o, long offset, float delta) {
        float v;
        int expectedBits;
        while (!this.weakCompareAndSetIntAcquire(o, offset, expectedBits = this.getIntAcquire(o, offset), Float.floatToRawIntBits((v = Float.intBitsToFloat(expectedBits)) + delta))) {
        }
        return v;
    }

    @ForceInline
    public final double getAndAddDouble(Object o, long offset, double delta) {
        double v;
        long expectedBits;
        while (!this.weakCompareAndSetLong(o, offset, expectedBits = this.getLongVolatile(o, offset), Double.doubleToRawLongBits((v = Double.longBitsToDouble(expectedBits)) + delta))) {
        }
        return v;
    }

    @ForceInline
    public final double getAndAddDoubleRelease(Object o, long offset, double delta) {
        double v;
        long expectedBits;
        while (!this.weakCompareAndSetLongRelease(o, offset, expectedBits = this.getLong(o, offset), Double.doubleToRawLongBits((v = Double.longBitsToDouble(expectedBits)) + delta))) {
        }
        return v;
    }

    @ForceInline
    public final double getAndAddDoubleAcquire(Object o, long offset, double delta) {
        double v;
        long expectedBits;
        while (!this.weakCompareAndSetLongAcquire(o, offset, expectedBits = this.getLongAcquire(o, offset), Double.doubleToRawLongBits((v = Double.longBitsToDouble(expectedBits)) + delta))) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final int getAndSetInt(Object o, long offset, int newValue) {
        int v;
        while (!this.weakCompareAndSetInt(o, offset, v = this.getIntVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final int getAndSetIntRelease(Object o, long offset, int newValue) {
        int v;
        while (!this.weakCompareAndSetIntRelease(o, offset, v = this.getInt(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final int getAndSetIntAcquire(Object o, long offset, int newValue) {
        int v;
        while (!this.weakCompareAndSetIntAcquire(o, offset, v = this.getIntAcquire(o, offset), newValue)) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final long getAndSetLong(Object o, long offset, long newValue) {
        long v;
        while (!this.weakCompareAndSetLong(o, offset, v = this.getLongVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final long getAndSetLongRelease(Object o, long offset, long newValue) {
        long v;
        while (!this.weakCompareAndSetLongRelease(o, offset, v = this.getLong(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final long getAndSetLongAcquire(Object o, long offset, long newValue) {
        long v;
        while (!this.weakCompareAndSetLongAcquire(o, offset, v = this.getLongAcquire(o, offset), newValue)) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final Object getAndSetReference(Object o, long offset, Object newValue) {
        Object v;
        while (!this.weakCompareAndSetReference(o, offset, v = this.getReferenceVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final Object getAndSetReferenceRelease(Object o, long offset, Object newValue) {
        Object v;
        while (!this.weakCompareAndSetReferenceRelease(o, offset, v = this.getReference(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final Object getAndSetReferenceAcquire(Object o, long offset, Object newValue) {
        Object v;
        while (!this.weakCompareAndSetReferenceAcquire(o, offset, v = this.getReferenceAcquire(o, offset), newValue)) {
        }
        return v;
    }

    @IntrinsicCandidate
    public final byte getAndSetByte(Object o, long offset, byte newValue) {
        byte v;
        while (!this.weakCompareAndSetByte(o, offset, v = this.getByteVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final byte getAndSetByteRelease(Object o, long offset, byte newValue) {
        byte v;
        while (!this.weakCompareAndSetByteRelease(o, offset, v = this.getByte(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final byte getAndSetByteAcquire(Object o, long offset, byte newValue) {
        byte v;
        while (!this.weakCompareAndSetByteAcquire(o, offset, v = this.getByteAcquire(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final boolean getAndSetBoolean(Object o, long offset, boolean newValue) {
        return this.byte2bool(this.getAndSetByte(o, offset, this.bool2byte(newValue)));
    }

    @ForceInline
    public final boolean getAndSetBooleanRelease(Object o, long offset, boolean newValue) {
        return this.byte2bool(this.getAndSetByteRelease(o, offset, this.bool2byte(newValue)));
    }

    @ForceInline
    public final boolean getAndSetBooleanAcquire(Object o, long offset, boolean newValue) {
        return this.byte2bool(this.getAndSetByteAcquire(o, offset, this.bool2byte(newValue)));
    }

    @IntrinsicCandidate
    public final short getAndSetShort(Object o, long offset, short newValue) {
        short v;
        while (!this.weakCompareAndSetShort(o, offset, v = this.getShortVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final short getAndSetShortRelease(Object o, long offset, short newValue) {
        short v;
        while (!this.weakCompareAndSetShortRelease(o, offset, v = this.getShort(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final short getAndSetShortAcquire(Object o, long offset, short newValue) {
        short v;
        while (!this.weakCompareAndSetShortAcquire(o, offset, v = this.getShortAcquire(o, offset), newValue)) {
        }
        return v;
    }

    @ForceInline
    public final char getAndSetChar(Object o, long offset, char newValue) {
        return this.s2c(this.getAndSetShort(o, offset, this.c2s(newValue)));
    }

    @ForceInline
    public final char getAndSetCharRelease(Object o, long offset, char newValue) {
        return this.s2c(this.getAndSetShortRelease(o, offset, this.c2s(newValue)));
    }

    @ForceInline
    public final char getAndSetCharAcquire(Object o, long offset, char newValue) {
        return this.s2c(this.getAndSetShortAcquire(o, offset, this.c2s(newValue)));
    }

    @ForceInline
    public final float getAndSetFloat(Object o, long offset, float newValue) {
        int v = this.getAndSetInt(o, offset, Float.floatToRawIntBits(newValue));
        return Float.intBitsToFloat(v);
    }

    @ForceInline
    public final float getAndSetFloatRelease(Object o, long offset, float newValue) {
        int v = this.getAndSetIntRelease(o, offset, Float.floatToRawIntBits(newValue));
        return Float.intBitsToFloat(v);
    }

    @ForceInline
    public final float getAndSetFloatAcquire(Object o, long offset, float newValue) {
        int v = this.getAndSetIntAcquire(o, offset, Float.floatToRawIntBits(newValue));
        return Float.intBitsToFloat(v);
    }

    @ForceInline
    public final double getAndSetDouble(Object o, long offset, double newValue) {
        long v = this.getAndSetLong(o, offset, Double.doubleToRawLongBits(newValue));
        return Double.longBitsToDouble(v);
    }

    @ForceInline
    public final double getAndSetDoubleRelease(Object o, long offset, double newValue) {
        long v = this.getAndSetLongRelease(o, offset, Double.doubleToRawLongBits(newValue));
        return Double.longBitsToDouble(v);
    }

    @ForceInline
    public final double getAndSetDoubleAcquire(Object o, long offset, double newValue) {
        long v = this.getAndSetLongAcquire(o, offset, Double.doubleToRawLongBits(newValue));
        return Double.longBitsToDouble(v);
    }

    @ForceInline
    public final boolean getAndBitwiseOrBoolean(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseOrByte(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseOrBooleanRelease(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseOrByteRelease(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseOrBooleanAcquire(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseOrByteAcquire(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseAndBoolean(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseAndByte(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseAndBooleanRelease(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseAndByteRelease(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseAndBooleanAcquire(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseAndByteAcquire(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseXorBoolean(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseXorByte(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseXorBooleanRelease(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseXorByteRelease(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final boolean getAndBitwiseXorBooleanAcquire(Object o, long offset, boolean mask) {
        return this.byte2bool(this.getAndBitwiseXorByteAcquire(o, offset, this.bool2byte(mask)));
    }

    @ForceInline
    public final byte getAndBitwiseOrByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByte(o, offset, current = this.getByteVolatile(o, offset), (byte)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseOrByteRelease(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteRelease(o, offset, current = this.getByte(o, offset), (byte)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseOrByteAcquire(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteAcquire(o, offset, current = this.getByte(o, offset), (byte)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseAndByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByte(o, offset, current = this.getByteVolatile(o, offset), (byte)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseAndByteRelease(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteRelease(o, offset, current = this.getByte(o, offset), (byte)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseAndByteAcquire(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteAcquire(o, offset, current = this.getByte(o, offset), (byte)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseXorByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByte(o, offset, current = this.getByteVolatile(o, offset), (byte)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseXorByteRelease(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteRelease(o, offset, current = this.getByte(o, offset), (byte)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final byte getAndBitwiseXorByteAcquire(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteAcquire(o, offset, current = this.getByte(o, offset), (byte)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final char getAndBitwiseOrChar(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseOrShort(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseOrCharRelease(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseOrShortRelease(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseOrCharAcquire(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseOrShortAcquire(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseAndChar(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseAndShort(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseAndCharRelease(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseAndShortRelease(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseAndCharAcquire(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseAndShortAcquire(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseXorChar(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseXorShort(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseXorCharRelease(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseXorShortRelease(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final char getAndBitwiseXorCharAcquire(Object o, long offset, char mask) {
        return this.s2c(this.getAndBitwiseXorShortAcquire(o, offset, this.c2s(mask)));
    }

    @ForceInline
    public final short getAndBitwiseOrShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseOrShortRelease(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortRelease(o, offset, current = this.getShort(o, offset), (short)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseOrShortAcquire(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortAcquire(o, offset, current = this.getShort(o, offset), (short)(current | mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseAndShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseAndShortRelease(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortRelease(o, offset, current = this.getShort(o, offset), (short)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseAndShortAcquire(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortAcquire(o, offset, current = this.getShort(o, offset), (short)(current & mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseXorShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseXorShortRelease(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortRelease(o, offset, current = this.getShort(o, offset), (short)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final short getAndBitwiseXorShortAcquire(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShortAcquire(o, offset, current = this.getShort(o, offset), (short)(current ^ mask))) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseOrInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseOrIntRelease(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntRelease(o, offset, current = this.getInt(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseOrIntAcquire(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntAcquire(o, offset, current = this.getInt(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseAndInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseAndIntRelease(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntRelease(o, offset, current = this.getInt(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseAndIntAcquire(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntAcquire(o, offset, current = this.getInt(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseXorInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current ^ mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseXorIntRelease(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntRelease(o, offset, current = this.getInt(o, offset), current ^ mask)) {
        }
        return current;
    }

    @ForceInline
    public final int getAndBitwiseXorIntAcquire(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetIntAcquire(o, offset, current = this.getInt(o, offset), current ^ mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseOrLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseOrLongRelease(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongRelease(o, offset, current = this.getLong(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseOrLongAcquire(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongAcquire(o, offset, current = this.getLong(o, offset), current | mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseAndLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseAndLongRelease(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongRelease(o, offset, current = this.getLong(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseAndLongAcquire(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongAcquire(o, offset, current = this.getLong(o, offset), current & mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseXorLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current ^ mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseXorLongRelease(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongRelease(o, offset, current = this.getLong(o, offset), current ^ mask)) {
        }
        return current;
    }

    @ForceInline
    public final long getAndBitwiseXorLongAcquire(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLongAcquire(o, offset, current = this.getLong(o, offset), current ^ mask)) {
        }
        return current;
    }

    @IntrinsicCandidate
    public native void loadFence();

    @IntrinsicCandidate
    public native void storeFence();

    @IntrinsicCandidate
    public native void fullFence();

    public final void loadLoadFence() {
        this.loadFence();
    }

    public final void storeStoreFence() {
        this.storeFence();
    }

    private static void throwIllegalAccessError() {
        throw new IllegalAccessError();
    }

    private static void throwNoSuchMethodError() {
        throw new NoSuchMethodError();
    }

    public final boolean isBigEndian() {
        return UnsafeConstants.BIG_ENDIAN;
    }

    public final boolean unalignedAccess() {
        return UnsafeConstants.UNALIGNED_ACCESS;
    }

    @IntrinsicCandidate
    public final long getLongUnaligned(Object o, long offset) {
        if ((offset & 7L) == 0L) {
            return this.getLong(o, offset);
        }
        if ((offset & 3L) == 0L) {
            return Unsafe.makeLong(this.getInt(o, offset), this.getInt(o, offset + 4L));
        }
        if ((offset & 1L) == 0L) {
            return Unsafe.makeLong(this.getShort(o, offset), this.getShort(o, offset + 2L), this.getShort(o, offset + 4L), this.getShort(o, offset + 6L));
        }
        return Unsafe.makeLong(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L), this.getByte(o, offset + 4L), this.getByte(o, offset + 5L), this.getByte(o, offset + 6L), this.getByte(o, offset + 7L));
    }

    public final long getLongUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getLongUnaligned(o, offset));
    }

    @IntrinsicCandidate
    public final int getIntUnaligned(Object o, long offset) {
        if ((offset & 3L) == 0L) {
            return this.getInt(o, offset);
        }
        if ((offset & 1L) == 0L) {
            return Unsafe.makeInt(this.getShort(o, offset), this.getShort(o, offset + 2L));
        }
        return Unsafe.makeInt(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L));
    }

    public final int getIntUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getIntUnaligned(o, offset));
    }

    @IntrinsicCandidate
    public final short getShortUnaligned(Object o, long offset) {
        if ((offset & 1L) == 0L) {
            return this.getShort(o, offset);
        }
        return Unsafe.makeShort(this.getByte(o, offset), this.getByte(o, offset + 1L));
    }

    public final short getShortUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getShortUnaligned(o, offset));
    }

    @IntrinsicCandidate
    public final char getCharUnaligned(Object o, long offset) {
        if ((offset & 1L) == 0L) {
            return this.getChar(o, offset);
        }
        return (char)Unsafe.makeShort(this.getByte(o, offset), this.getByte(o, offset + 1L));
    }

    public final char getCharUnaligned(Object o, long offset, boolean bigEndian) {
        return Unsafe.convEndian(bigEndian, this.getCharUnaligned(o, offset));
    }

    @IntrinsicCandidate
    public final void putLongUnaligned(Object o, long offset, long x) {
        if ((offset & 7L) == 0L) {
            this.putLong(o, offset, x);
        } else if ((offset & 3L) == 0L) {
            this.putLongParts(o, offset, (int)(x >> 0), (int)(x >>> 32));
        } else if ((offset & 1L) == 0L) {
            this.putLongParts(o, offset, (short)(x >>> 0), (short)(x >>> 16), (short)(x >>> 32), (short)(x >>> 48));
        } else {
            this.putLongParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24), (byte)(x >>> 32), (byte)(x >>> 40), (byte)(x >>> 48), (byte)(x >>> 56));
        }
    }

    public final void putLongUnaligned(Object o, long offset, long x, boolean bigEndian) {
        this.putLongUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    @IntrinsicCandidate
    public final void putIntUnaligned(Object o, long offset, int x) {
        if ((offset & 3L) == 0L) {
            this.putInt(o, offset, x);
        } else if ((offset & 1L) == 0L) {
            this.putIntParts(o, offset, (short)(x >> 0), (short)(x >>> 16));
        } else {
            this.putIntParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24));
        }
    }

    public final void putIntUnaligned(Object o, long offset, int x, boolean bigEndian) {
        this.putIntUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    @IntrinsicCandidate
    public final void putShortUnaligned(Object o, long offset, short x) {
        if ((offset & 1L) == 0L) {
            this.putShort(o, offset, x);
        } else {
            this.putShortParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8));
        }
    }

    public final void putShortUnaligned(Object o, long offset, short x, boolean bigEndian) {
        this.putShortUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    @IntrinsicCandidate
    public final void putCharUnaligned(Object o, long offset, char x) {
        this.putShortUnaligned(o, offset, (short)x);
    }

    public final void putCharUnaligned(Object o, long offset, char x, boolean bigEndian) {
        this.putCharUnaligned(o, offset, Unsafe.convEndian(bigEndian, x));
    }

    private static int pickPos(int top, int pos) {
        return UnsafeConstants.BIG_ENDIAN ? top - pos : pos;
    }

    private static long makeLong(byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(56, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(56, 8) | Unsafe.toUnsignedLong(i2) << Unsafe.pickPos(56, 16) | Unsafe.toUnsignedLong(i3) << Unsafe.pickPos(56, 24) | Unsafe.toUnsignedLong(i4) << Unsafe.pickPos(56, 32) | Unsafe.toUnsignedLong(i5) << Unsafe.pickPos(56, 40) | Unsafe.toUnsignedLong(i6) << Unsafe.pickPos(56, 48) | Unsafe.toUnsignedLong(i7) << Unsafe.pickPos(56, 56);
    }

    private static long makeLong(short i0, short i1, short i2, short i3) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(48, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(48, 16) | Unsafe.toUnsignedLong(i2) << Unsafe.pickPos(48, 32) | Unsafe.toUnsignedLong(i3) << Unsafe.pickPos(48, 48);
    }

    private static long makeLong(int i0, int i1) {
        return Unsafe.toUnsignedLong(i0) << Unsafe.pickPos(32, 0) | Unsafe.toUnsignedLong(i1) << Unsafe.pickPos(32, 32);
    }

    private static int makeInt(short i0, short i1) {
        return Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(16, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(16, 16);
    }

    private static int makeInt(byte i0, byte i1, byte i2, byte i3) {
        return Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(24, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(24, 8) | Unsafe.toUnsignedInt(i2) << Unsafe.pickPos(24, 16) | Unsafe.toUnsignedInt(i3) << Unsafe.pickPos(24, 24);
    }

    private static short makeShort(byte i0, byte i1) {
        return (short)(Unsafe.toUnsignedInt(i0) << Unsafe.pickPos(8, 0) | Unsafe.toUnsignedInt(i1) << Unsafe.pickPos(8, 8));
    }

    private static byte pick(byte le, byte be) {
        return UnsafeConstants.BIG_ENDIAN ? be : le;
    }

    private static short pick(short le, short be) {
        return UnsafeConstants.BIG_ENDIAN ? be : le;
    }

    private static int pick(int le, int be) {
        return UnsafeConstants.BIG_ENDIAN ? be : le;
    }

    private void putLongParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i7));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i6));
        this.putByte(o, offset + 2L, Unsafe.pick(i2, i5));
        this.putByte(o, offset + 3L, Unsafe.pick(i3, i4));
        this.putByte(o, offset + 4L, Unsafe.pick(i4, i3));
        this.putByte(o, offset + 5L, Unsafe.pick(i5, i2));
        this.putByte(o, offset + 6L, Unsafe.pick(i6, i1));
        this.putByte(o, offset + 7L, Unsafe.pick(i7, i0));
    }

    private void putLongParts(Object o, long offset, short i0, short i1, short i2, short i3) {
        this.putShort(o, offset + 0L, Unsafe.pick(i0, i3));
        this.putShort(o, offset + 2L, Unsafe.pick(i1, i2));
        this.putShort(o, offset + 4L, Unsafe.pick(i2, i1));
        this.putShort(o, offset + 6L, Unsafe.pick(i3, i0));
    }

    private void putLongParts(Object o, long offset, int i0, int i1) {
        this.putInt(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putInt(o, offset + 4L, Unsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, short i0, short i1) {
        this.putShort(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putShort(o, offset + 2L, Unsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i3));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i2));
        this.putByte(o, offset + 2L, Unsafe.pick(i2, i1));
        this.putByte(o, offset + 3L, Unsafe.pick(i3, i0));
    }

    private void putShortParts(Object o, long offset, byte i0, byte i1) {
        this.putByte(o, offset + 0L, Unsafe.pick(i0, i1));
        this.putByte(o, offset + 1L, Unsafe.pick(i1, i0));
    }

    private static int toUnsignedInt(byte n) {
        return n & 0xFF;
    }

    private static int toUnsignedInt(short n) {
        return n & 0xFFFF;
    }

    private static long toUnsignedLong(byte n) {
        return (long)n & 0xFFL;
    }

    private static long toUnsignedLong(short n) {
        return (long)n & 0xFFFFL;
    }

    private static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static char convEndian(boolean big, char n) {
        return big == UnsafeConstants.BIG_ENDIAN ? n : Character.reverseBytes(n);
    }

    private static short convEndian(boolean big, short n) {
        return big == UnsafeConstants.BIG_ENDIAN ? n : Short.reverseBytes(n);
    }

    private static int convEndian(boolean big, int n) {
        return big == UnsafeConstants.BIG_ENDIAN ? n : Integer.reverseBytes(n);
    }

    private static long convEndian(boolean big, long n) {
        return big == UnsafeConstants.BIG_ENDIAN ? n : Long.reverseBytes(n);
    }

    private native long allocateMemory0(long var1);

    private native long reallocateMemory0(long var1, long var3);

    private native void freeMemory0(long var1);

    private native void setMemory0(Object var1, long var2, long var4, byte var6);

    @IntrinsicCandidate
    private native void copyMemory0(Object var1, long var2, Object var4, long var5, long var7);

    private native void copySwapMemory0(Object var1, long var2, Object var4, long var5, long var7, long var9);

    private native long objectFieldOffset0(Field var1);

    private native long objectFieldOffset1(Class<?> var1, String var2);

    private native long staticFieldOffset0(Field var1);

    private native Object staticFieldBase0(Field var1);

    private native boolean shouldBeInitialized0(Class<?> var1);

    private native void ensureClassInitialized0(Class<?> var1);

    private native int arrayBaseOffset0(Class<?> var1);

    private native int arrayIndexScale0(Class<?> var1);

    private native int getLoadAverage0(double[] var1, int var2);

    public void invokeCleaner(ByteBuffer directBuffer) {
        if (!directBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer is non-direct");
        }
        DirectBuffer db = (DirectBuffer)((Object)directBuffer);
        if (db.attachment() != null) {
            throw new IllegalArgumentException("duplicate or slice");
        }
        Cleaner cleaner = db.cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getObject(Object o, long offset) {
        return this.getReference(o, offset);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getObjectVolatile(Object o, long offset) {
        return this.getReferenceVolatile(o, offset);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getObjectAcquire(Object o, long offset) {
        return this.getReferenceAcquire(o, offset);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getObjectOpaque(Object o, long offset) {
        return this.getReferenceOpaque(o, offset);
    }

    @Deprecated(since="12", forRemoval=true)
    public final void putObject(Object o, long offset, Object x) {
        this.putReference(o, offset, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final void putObjectVolatile(Object o, long offset, Object x) {
        this.putReferenceVolatile(o, offset, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final void putObjectOpaque(Object o, long offset, Object x) {
        this.putReferenceOpaque(o, offset, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final void putObjectRelease(Object o, long offset, Object x) {
        this.putReferenceRelease(o, offset, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getAndSetObject(Object o, long offset, Object newValue) {
        return this.getAndSetReference(o, offset, newValue);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getAndSetObjectAcquire(Object o, long offset, Object newValue) {
        return this.getAndSetReferenceAcquire(o, offset, newValue);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object getAndSetObjectRelease(Object o, long offset, Object newValue) {
        return this.getAndSetReferenceRelease(o, offset, newValue);
    }

    @Deprecated(since="12", forRemoval=true)
    public final boolean compareAndSetObject(Object o, long offset, Object expected, Object x) {
        return this.compareAndSetReference(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object compareAndExchangeObject(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReference(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object compareAndExchangeObjectAcquire(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReferenceAcquire(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final Object compareAndExchangeObjectRelease(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReferenceRelease(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final boolean weakCompareAndSetObject(Object o, long offset, Object expected, Object x) {
        return this.weakCompareAndSetReference(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final boolean weakCompareAndSetObjectAcquire(Object o, long offset, Object expected, Object x) {
        return this.weakCompareAndSetReferenceAcquire(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final boolean weakCompareAndSetObjectPlain(Object o, long offset, Object expected, Object x) {
        return this.weakCompareAndSetReferencePlain(o, offset, expected, x);
    }

    @Deprecated(since="12", forRemoval=true)
    public final boolean weakCompareAndSetObjectRelease(Object o, long offset, Object expected, Object x) {
        return this.weakCompareAndSetReferenceRelease(o, offset, expected, x);
    }

    static {
        Unsafe.registerNatives();
        theUnsafe = new Unsafe();
        ARRAY_BOOLEAN_BASE_OFFSET = theUnsafe.arrayBaseOffset(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = theUnsafe.arrayBaseOffset(short[].class);
        ARRAY_CHAR_BASE_OFFSET = theUnsafe.arrayBaseOffset(char[].class);
        ARRAY_INT_BASE_OFFSET = theUnsafe.arrayBaseOffset(int[].class);
        ARRAY_LONG_BASE_OFFSET = theUnsafe.arrayBaseOffset(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = theUnsafe.arrayBaseOffset(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = theUnsafe.arrayBaseOffset(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = theUnsafe.arrayBaseOffset(Object[].class);
        ARRAY_BOOLEAN_INDEX_SCALE = theUnsafe.arrayIndexScale(boolean[].class);
        ARRAY_BYTE_INDEX_SCALE = theUnsafe.arrayIndexScale(byte[].class);
        ARRAY_SHORT_INDEX_SCALE = theUnsafe.arrayIndexScale(short[].class);
        ARRAY_CHAR_INDEX_SCALE = theUnsafe.arrayIndexScale(char[].class);
        ARRAY_INT_INDEX_SCALE = theUnsafe.arrayIndexScale(int[].class);
        ARRAY_LONG_INDEX_SCALE = theUnsafe.arrayIndexScale(long[].class);
        ARRAY_FLOAT_INDEX_SCALE = theUnsafe.arrayIndexScale(float[].class);
        ARRAY_DOUBLE_INDEX_SCALE = theUnsafe.arrayIndexScale(double[].class);
        ARRAY_OBJECT_INDEX_SCALE = theUnsafe.arrayIndexScale(Object[].class);
        ADDRESS_SIZE = UnsafeConstants.ADDRESS_SIZE0;
    }
}

