/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.util.function.Function;
import jdk.internal.misc.CDS;

class ArchivedModuleGraph {
    private static ArchivedModuleGraph archivedModuleGraph;
    private final boolean hasSplitPackages;
    private final boolean hasIncubatorModules;
    private final ModuleFinder finder;
    private final Configuration configuration;
    private final Function<String, ClassLoader> classLoaderFunction;

    private ArchivedModuleGraph(boolean hasSplitPackages, boolean hasIncubatorModules, ModuleFinder finder, Configuration configuration, Function<String, ClassLoader> classLoaderFunction) {
        this.hasSplitPackages = hasSplitPackages;
        this.hasIncubatorModules = hasIncubatorModules;
        this.finder = finder;
        this.configuration = configuration;
        this.classLoaderFunction = classLoaderFunction;
    }

    ModuleFinder finder() {
        return this.finder;
    }

    Configuration configuration() {
        return this.configuration;
    }

    Function<String, ClassLoader> classLoaderFunction() {
        return this.classLoaderFunction;
    }

    boolean hasSplitPackages() {
        return this.hasSplitPackages;
    }

    boolean hasIncubatorModules() {
        return this.hasIncubatorModules;
    }

    static ArchivedModuleGraph get(String mainModule) {
        ArchivedModuleGraph graph = archivedModuleGraph;
        if (mainModule == null) {
            return graph;
        }
        return null;
    }

    static void archive(boolean hasSplitPackages, boolean hasIncubatorModules, ModuleFinder finder, Configuration configuration, Function<String, ClassLoader> classLoaderFunction) {
        archivedModuleGraph = new ArchivedModuleGraph(hasSplitPackages, hasIncubatorModules, finder, configuration, classLoaderFunction);
    }

    static {
        CDS.initializeFromArchive(ArchivedModuleGraph.class);
    }
}

