/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.ModuleDescriptor;
import java.util.List;
import java.util.Set;
import jdk.internal.access.JavaLangModuleAccess;
import jdk.internal.access.SharedSecrets;

final class Builder {
    private static final JavaLangModuleAccess JLMA = SharedSecrets.getJavaLangModuleAccess();
    static ModuleDescriptor.Version cachedVersion;
    final String name;
    boolean open;
    boolean synthetic;
    boolean mandated;
    Set<ModuleDescriptor.Requires> requires;
    Set<ModuleDescriptor.Exports> exports;
    Set<ModuleDescriptor.Opens> opens;
    Set<String> packages;
    Set<String> uses;
    Set<ModuleDescriptor.Provides> provides;
    ModuleDescriptor.Version version;
    String mainClass;

    public static ModuleDescriptor.Requires newRequires(Set<ModuleDescriptor.Requires.Modifier> mods, String mn, String compiledVersion) {
        ModuleDescriptor.Version version = null;
        if (compiledVersion != null) {
            ModuleDescriptor.Version ver = cachedVersion;
            version = ver != null && compiledVersion.equals(ver.toString()) ? ver : ModuleDescriptor.Version.parse(compiledVersion);
        }
        return JLMA.newRequires(mods, mn, version);
    }

    public static ModuleDescriptor.Requires newRequires(Set<ModuleDescriptor.Requires.Modifier> mods, String mn) {
        return Builder.newRequires(mods, mn, null);
    }

    public static ModuleDescriptor.Exports newExports(Set<ModuleDescriptor.Exports.Modifier> ms, String pn, Set<String> targets) {
        return JLMA.newExports(ms, pn, targets);
    }

    public static ModuleDescriptor.Opens newOpens(Set<ModuleDescriptor.Opens.Modifier> ms, String pn) {
        return JLMA.newOpens(ms, pn);
    }

    public static ModuleDescriptor.Opens newOpens(Set<ModuleDescriptor.Opens.Modifier> ms, String pn, Set<String> targets) {
        return JLMA.newOpens(ms, pn, targets);
    }

    public static ModuleDescriptor.Exports newExports(Set<ModuleDescriptor.Exports.Modifier> ms, String pn) {
        return JLMA.newExports(ms, pn);
    }

    public static ModuleDescriptor.Provides newProvides(String st, List<String> pcs) {
        return JLMA.newProvides(st, pcs);
    }

    Builder(String name) {
        this.name = name;
        this.requires = Set.of();
        this.exports = Set.of();
        this.opens = Set.of();
        this.provides = Set.of();
        this.uses = Set.of();
    }

    Builder open(boolean value) {
        this.open = value;
        return this;
    }

    Builder synthetic(boolean value) {
        this.synthetic = value;
        return this;
    }

    Builder mandated(boolean value) {
        this.mandated = value;
        return this;
    }

    public Builder exports(ModuleDescriptor.Exports[] exports) {
        this.exports = Set.of(exports);
        return this;
    }

    public Builder opens(ModuleDescriptor.Opens[] opens) {
        this.opens = Set.of(opens);
        return this;
    }

    public Builder requires(ModuleDescriptor.Requires[] requires) {
        this.requires = Set.of(requires);
        return this;
    }

    public Builder packages(Set<String> packages) {
        this.packages = packages;
        return this;
    }

    public Builder uses(Set<String> uses) {
        this.uses = uses;
        return this;
    }

    public Builder provides(ModuleDescriptor.Provides[] provides) {
        this.provides = Set.of(provides);
        return this;
    }

    public Builder version(String v) {
        ModuleDescriptor.Version ver = cachedVersion;
        if (ver != null && v.equals(ver.toString())) {
            this.version = ver;
        } else {
            cachedVersion = this.version = ModuleDescriptor.Version.parse(v);
        }
        return this;
    }

    public Builder mainClass(String mc) {
        this.mainClass = mc;
        return this;
    }

    private Set<ModuleDescriptor.Modifier> modifiers() {
        int n = 0;
        if (this.open) {
            ++n;
        }
        if (this.synthetic) {
            ++n;
        }
        if (this.mandated) {
            ++n;
        }
        if (n == 0) {
            return Set.of();
        }
        ModuleDescriptor.Modifier[] mods = new ModuleDescriptor.Modifier[n];
        if (this.open) {
            mods[--n] = ModuleDescriptor.Modifier.OPEN;
        }
        if (this.synthetic) {
            mods[--n] = ModuleDescriptor.Modifier.SYNTHETIC;
        }
        if (this.mandated) {
            mods[--n] = ModuleDescriptor.Modifier.MANDATED;
        }
        return Set.of(mods);
    }

    public ModuleDescriptor build(int hashCode) {
        assert (this.name != null);
        return JLMA.newModuleDescriptor(this.name, this.version, this.modifiers(), this.requires, this.exports, this.opens, this.uses, this.provides, this.packages, this.mainClass, hashCode);
    }
}

