/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.internal.module.ModuleResolution;

public final class DefaultRoots {
    private DefaultRoots() {
    }

    static Set<String> compute(ModuleFinder finder1, ModuleFinder finder2) {
        return finder1.findAll().stream().filter(mref -> !ModuleResolution.doNotResolveByDefault(mref)).map(ModuleReference::descriptor).filter(descriptor -> finder2.find(descriptor.name()).isPresent() && DefaultRoots.exportsAPI(descriptor)).map(ModuleDescriptor::name).collect(Collectors.toSet());
    }

    public static Set<String> compute(ModuleFinder finder) {
        return DefaultRoots.compute(finder, finder);
    }

    private static boolean exportsAPI(ModuleDescriptor descriptor) {
        return descriptor.exports().stream().filter(e -> !e.isQualified()).findAny().isPresent();
    }
}

