/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.File;
import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.JavaLangModuleAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.misc.CDS;
import jdk.internal.module.ArchivedBootLayer;
import jdk.internal.module.ArchivedModuleGraph;
import jdk.internal.module.DefaultRoots;
import jdk.internal.module.ExplodedSystemModules;
import jdk.internal.module.ModuleLoaderMap;
import jdk.internal.module.ModulePatcher;
import jdk.internal.module.ModulePath;
import jdk.internal.module.ModulePathValidator;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.Modules;
import jdk.internal.module.SystemModuleFinders;
import jdk.internal.module.SystemModules;
import jdk.internal.perf.PerfCounter;

public final class ModuleBootstrap {
    private static final String JAVA_BASE = "java.base";
    private static final String ALL_DEFAULT = "ALL-DEFAULT";
    private static final String ALL_UNNAMED = "ALL-UNNAMED";
    private static final String ALL_SYSTEM = "ALL-SYSTEM";
    private static final String ALL_MODULE_PATH = "ALL-MODULE-PATH";
    private static final JavaLangAccess JLA = SharedSecrets.getJavaLangAccess();
    private static final JavaLangModuleAccess JLMA = SharedSecrets.getJavaLangModuleAccess();
    private static final ModulePatcher patcher = ModuleBootstrap.initModulePatcher();
    private static volatile ModuleFinder unlimitedFinder;
    private static volatile ModuleFinder limitedFinder;
    private static final String ADD_MODULES = "--add-modules";
    private static final String ADD_EXPORTS = "--add-exports";
    private static final String ADD_OPENS = "--add-opens";
    private static final String ADD_READS = "--add-reads";
    private static final String PATCH_MODULE = "--patch-module";
    private static final String ENABLE_NATIVE_ACCESS = "--enable-native-access";

    private ModuleBootstrap() {
    }

    public static ModulePatcher patcher() {
        return patcher;
    }

    public static ModuleFinder unlimitedFinder() {
        ModuleFinder finder = unlimitedFinder;
        if (finder == null) {
            return ModuleFinder.ofSystem();
        }
        return finder;
    }

    public static ModuleFinder limitedFinder() {
        ModuleFinder finder = limitedFinder;
        if (finder == null) {
            return ModuleBootstrap.unlimitedFinder();
        }
        return finder;
    }

    private static boolean canUseArchivedBootLayer() {
        return ModuleBootstrap.getProperty("jdk.module.upgrade.path") == null && ModuleBootstrap.getProperty("jdk.module.path") == null && ModuleBootstrap.getProperty("jdk.module.patch.0") == null && ModuleBootstrap.getProperty("jdk.module.main") == null && ModuleBootstrap.getProperty("jdk.module.addmods.0") == null && ModuleBootstrap.getProperty("jdk.module.limitmods") == null && ModuleBootstrap.getProperty("jdk.module.addreads.0") == null && ModuleBootstrap.getProperty("jdk.module.addexports.0") == null && ModuleBootstrap.getProperty("jdk.module.addopens.0") == null;
    }

    public static ModuleLayer boot() {
        ModuleLayer bootLayer;
        Counters.start();
        ArchivedBootLayer archivedBootLayer = ArchivedBootLayer.get();
        if (archivedBootLayer != null) {
            assert (ModuleBootstrap.canUseArchivedBootLayer());
            bootLayer = archivedBootLayer.bootLayer();
            BootLoader.getUnnamedModule();
            CDS.defineArchivedModules(ClassLoaders.platformClassLoader(), ClassLoaders.appClassLoader());
            JLA.bindToLoader(bootLayer, ClassLoaders.appClassLoader());
        } else {
            bootLayer = ModuleBootstrap.boot2();
        }
        Counters.publish("jdk.module.boot.totalTime");
        return bootLayer;
    }

    private static ModuleLayer boot2() {
        Configuration cf;
        HashSet<String> roots;
        ModuleFinder finder;
        int errors;
        boolean hasIncubatorModules;
        boolean hasSplitPackages;
        ModuleFinder systemModuleFinder;
        ModuleFinder upgradeModulePath = ModuleBootstrap.finderFor("jdk.module.upgrade.path");
        ModuleFinder appModulePath = ModuleBootstrap.finderFor("jdk.module.path");
        boolean isPatched = patcher.hasPatches();
        String mainModule = System.getProperty("jdk.module.main");
        Set<String> addModules = ModuleBootstrap.addModules();
        Set<String> limitModules = ModuleBootstrap.limitModules();
        PrintStream traceOutput = null;
        String trace = ModuleBootstrap.getAndRemoveProperty("jdk.module.showModuleResolution");
        if (trace != null && Boolean.parseBoolean(trace)) {
            traceOutput = System.out;
        }
        Counters.add("jdk.module.boot.0.commandLineTime");
        SystemModules systemModules = null;
        boolean haveModulePath = appModulePath != null || upgradeModulePath != null;
        boolean needResolution = true;
        boolean canArchive = false;
        ArchivedModuleGraph archivedModuleGraph = ArchivedModuleGraph.get(mainModule);
        if (archivedModuleGraph != null && !haveModulePath && addModules.isEmpty() && limitModules.isEmpty() && !isPatched) {
            systemModuleFinder = archivedModuleGraph.finder();
            hasSplitPackages = archivedModuleGraph.hasSplitPackages();
            hasIncubatorModules = archivedModuleGraph.hasIncubatorModules();
            needResolution = traceOutput != null;
        } else {
            if (!haveModulePath && addModules.isEmpty() && limitModules.isEmpty() && (systemModules = SystemModuleFinders.systemModules(mainModule)) != null && !isPatched) {
                needResolution = traceOutput != null;
                canArchive = true;
            }
            if (systemModules == null) {
                systemModules = SystemModuleFinders.allSystemModules();
            }
            if (systemModules != null) {
                systemModuleFinder = SystemModuleFinders.of(systemModules);
            } else {
                systemModules = new ExplodedSystemModules();
                systemModuleFinder = SystemModuleFinders.ofSystem();
            }
            hasSplitPackages = systemModules.hasSplitPackages();
            hasIncubatorModules = systemModules.hasIncubatorModules();
            archivedModuleGraph = null;
        }
        Counters.add("jdk.module.boot.1.systemModulesTime");
        ModuleReference base = systemModuleFinder.find(JAVA_BASE).orElse(null);
        if (base == null) {
            throw new InternalError("java.base not found");
        }
        URI baseUri = base.location().orElse(null);
        if (baseUri == null) {
            throw new InternalError("java.base does not have a location");
        }
        BootLoader.loadModule(base);
        Module baseModule = Modules.defineModule(null, base.descriptor(), baseUri);
        JLA.addEnableNativeAccess(baseModule);
        if (ModuleBootstrap.getAndRemoveProperty("jdk.module.validation") != null && (errors = ModulePathValidator.scanAllModules(System.out)) > 0) {
            ModuleBootstrap.fail("Validation of module path failed");
        }
        Counters.add("jdk.module.boot.2.defineBaseTime");
        ModuleFinder savedModuleFinder = null;
        if (needResolution) {
            ModuleFinder f;
            if (upgradeModulePath != null) {
                systemModuleFinder = ModuleFinder.compose(upgradeModulePath, systemModuleFinder);
            }
            finder = appModulePath != null ? ModuleFinder.compose(systemModuleFinder, appModulePath) : systemModuleFinder;
            roots = new HashSet<String>();
            if (mainModule != null) {
                roots.add(mainModule);
            }
            boolean addAllDefaultModules = false;
            boolean addAllSystemModules = false;
            boolean addAllApplicationModules = false;
            Iterator<String> iterator = addModules.iterator();
            block10: while (iterator.hasNext()) {
                String mod;
                switch (mod = iterator.next()) {
                    case "ALL-DEFAULT": {
                        addAllDefaultModules = true;
                        continue block10;
                    }
                    case "ALL-SYSTEM": {
                        addAllSystemModules = true;
                        continue block10;
                    }
                    case "ALL-MODULE-PATH": {
                        addAllApplicationModules = true;
                        continue block10;
                    }
                }
                roots.add(mod);
            }
            savedModuleFinder = finder;
            if (!limitModules.isEmpty()) {
                finder = ModuleBootstrap.limitFinder(finder, limitModules, roots);
            }
            if (mainModule == null || addAllDefaultModules) {
                roots.addAll(DefaultRoots.compute(systemModuleFinder, finder));
            }
            if (addAllSystemModules) {
                f = finder;
                systemModuleFinder.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).filter(mn -> f.find((String)mn).isPresent()).forEach(mn -> roots.add((String)mn));
            }
            if (appModulePath != null && addAllApplicationModules) {
                f = finder;
                appModulePath.findAll().stream().map(ModuleReference::descriptor).map(ModuleDescriptor::name).filter(mn -> f.find((String)mn).isPresent()).forEach(mn -> roots.add((String)mn));
            }
        } else {
            finder = systemModuleFinder;
            roots = null;
        }
        Counters.add("jdk.module.boot.3.optionsAndRootsTime");
        if (needResolution) {
            cf = Modules.newBootLayerConfiguration(finder, roots, traceOutput);
        } else if (archivedModuleGraph != null) {
            cf = archivedModuleGraph.configuration();
        } else {
            Map<String, Set<String>> map = systemModules.moduleReads();
            cf = JLMA.newConfiguration(systemModuleFinder, map);
        }
        if (isPatched) {
            patcher.patchedModules().stream().filter(mn -> !cf.findModule((String)mn).isPresent()).forEach(mn -> ModuleBootstrap.warnUnknownModule(PATCH_MODULE, mn));
        }
        Counters.add("jdk.module.boot.4.resolveTime");
        Function<String, ClassLoader> clf = archivedModuleGraph != null ? archivedModuleGraph.classLoaderFunction() : ModuleLoaderMap.mappingFunction(cf);
        if (haveModulePath) {
            for (ResolvedModule resolvedModule : cf.modules()) {
                ModuleReference mref = resolvedModule.reference();
                String name = mref.descriptor().name();
                ClassLoader cl = clf.apply(name);
                if (cl != null) continue;
                if (upgradeModulePath != null && upgradeModulePath.find(name).isPresent()) {
                    ModuleBootstrap.fail(name + ": cannot be loaded from upgrade module path");
                }
                if (systemModuleFinder.find(name).isPresent()) continue;
                ModuleBootstrap.fail(name + ": cannot be loaded from application module path");
            }
        }
        if (hasSplitPackages || isPatched || haveModulePath) {
            ModuleBootstrap.checkSplitPackages(cf, clf);
        }
        ModuleBootstrap.loadModules(cf, clf);
        Counters.add("jdk.module.boot.5.loadModulesTime");
        ModuleLayer bootLayer = ModuleLayer.empty().defineModules(cf, clf);
        Counters.add("jdk.module.boot.6.layerCreateTime");
        if (hasIncubatorModules || haveModulePath) {
            ModuleBootstrap.checkIncubatingStatus(cf);
        }
        ModuleBootstrap.addExtraReads(bootLayer);
        boolean extraExportsOrOpens = ModuleBootstrap.addExtraExportsAndOpens(bootLayer);
        ModuleBootstrap.addEnableNativeAccess(bootLayer);
        Counters.add("jdk.module.boot.7.adjustModulesTime");
        if (savedModuleFinder != null) {
            unlimitedFinder = new SafeModuleFinder(savedModuleFinder);
            if (savedModuleFinder != finder) {
                limitedFinder = new SafeModuleFinder(finder);
            }
        }
        if (canArchive && mainModule == null) {
            ArchivedModuleGraph.archive(hasSplitPackages, hasIncubatorModules, systemModuleFinder, cf, clf);
            if (!hasSplitPackages && !hasIncubatorModules) {
                ArchivedBootLayer.archive(bootLayer);
            }
        }
        return bootLayer;
    }

    private static void loadModules(Configuration cf, Function<String, ClassLoader> clf) {
        for (ResolvedModule resolvedModule : cf.modules()) {
            ModuleReference mref = resolvedModule.reference();
            String name = resolvedModule.name();
            ClassLoader loader = clf.apply(name);
            if (loader == null) {
                if (name.equals(JAVA_BASE)) continue;
                BootLoader.loadModule(mref);
                continue;
            }
            if (!(loader instanceof BuiltinClassLoader)) continue;
            ((BuiltinClassLoader)loader).loadModule(mref);
        }
    }

    private static void checkSplitPackages(Configuration cf, Function<String, ClassLoader> clf) {
        HashMap<String, String> packageToModule = new HashMap<String, String>();
        for (ResolvedModule resolvedModule : cf.modules()) {
            ModuleDescriptor descriptor = resolvedModule.reference().descriptor();
            String name = descriptor.name();
            ClassLoader loader = clf.apply(name);
            if (loader != null && !(loader instanceof BuiltinClassLoader)) continue;
            for (String p : descriptor.packages()) {
                String other = packageToModule.putIfAbsent(p, name);
                if (other == null) continue;
                String msg = "Package " + p + " in both module " + name + " and module " + other;
                throw new LayerInstantiationException(msg);
            }
        }
    }

    private static ModuleFinder limitFinder(ModuleFinder finder, Set<String> roots, Set<String> otherMods) {
        Configuration cf = Configuration.empty().resolve(finder, ModuleFinder.of(new Path[0]), roots);
        final HashMap map = new HashMap();
        cf.modules().stream().map(ResolvedModule::reference).forEach(mref -> map.put(mref.descriptor().name(), mref));
        otherMods.stream().map(finder::find).flatMap(Optional::stream).forEach(mref -> map.putIfAbsent(mref.descriptor().name(), mref));
        final HashSet mrefs = new HashSet(map.values());
        return new ModuleFinder(){

            @Override
            public Optional<ModuleReference> find(String name) {
                return Optional.ofNullable((ModuleReference)map.get(name));
            }

            @Override
            public Set<ModuleReference> findAll() {
                return mrefs;
            }
        };
    }

    private static ModuleFinder finderFor(String prop) {
        String s = System.getProperty(prop);
        if (s == null) {
            return null;
        }
        String[] dirs = s.split(File.pathSeparator);
        Path[] paths = new Path[dirs.length];
        int i = 0;
        for (String dir : dirs) {
            paths[i++] = Path.of(dir, new String[0]);
        }
        return ModulePath.of(patcher, paths);
    }

    private static ModulePatcher initModulePatcher() {
        Map<String, List<String>> map = ModuleBootstrap.decode("jdk.module.patch.", File.pathSeparator, false);
        return new ModulePatcher(map);
    }

    private static Set<String> addModules() {
        String prefix = "jdk.module.addmods.";
        int index = 0;
        String value = ModuleBootstrap.getAndRemoveProperty(prefix + index);
        if (value == null) {
            return Set.of();
        }
        HashSet<String> modules = new HashSet<String>();
        while (value != null) {
            for (String s : value.split(",")) {
                if (s.isEmpty()) continue;
                modules.add(s);
            }
            value = ModuleBootstrap.getAndRemoveProperty(prefix + ++index);
        }
        return modules;
    }

    private static Set<String> limitModules() {
        String value = ModuleBootstrap.getAndRemoveProperty("jdk.module.limitmods");
        if (value == null) {
            return Set.of();
        }
        HashSet<String> names = new HashSet<String>();
        for (String name : value.split(",")) {
            if (name.length() <= 0) continue;
            names.add(name);
        }
        return names;
    }

    private static void addExtraReads(ModuleLayer bootLayer) {
        Map<String, List<String>> map = ModuleBootstrap.decode("jdk.module.addreads.");
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String mn = e.getKey();
            Optional<Module> om = bootLayer.findModule(mn);
            if (!om.isPresent()) {
                ModuleBootstrap.warnUnknownModule(ADD_READS, mn);
                continue;
            }
            Module m = om.get();
            for (String name : e.getValue()) {
                if (ALL_UNNAMED.equals(name)) {
                    Modules.addReadsAllUnnamed(m);
                    continue;
                }
                om = bootLayer.findModule(name);
                if (om.isPresent()) {
                    Modules.addReads(m, om.get());
                    continue;
                }
                ModuleBootstrap.warnUnknownModule(ADD_READS, name);
            }
        }
    }

    private static boolean addExtraExportsAndOpens(ModuleLayer bootLayer) {
        Map<String, List<String>> extraOpens;
        boolean extraExportsOrOpens = false;
        String prefix = "jdk.module.addexports.";
        Map<String, List<String>> extraExports = ModuleBootstrap.decode(prefix);
        if (!extraExports.isEmpty()) {
            ModuleBootstrap.addExtraExportsOrOpens(bootLayer, extraExports, false);
            extraExportsOrOpens = true;
        }
        if (!(extraOpens = ModuleBootstrap.decode(prefix = "jdk.module.addopens.")).isEmpty()) {
            ModuleBootstrap.addExtraExportsOrOpens(bootLayer, extraOpens, true);
            extraExportsOrOpens = true;
        }
        return extraExportsOrOpens;
    }

    private static void addExtraExportsOrOpens(ModuleLayer bootLayer, Map<String, List<String>> map, boolean opens) {
        String option = opens ? ADD_OPENS : ADD_EXPORTS;
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            Optional<Module> om;
            String key = e.getKey();
            String[] s = key.split("/");
            if (s.length != 2) {
                ModuleBootstrap.fail(ModuleBootstrap.unableToParse(option, "<module>/<package>", key));
            }
            String mn = s[0];
            String pn = s[1];
            if (mn.isEmpty() || pn.isEmpty()) {
                ModuleBootstrap.fail(ModuleBootstrap.unableToParse(option, "<module>/<package>", key));
            }
            if (!(om = bootLayer.findModule(mn)).isPresent()) {
                ModuleBootstrap.warnUnknownModule(option, mn);
                continue;
            }
            Module m = om.get();
            if (!m.getDescriptor().packages().contains(pn)) {
                ModuleBootstrap.warn("package " + pn + " not in " + mn);
                continue;
            }
            for (String name : e.getValue()) {
                boolean allUnnamed = false;
                Module other = null;
                if (ALL_UNNAMED.equals(name)) {
                    allUnnamed = true;
                } else {
                    om = bootLayer.findModule(name);
                    if (om.isPresent()) {
                        other = om.get();
                    } else {
                        ModuleBootstrap.warnUnknownModule(option, name);
                        continue;
                    }
                }
                if (allUnnamed) {
                    if (opens) {
                        Modules.addOpensToAllUnnamed(m, pn);
                        continue;
                    }
                    Modules.addExportsToAllUnnamed(m, pn);
                    continue;
                }
                if (opens) {
                    Modules.addOpens(m, pn, other);
                    continue;
                }
                Modules.addExports(m, pn, other);
            }
        }
    }

    private static void addEnableNativeAccess(ModuleLayer layer) {
        for (String name : ModuleBootstrap.decodeEnableNativeAccess()) {
            if (name.equals(ALL_UNNAMED)) {
                JLA.addEnableNativeAccessAllUnnamed();
                continue;
            }
            Optional<Module> module = layer.findModule(name);
            if (module.isPresent()) {
                JLA.addEnableNativeAccess(module.get());
                continue;
            }
            ModuleBootstrap.warnUnknownModule(ENABLE_NATIVE_ACCESS, name);
        }
    }

    private static Set<String> decodeEnableNativeAccess() {
        String prefix = "jdk.module.enable.native.access.";
        int index = 0;
        String value = ModuleBootstrap.getAndRemoveProperty(prefix + index);
        HashSet<String> modules = new HashSet<String>();
        if (value == null) {
            return modules;
        }
        while (value != null) {
            for (String s : value.split(",")) {
                if (s.isEmpty()) continue;
                modules.add(s);
            }
            value = ModuleBootstrap.getAndRemoveProperty(prefix + ++index);
        }
        return modules;
    }

    private static Map<String, List<String>> decode(String prefix, String regex, boolean allowDuplicates) {
        int index = 0;
        String value = ModuleBootstrap.getAndRemoveProperty(prefix + index);
        if (value == null) {
            return Map.of();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        while (value != null) {
            int pos = value.indexOf(61);
            if (pos == -1) {
                ModuleBootstrap.fail(ModuleBootstrap.unableToParse(ModuleBootstrap.option(prefix), "<module>=<value>", value));
            }
            if (pos == 0) {
                ModuleBootstrap.fail(ModuleBootstrap.unableToParse(ModuleBootstrap.option(prefix), "<module>=<value>", value));
            }
            String key = value.substring(0, pos);
            String rhs = value.substring(pos + 1);
            if (rhs.isEmpty()) {
                ModuleBootstrap.fail(ModuleBootstrap.unableToParse(ModuleBootstrap.option(prefix), "<module>=<value>", value));
            }
            if (!allowDuplicates && map.containsKey(key)) {
                ModuleBootstrap.fail(key + " specified more than once to " + ModuleBootstrap.option(prefix));
            }
            List values = map.computeIfAbsent(key, k -> new ArrayList());
            int ntargets = 0;
            for (String s : rhs.split(regex)) {
                if (s.isEmpty()) continue;
                values.add(s);
                ++ntargets;
            }
            if (ntargets == 0) {
                ModuleBootstrap.fail("Target must be specified: " + ModuleBootstrap.option(prefix) + " " + value);
            }
            value = ModuleBootstrap.getAndRemoveProperty(prefix + ++index);
        }
        return map;
    }

    private static Map<String, List<String>> decode(String prefix) {
        return ModuleBootstrap.decode(prefix, ",", true);
    }

    private static String getProperty(String key) {
        return System.getProperty(key);
    }

    private static String getAndRemoveProperty(String key) {
        return (String)System.getProperties().remove(key);
    }

    private static void checkIncubatingStatus(Configuration cf) {
        String incubating = null;
        for (ResolvedModule resolvedModule : cf.modules()) {
            ModuleReference mref = resolvedModule.reference();
            if (!ModuleResolution.hasIncubatingWarning(mref)) continue;
            String mn = mref.descriptor().name();
            if (incubating == null) {
                incubating = mn;
                continue;
            }
            incubating = incubating + ", " + mn;
        }
        if (incubating != null) {
            ModuleBootstrap.warn("Using incubator modules: " + incubating);
        }
    }

    static void fail(String m) {
        throw new RuntimeException(m);
    }

    static void warn(String m) {
        System.err.println("WARNING: " + m);
    }

    static void warnUnknownModule(String option, String mn) {
        ModuleBootstrap.warn("Unknown module: " + mn + " specified to " + option);
    }

    static String unableToParse(String option, String text, String value) {
        return "Unable to parse " + option + " " + text + ": " + value;
    }

    static String option(String prefix) {
        switch (prefix) {
            case "jdk.module.addexports.": {
                return ADD_EXPORTS;
            }
            case "jdk.module.addopens.": {
                return ADD_OPENS;
            }
            case "jdk.module.addreads.": {
                return ADD_READS;
            }
            case "jdk.module.patch.": {
                return PATCH_MODULE;
            }
            case "jdk.module.addmods.": {
                return ADD_MODULES;
            }
        }
        throw new IllegalArgumentException(prefix);
    }

    static class Counters {
        private static final boolean PUBLISH_COUNTERS;
        private static final boolean PRINT_COUNTERS;
        private static Map<String, Long> counters;
        private static long startTime;
        private static long previousTime;

        Counters() {
        }

        static void start() {
            if (PUBLISH_COUNTERS) {
                startTime = previousTime = System.nanoTime();
            }
        }

        static void add(String name) {
            if (PUBLISH_COUNTERS) {
                long current = System.nanoTime();
                long elapsed = current - previousTime;
                previousTime = current;
                counters.put(name, elapsed);
            }
        }

        static void publish(String totalTimeName) {
            if (PUBLISH_COUNTERS) {
                long currentTime = System.nanoTime();
                for (Map.Entry<String, Long> e : counters.entrySet()) {
                    String name = e.getKey();
                    long value = e.getValue();
                    PerfCounter.newPerfCounter(name).set(value);
                    if (!PRINT_COUNTERS) continue;
                    System.out.println(name + " = " + value);
                }
                long elapsedTotal = currentTime - startTime;
                PerfCounter.newPerfCounter(totalTimeName).set(elapsedTotal);
                if (PRINT_COUNTERS) {
                    System.out.println(totalTimeName + " = " + elapsedTotal);
                }
            }
        }

        static {
            String s = System.getProperty("jdk.module.boot.usePerfData");
            if (s == null) {
                PUBLISH_COUNTERS = false;
                PRINT_COUNTERS = false;
            } else {
                PUBLISH_COUNTERS = true;
                PRINT_COUNTERS = s.equals("debug");
                counters = new LinkedHashMap<String, Long>();
            }
        }
    }

    static class SafeModuleFinder
    implements ModuleFinder {
        private final Set<ModuleReference> mrefs;
        private volatile Map<String, ModuleReference> nameToModule;

        SafeModuleFinder(ModuleFinder finder) {
            this.mrefs = Collections.unmodifiableSet(finder.findAll());
        }

        @Override
        public Optional<ModuleReference> find(String name) {
            Objects.requireNonNull(name);
            Map<String, ModuleReference> nameToModule = this.nameToModule;
            if (nameToModule == null) {
                this.nameToModule = nameToModule = this.mrefs.stream().collect(Collectors.toMap(m -> m.descriptor().name(), Function.identity()));
            }
            return Optional.ofNullable(nameToModule.get(name));
        }

        @Override
        public Set<ModuleReference> findAll() {
            return this.mrefs;
        }
    }
}

