/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;

public final class ModuleHashes {
    private final String algorithm;
    private final Map<String, byte[]> nameToHash;

    ModuleHashes(String algorithm, Map<String, byte[]> nameToHash) {
        this.algorithm = Objects.requireNonNull(algorithm);
        this.nameToHash = Collections.unmodifiableMap(nameToHash);
    }

    public String algorithm() {
        return this.algorithm;
    }

    public Set<String> names() {
        return this.nameToHash.keySet();
    }

    public byte[] hashFor(String mn) {
        return this.nameToHash.get(mn);
    }

    public Map<String, byte[]> hashes() {
        return this.nameToHash;
    }

    private static byte[] computeHash(ModuleReader reader, String algorithm) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            byte[] buf = new byte[32768];
            reader.list().sorted().forEach(rn -> {
                md.update(rn.getBytes(StandardCharsets.UTF_8));
                try (InputStream in = reader.open((String)rn).orElseThrow();){
                    int n;
                    while ((n = in.read(buf)) > 0) {
                        md.update(buf, 0, n);
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            });
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        return md.digest();
    }

    static byte[] computeHash(Supplier<ModuleReader> supplier, String algorithm) {
        byte[] byArray;
        block8: {
            ModuleReader reader = supplier.get();
            try {
                byArray = ModuleHashes.computeHash(reader, algorithm);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            reader.close();
        }
        return byArray;
    }

    static ModuleHashes generate(Set<ModuleReference> mrefs, String algorithm) {
        TreeMap<String, byte[]> nameToHash = new TreeMap<String, byte[]>();
        for (ModuleReference mref : mrefs) {
            try {
                ModuleReader reader = mref.open();
                try {
                    byte[] hash = ModuleHashes.computeHash(reader, algorithm);
                    nameToHash.put(mref.descriptor().name(), hash);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
        return new ModuleHashes(algorithm, nameToHash);
    }

    public int hashCode() {
        int h = this.algorithm.hashCode();
        for (Map.Entry<String, byte[]> e : this.nameToHash.entrySet()) {
            h = h * 31 + e.getKey().hashCode();
            h = h * 31 + Arrays.hashCode(e.getValue());
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleHashes)) {
            return false;
        }
        ModuleHashes other = (ModuleHashes)obj;
        if (!this.algorithm.equals(other.algorithm) || this.nameToHash.size() != other.nameToHash.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> e : this.nameToHash.entrySet()) {
            String name = e.getKey();
            byte[] hash = e.getValue();
            if (Arrays.equals(hash, other.nameToHash.get(name))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.algorithm);
        sb.append(" ");
        this.nameToHash.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            byte[] ba;
            sb.append((String)e.getKey());
            sb.append("=");
            for (byte b : ba = (byte[])e.getValue()) {
                sb.append(String.format("%02x", b & 0xFF));
            }
        });
        return sb.toString();
    }

    public static class Builder {
        final String algorithm;
        final Map<String, byte[]> nameToHash;

        Builder(String algorithm, int initialCapacity) {
            this.nameToHash = new HashMap<String, byte[]>(initialCapacity);
            this.algorithm = Objects.requireNonNull(algorithm);
        }

        public Builder hashForModule(String mn, byte[] hash) {
            this.nameToHash.put(mn, hash);
            return this;
        }

        public ModuleHashes build() {
            if (!this.nameToHash.isEmpty()) {
                return new ModuleHashes(this.algorithm, this.nameToHash);
            }
            return null;
        }
    }

    public static interface HashSupplier {
        public byte[] generate(String var1);
    }
}

