/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.PrintStream;
import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.module.ModuleHashes;

public class ModuleHashesBuilder {
    private final Configuration configuration;
    private final Set<String> hashModuleCandidates;

    public ModuleHashesBuilder(Configuration config, Set<String> modules) {
        this.configuration = config;
        this.hashModuleCandidates = modules;
    }

    public Map<String, ModuleHashes> computeHashes(Set<String> roots) {
        ResolvedModule rm;
        Graph.Builder<String> builder = new Graph.Builder<String>();
        ArrayDeque<ResolvedModule> todo = new ArrayDeque<ResolvedModule>(this.configuration.modules());
        HashSet<ResolvedModule> visited = new HashSet<ResolvedModule>();
        while ((rm = (ResolvedModule)todo.poll()) != null) {
            if (!visited.add(rm)) continue;
            builder.addNode(rm.name());
            for (ResolvedModule dm : rm.reads()) {
                if (!visited.contains(dm)) {
                    todo.push(dm);
                }
                builder.addEdge(rm.name(), dm.name());
            }
        }
        Graph transposedGraph = builder.build().transpose();
        HashSet mods = new HashSet();
        TreeMap<String, ModuleHashes> hashes = new TreeMap<String, ModuleHashes>();
        builder.build().orderedNodes().filter(mn -> roots.contains(mn) && !mods.contains(mn)).forEach(mn -> {
            Set ns = transposedGraph.dfs(mn).stream().filter(n -> !n.equals(mn) && this.hashModuleCandidates.contains(n)).collect(Collectors.toSet());
            mods.add(mn);
            mods.addAll(ns);
            if (!ns.isEmpty()) {
                Set<ModuleReference> mrefs = ns.stream().map(name -> this.configuration.findModule((String)name).orElseThrow(InternalError::new)).map(ResolvedModule::reference).collect(Collectors.toSet());
                hashes.put((String)mn, ModuleHashes.generate(mrefs, "SHA-256"));
            }
        });
        return hashes;
    }

    static class Graph<T> {
        private final Set<T> nodes;
        private final Map<T, Set<T>> edges;

        public Graph(Set<T> nodes, Map<T, Set<T>> edges) {
            this.nodes = Collections.unmodifiableSet(nodes);
            this.edges = Collections.unmodifiableMap(edges);
        }

        public Set<T> nodes() {
            return this.nodes;
        }

        public Map<T, Set<T>> edges() {
            return this.edges;
        }

        public Set<T> adjacentNodes(T u) {
            return this.edges.get(u);
        }

        public boolean contains(T u) {
            return this.nodes.contains(u);
        }

        public Stream<T> orderedNodes() {
            TopoSorter sorter = new TopoSorter(this);
            return sorter.result.stream();
        }

        public void ordered(Consumer<T> action) {
            TopoSorter<T> sorter = new TopoSorter<T>(this);
            sorter.ordered(action);
        }

        public void reverse(Consumer<T> action) {
            TopoSorter<T> sorter = new TopoSorter<T>(this);
            sorter.reverse(action);
        }

        public Graph<T> transpose() {
            Builder builder = new Builder();
            this.nodes.forEach(builder::addNode);
            this.edges.keySet().forEach(u -> this.edges.get(u).forEach(v -> builder.addEdge(v, u)));
            return builder.build();
        }

        public Set<T> dfs(T root) {
            return this.dfs(Set.of(root));
        }

        public Set<T> dfs(Set<T> roots) {
            T u;
            ArrayDeque<T> todo = new ArrayDeque<T>(roots);
            HashSet visited = new HashSet();
            while ((u = todo.poll()) != null) {
                if (!visited.add(u) || !this.contains(u)) continue;
                this.adjacentNodes(u).stream().filter(v -> !visited.contains(v)).forEach(todo::push);
            }
            return visited;
        }

        public void printGraph(PrintStream out) {
            out.println("graph for " + this.nodes);
            this.nodes.forEach(u -> this.adjacentNodes(u).forEach(v -> out.format("  %s -> %s%n", u, v)));
        }

        static class Builder<T> {
            final Set<T> nodes = new HashSet<T>();
            final Map<T, Set<T>> edges = new HashMap<T, Set<T>>();

            Builder() {
            }

            public void addNode(T node) {
                if (this.nodes.add(node)) {
                    this.edges.computeIfAbsent(node, _e -> new HashSet());
                }
            }

            public void addEdge(T u, T v) {
                this.addNode(u);
                this.addNode(v);
                this.edges.get(u).add(v);
            }

            public Graph<T> build() {
                return new Graph<T>(this.nodes, this.edges);
            }
        }
    }

    private static class TopoSorter<T> {
        final Deque<T> result = new ArrayDeque<T>();
        final Graph<T> graph;

        TopoSorter(Graph<T> graph) {
            this.graph = graph;
            this.sort();
        }

        public void ordered(Consumer<T> action) {
            this.result.forEach(action);
        }

        public void reverse(Consumer<T> action) {
            this.result.descendingIterator().forEachRemaining(action);
        }

        private void sort() {
            HashSet visited = new HashSet();
            ArrayDeque stack = new ArrayDeque();
            this.graph.nodes.forEach(node -> this.visit(node, visited, stack));
        }

        private Set<T> children(T node) {
            return this.graph.edges().get(node);
        }

        private void visit(T node, Set<T> visited, Deque<T> stack) {
            if (visited.add(node)) {
                stack.push(node);
                this.children(node).forEach(child -> this.visit(child, visited, stack));
                stack.pop();
                this.result.addLast(node);
            } else if (stack.contains(node)) {
                throw new IllegalArgumentException("Cycle detected: " + node + " -> " + this.children(node));
            }
        }
    }
}

