/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import jdk.internal.access.JavaLangModuleAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;

public final class ModuleInfo {
    private static final JavaLangModuleAccess JLMA = SharedSecrets.getJavaLangModuleAccess();
    private final Supplier<Set<String>> packageFinder;
    private final boolean parseHashes;
    private static volatile Set<String> predefinedNotAllowed;

    private ModuleInfo(Supplier<Set<String>> pf, boolean ph) {
        this.packageFinder = pf;
        this.parseHashes = ph;
    }

    private ModuleInfo(Supplier<Set<String>> pf) {
        this(pf, true);
    }

    public static Attributes read(InputStream in, Supplier<Set<String>> pf) throws IOException {
        try {
            return new ModuleInfo(pf).doRead(new DataInputStream(in));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw ModuleInfo.invalidModuleDescriptor(e.getMessage());
        }
        catch (EOFException x) {
            throw ModuleInfo.truncatedModuleDescriptor();
        }
    }

    public static Attributes read(ByteBuffer bb, Supplier<Set<String>> pf) {
        try {
            return new ModuleInfo(pf).doRead(new DataInputWrapper(bb));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw ModuleInfo.invalidModuleDescriptor(e.getMessage());
        }
        catch (EOFException x) {
            throw ModuleInfo.truncatedModuleDescriptor();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static Attributes readIgnoringHashes(ByteBuffer bb, Supplier<Set<String>> pf) {
        try {
            return new ModuleInfo(pf, false).doRead(new DataInputWrapper(bb));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw ModuleInfo.invalidModuleDescriptor(e.getMessage());
        }
        catch (EOFException x) {
            throw ModuleInfo.truncatedModuleDescriptor();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private Attributes doRead(DataInput input) throws IOException {
        CountingDataInput in = new CountingDataInput(input);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw ModuleInfo.invalidModuleDescriptor("Bad magic number");
        }
        int minor_version = in.readUnsignedShort();
        int major_version = in.readUnsignedShort();
        if (!VM.isSupportedModuleDescriptorVersion(major_version, minor_version)) {
            throw ModuleInfo.invalidModuleDescriptor("Unsupported major.minor version " + major_version + "." + minor_version);
        }
        ConstantPool cpool = new ConstantPool(in);
        int access_flags = in.readUnsignedShort();
        if (access_flags != 32768) {
            throw ModuleInfo.invalidModuleDescriptor("access_flags should be ACC_MODULE");
        }
        int this_class = in.readUnsignedShort();
        String mn = cpool.getClassName(this_class);
        if (!"module-info".equals(mn)) {
            throw ModuleInfo.invalidModuleDescriptor("this_class should be module-info");
        }
        int super_class = in.readUnsignedShort();
        if (super_class > 0) {
            throw ModuleInfo.invalidModuleDescriptor("bad #super_class");
        }
        int interfaces_count = in.readUnsignedShort();
        if (interfaces_count > 0) {
            throw ModuleInfo.invalidModuleDescriptor("Bad #interfaces");
        }
        int fields_count = in.readUnsignedShort();
        if (fields_count > 0) {
            throw ModuleInfo.invalidModuleDescriptor("Bad #fields");
        }
        int methods_count = in.readUnsignedShort();
        if (methods_count > 0) {
            throw ModuleInfo.invalidModuleDescriptor("Bad #methods");
        }
        int attributes_count = in.readUnsignedShort();
        HashSet<String> attributes = new HashSet<String>();
        ModuleDescriptor.Builder builder = null;
        Set<String> allPackages = null;
        String mainClass = null;
        ModuleTarget moduleTarget = null;
        ModuleHashes moduleHashes = null;
        ModuleResolution moduleResolution = null;
        for (int i = 0; i < attributes_count; ++i) {
            int name_index = in.readUnsignedShort();
            String attribute_name = cpool.getUtf8(name_index);
            int length = in.readInt();
            boolean added = attributes.add(attribute_name);
            if (!added && ModuleInfo.isAttributeAtMostOnce(attribute_name)) {
                throw ModuleInfo.invalidModuleDescriptor("More than one " + attribute_name + " attribute");
            }
            long initialPosition = in.count();
            switch (attribute_name) {
                case "Module": {
                    builder = this.readModuleAttribute(in, cpool, major_version);
                    break;
                }
                case "ModulePackages": {
                    allPackages = this.readModulePackagesAttribute(in, cpool);
                    break;
                }
                case "ModuleMainClass": {
                    mainClass = this.readModuleMainClassAttribute(in, cpool);
                    break;
                }
                case "ModuleTarget": {
                    moduleTarget = this.readModuleTargetAttribute(in, cpool);
                    break;
                }
                case "ModuleHashes": {
                    if (this.parseHashes) {
                        moduleHashes = this.readModuleHashesAttribute(in, cpool);
                        break;
                    }
                    in.skipBytes(length);
                    break;
                }
                case "ModuleResolution": {
                    moduleResolution = this.readModuleResolution(in, cpool);
                    break;
                }
                default: {
                    if (ModuleInfo.isAttributeDisallowed(attribute_name)) {
                        throw ModuleInfo.invalidModuleDescriptor(attribute_name + " attribute not allowed");
                    }
                    in.skipBytes(length);
                }
            }
            long newPosition = in.count();
            if (newPosition - initialPosition == (long)length) continue;
            throw ModuleInfo.invalidModuleDescriptor("Attribute " + attribute_name + " does not match its expected length");
        }
        if (builder == null) {
            throw ModuleInfo.invalidModuleDescriptor("Module attribute not found");
        }
        if (mainClass != null) {
            builder.mainClass(mainClass);
        }
        boolean usedPackageFinder = false;
        if (allPackages == null && this.packageFinder != null) {
            try {
                allPackages = this.packageFinder.get();
            }
            catch (UncheckedIOException x) {
                throw x.getCause();
            }
            usedPackageFinder = true;
        }
        if (allPackages != null) {
            Set<String> knownPackages = JLMA.packages(builder);
            if (!allPackages.containsAll(knownPackages)) {
                HashSet<String> missingPackages = new HashSet<String>(knownPackages);
                missingPackages.removeAll(allPackages);
                assert (!missingPackages.isEmpty());
                String missingPackage = (String)missingPackages.iterator().next();
                String tail = usedPackageFinder ? " not found in module" : " missing from ModulePackages class file attribute";
                throw ModuleInfo.invalidModuleDescriptor("Package " + missingPackage + tail);
            }
            builder.packages(allPackages);
        }
        ModuleDescriptor descriptor = builder.build();
        return new Attributes(descriptor, moduleTarget, moduleHashes, moduleResolution);
    }

    private ModuleDescriptor.Builder readModuleAttribute(DataInput in, ConstantPool cpool, int major) throws IOException {
        int provides_count;
        int uses_count;
        int j;
        int opens_count;
        int exports_count;
        Set<ModuleDescriptor.Requires.Modifier> mods;
        boolean open;
        int module_name_index = in.readUnsignedShort();
        String mn = cpool.getModuleName(module_name_index);
        int module_flags = in.readUnsignedShort();
        HashSet<ModuleDescriptor.Modifier> modifiers = new HashSet<ModuleDescriptor.Modifier>();
        boolean bl = open = (module_flags & 0x20) != 0;
        if (open) {
            modifiers.add(ModuleDescriptor.Modifier.OPEN);
        }
        if ((module_flags & 0x1000) != 0) {
            modifiers.add(ModuleDescriptor.Modifier.SYNTHETIC);
        }
        if ((module_flags & 0x8000) != 0) {
            modifiers.add(ModuleDescriptor.Modifier.MANDATED);
        }
        ModuleDescriptor.Builder builder = JLMA.newModuleBuilder(mn, false, modifiers);
        int module_version_index = in.readUnsignedShort();
        if (module_version_index != 0) {
            String vs = cpool.getUtf8(module_version_index);
            builder.version(vs);
        }
        int requires_count = in.readUnsignedShort();
        boolean requiresJavaBase = false;
        for (int i = 0; i < requires_count; ++i) {
            int requires_index = in.readUnsignedShort();
            String dn = cpool.getModuleName(requires_index);
            int requires_flags = in.readUnsignedShort();
            if (requires_flags == 0) {
                mods = Set.of();
            } else {
                mods = new HashSet();
                if ((requires_flags & 0x20) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.TRANSITIVE);
                }
                if ((requires_flags & 0x40) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.STATIC);
                }
                if ((requires_flags & 0x1000) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.SYNTHETIC);
                }
                if ((requires_flags & 0x8000) != 0) {
                    mods.add(ModuleDescriptor.Requires.Modifier.MANDATED);
                }
            }
            int requires_version_index = in.readUnsignedShort();
            if (requires_version_index == 0) {
                builder.requires(mods, dn);
            } else {
                String vs = cpool.getUtf8(requires_version_index);
                JLMA.requires(builder, mods, dn, vs);
            }
            if (!dn.equals("java.base")) continue;
            if (major >= 54 && (mods.contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE) || mods.contains((Object)ModuleDescriptor.Requires.Modifier.STATIC))) {
                String flagName = mods.contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE) ? "ACC_TRANSITIVE" : "ACC_STATIC_PHASE";
                throw ModuleInfo.invalidModuleDescriptor("The requires entry for java.base has " + flagName + " set");
            }
            requiresJavaBase = true;
        }
        if (mn.equals("java.base")) {
            if (requires_count > 0) {
                throw ModuleInfo.invalidModuleDescriptor("The requires table for java.base must be 0 length");
            }
        } else if (!requiresJavaBase) {
            throw ModuleInfo.invalidModuleDescriptor("The requires table must have an entry for java.base");
        }
        if ((exports_count = in.readUnsignedShort()) > 0) {
            for (int i = 0; i < exports_count; ++i) {
                int exports_index = in.readUnsignedShort();
                String pkg = cpool.getPackageName(exports_index);
                int exports_flags = in.readUnsignedShort();
                if (exports_flags == 0) {
                    mods = Set.of();
                } else {
                    mods = new HashSet<ModuleDescriptor.Requires.Modifier>();
                    if ((exports_flags & 0x1000) != 0) {
                        mods.add((ModuleDescriptor.Requires.Modifier)((Object)ModuleDescriptor.Exports.Modifier.SYNTHETIC));
                    }
                    if ((exports_flags & 0x8000) != 0) {
                        mods.add((ModuleDescriptor.Requires.Modifier)((Object)ModuleDescriptor.Exports.Modifier.MANDATED));
                    }
                }
                int exports_to_count = in.readUnsignedShort();
                if (exports_to_count > 0) {
                    HashSet<String> targets = new HashSet<String>(exports_to_count);
                    for (int j2 = 0; j2 < exports_to_count; ++j2) {
                        int exports_to_index = in.readUnsignedShort();
                        String target = cpool.getModuleName(exports_to_index);
                        if (targets.add(target)) continue;
                        throw ModuleInfo.invalidModuleDescriptor(pkg + " exported to " + target + " more than once");
                    }
                    builder.exports(mods, pkg, targets);
                    continue;
                }
                builder.exports(mods, pkg);
            }
        }
        if ((opens_count = in.readUnsignedShort()) > 0) {
            if (open) {
                throw ModuleInfo.invalidModuleDescriptor("The opens table for an open module must be 0 length");
            }
            for (int i = 0; i < opens_count; ++i) {
                Set<ModuleDescriptor.Opens.Modifier> mods2;
                int opens_index = in.readUnsignedShort();
                String pkg = cpool.getPackageName(opens_index);
                int opens_flags = in.readUnsignedShort();
                if (opens_flags == 0) {
                    mods2 = Set.of();
                } else {
                    mods2 = new HashSet();
                    if ((opens_flags & 0x1000) != 0) {
                        mods2.add(ModuleDescriptor.Opens.Modifier.SYNTHETIC);
                    }
                    if ((opens_flags & 0x8000) != 0) {
                        mods2.add(ModuleDescriptor.Opens.Modifier.MANDATED);
                    }
                }
                int open_to_count = in.readUnsignedShort();
                if (open_to_count > 0) {
                    HashSet<String> targets = new HashSet<String>(open_to_count);
                    for (j = 0; j < open_to_count; ++j) {
                        int opens_to_index = in.readUnsignedShort();
                        String target = cpool.getModuleName(opens_to_index);
                        if (targets.add(target)) continue;
                        throw ModuleInfo.invalidModuleDescriptor(pkg + " opened to " + target + " more than once");
                    }
                    builder.opens(mods2, pkg, targets);
                    continue;
                }
                builder.opens(mods2, pkg);
            }
        }
        if ((uses_count = in.readUnsignedShort()) > 0) {
            for (int i = 0; i < uses_count; ++i) {
                int index = in.readUnsignedShort();
                String sn = cpool.getClassName(index);
                builder.uses(sn);
            }
        }
        if ((provides_count = in.readUnsignedShort()) > 0) {
            for (int i = 0; i < provides_count; ++i) {
                int index = in.readUnsignedShort();
                String sn = cpool.getClassName(index);
                int with_count = in.readUnsignedShort();
                ArrayList<String> providers = new ArrayList<String>(with_count);
                for (j = 0; j < with_count; ++j) {
                    index = in.readUnsignedShort();
                    String pn = cpool.getClassName(index);
                    if (providers.add(pn)) continue;
                    throw ModuleInfo.invalidModuleDescriptor(sn + " provides " + pn + " more than once");
                }
                builder.provides(sn, providers);
            }
        }
        return builder;
    }

    private Set<String> readModulePackagesAttribute(DataInput in, ConstantPool cpool) throws IOException {
        int package_count = in.readUnsignedShort();
        HashSet<String> packages = new HashSet<String>(package_count);
        for (int i = 0; i < package_count; ++i) {
            int index = in.readUnsignedShort();
            String pn = cpool.getPackageName(index);
            boolean added = packages.add(pn);
            if (added) continue;
            throw ModuleInfo.invalidModuleDescriptor("Package " + pn + " in ModulePackagesattribute more than once");
        }
        return packages;
    }

    private String readModuleMainClassAttribute(DataInput in, ConstantPool cpool) throws IOException {
        int index = in.readUnsignedShort();
        return cpool.getClassName(index);
    }

    private ModuleTarget readModuleTargetAttribute(DataInput in, ConstantPool cpool) throws IOException {
        String targetPlatform = null;
        int index = in.readUnsignedShort();
        if (index != 0) {
            targetPlatform = cpool.getUtf8(index);
        }
        return new ModuleTarget(targetPlatform);
    }

    private ModuleHashes readModuleHashesAttribute(DataInput in, ConstantPool cpool) throws IOException {
        int algorithm_index = in.readUnsignedShort();
        String algorithm = cpool.getUtf8(algorithm_index);
        int hash_count = in.readUnsignedShort();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>(hash_count);
        for (int i = 0; i < hash_count; ++i) {
            int module_name_index = in.readUnsignedShort();
            String mn = cpool.getModuleName(module_name_index);
            int hash_length = in.readUnsignedShort();
            if (hash_length == 0) {
                throw ModuleInfo.invalidModuleDescriptor("hash_length == 0");
            }
            byte[] hash = new byte[hash_length];
            in.readFully(hash);
            map.put(mn, hash);
        }
        return new ModuleHashes(algorithm, map);
    }

    private ModuleResolution readModuleResolution(DataInput in, ConstantPool cpool) throws IOException {
        int flags = in.readUnsignedShort();
        int reason = 0;
        if ((flags & 2) != 0) {
            reason = 2;
        }
        if ((flags & 4) != 0) {
            if (reason != 0) {
                throw ModuleInfo.invalidModuleDescriptor("Bad module resolution flags:" + flags);
            }
            reason = 4;
        }
        if ((flags & 8) != 0 && reason != 0) {
            throw ModuleInfo.invalidModuleDescriptor("Bad module resolution flags:" + flags);
        }
        return new ModuleResolution(flags);
    }

    private static boolean isAttributeAtMostOnce(String name) {
        return name.equals("Module") || name.equals("SourceFile") || name.equals("SourceDebugExtension") || name.equals("ModulePackages") || name.equals("ModuleMainClass") || name.equals("ModuleTarget") || name.equals("ModuleHashes") || name.equals("ModuleResolution");
    }

    private static boolean isAttributeDisallowed(String name) {
        Set<String> notAllowed = predefinedNotAllowed;
        if (notAllowed == null) {
            predefinedNotAllowed = notAllowed = Set.of("ConstantValue", "Code", "Deprecated", "StackMapTable", "Exceptions", "EnclosingMethod", "Signature", "LineNumberTable", "LocalVariableTable", "LocalVariableTypeTable", "RuntimeVisibleParameterAnnotations", "RuntimeInvisibleParameterAnnotations", "RuntimeVisibleTypeAnnotations", "RuntimeInvisibleTypeAnnotations", "Synthetic", "AnnotationDefault", "BootstrapMethods", "MethodParameters");
        }
        return notAllowed.contains(name);
    }

    private static InvalidModuleDescriptorException invalidModuleDescriptor(String msg) {
        return new InvalidModuleDescriptorException(msg);
    }

    private static InvalidModuleDescriptorException truncatedModuleDescriptor() {
        return ModuleInfo.invalidModuleDescriptor("Truncated module-info.class");
    }

    public static final class Attributes {
        private final ModuleDescriptor descriptor;
        private final ModuleTarget target;
        private final ModuleHashes recordedHashes;
        private final ModuleResolution moduleResolution;

        Attributes(ModuleDescriptor descriptor, ModuleTarget target, ModuleHashes recordedHashes, ModuleResolution moduleResolution) {
            this.descriptor = descriptor;
            this.target = target;
            this.recordedHashes = recordedHashes;
            this.moduleResolution = moduleResolution;
        }

        public ModuleDescriptor descriptor() {
            return this.descriptor;
        }

        public ModuleTarget target() {
            return this.target;
        }

        public ModuleHashes recordedHashes() {
            return this.recordedHashes;
        }

        public ModuleResolution moduleResolution() {
            return this.moduleResolution;
        }
    }

    private static class DataInputWrapper
    implements DataInput {
        private final ByteBuffer bb;

        DataInputWrapper(ByteBuffer bb) {
            this.bb = bb;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            try {
                this.bb.get(b, off, len);
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public int skipBytes(int n) {
            int skip = Math.min(n, this.bb.remaining());
            this.bb.position(this.bb.position() + skip);
            return skip;
        }

        @Override
        public boolean readBoolean() throws IOException {
            try {
                byte ch = this.bb.get();
                return ch != 0;
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public byte readByte() throws IOException {
            try {
                return this.bb.get();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public int readUnsignedByte() throws IOException {
            try {
                return this.bb.get() & 0xFF;
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public short readShort() throws IOException {
            try {
                return this.bb.getShort();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public int readUnsignedShort() throws IOException {
            try {
                return this.bb.getShort() & 0xFFFF;
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public char readChar() throws IOException {
            try {
                return this.bb.getChar();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public int readInt() throws IOException {
            try {
                return this.bb.getInt();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public long readLong() throws IOException {
            try {
                return this.bb.getLong();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public float readFloat() throws IOException {
            try {
                return this.bb.getFloat();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public double readDouble() throws IOException {
            try {
                return this.bb.getDouble();
            }
            catch (BufferUnderflowException e) {
                throw new EOFException(e.getMessage());
            }
        }

        @Override
        public String readLine() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public String readUTF() throws IOException {
            return DataInputStream.readUTF(this);
        }
    }

    private static class CountingDataInput
    implements DataInput {
        private final DataInput delegate;
        private long count;

        CountingDataInput(DataInput delegate) {
            this.delegate = delegate;
        }

        long count() {
            return this.count;
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.delegate.readFully(b, 0, b.length);
            this.count += (long)b.length;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.delegate.readFully(b, off, len);
            this.count += (long)len;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            int skip = this.delegate.skipBytes(n);
            this.count += (long)skip;
            return skip;
        }

        @Override
        public boolean readBoolean() throws IOException {
            boolean b = this.delegate.readBoolean();
            ++this.count;
            return b;
        }

        @Override
        public byte readByte() throws IOException {
            byte b = this.delegate.readByte();
            ++this.count;
            return b;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int i = this.delegate.readUnsignedByte();
            ++this.count;
            return i;
        }

        @Override
        public short readShort() throws IOException {
            short s = this.delegate.readShort();
            this.count += 2L;
            return s;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int s = this.delegate.readUnsignedShort();
            this.count += 2L;
            return s;
        }

        @Override
        public char readChar() throws IOException {
            char c = this.delegate.readChar();
            this.count += 2L;
            return c;
        }

        @Override
        public int readInt() throws IOException {
            int i = this.delegate.readInt();
            this.count += 4L;
            return i;
        }

        @Override
        public long readLong() throws IOException {
            long l = this.delegate.readLong();
            this.count += 8L;
            return l;
        }

        @Override
        public float readFloat() throws IOException {
            float f = this.delegate.readFloat();
            this.count += 4L;
            return f;
        }

        @Override
        public double readDouble() throws IOException {
            double d = this.delegate.readDouble();
            this.count += 8L;
            return d;
        }

        @Override
        public String readLine() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public String readUTF() throws IOException {
            return DataInputStream.readUTF(this);
        }
    }

    private static class ConstantPool {
        static final int CONSTANT_Utf8 = 1;
        static final int CONSTANT_Integer = 3;
        static final int CONSTANT_Float = 4;
        static final int CONSTANT_Long = 5;
        static final int CONSTANT_Double = 6;
        static final int CONSTANT_Class = 7;
        static final int CONSTANT_String = 8;
        static final int CONSTANT_Fieldref = 9;
        static final int CONSTANT_Methodref = 10;
        static final int CONSTANT_InterfaceMethodref = 11;
        static final int CONSTANT_NameAndType = 12;
        static final int CONSTANT_MethodHandle = 15;
        static final int CONSTANT_MethodType = 16;
        static final int CONSTANT_InvokeDynamic = 18;
        static final int CONSTANT_Module = 19;
        static final int CONSTANT_Package = 20;
        final Entry[] pool;

        ConstantPool(DataInput in) throws IOException {
            int count = in.readUnsignedShort();
            this.pool = new Entry[count];
            block11: for (int i = 1; i < count; ++i) {
                int tag = in.readUnsignedByte();
                switch (tag) {
                    case 1: {
                        String svalue = in.readUTF();
                        this.pool[i] = new ValueEntry(tag, svalue);
                        continue block11;
                    }
                    case 7: 
                    case 8: 
                    case 19: 
                    case 20: {
                        int index = in.readUnsignedShort();
                        this.pool[i] = new IndexEntry(tag, index);
                        continue block11;
                    }
                    case 6: {
                        double dvalue = in.readDouble();
                        this.pool[i] = new ValueEntry(tag, dvalue);
                        ++i;
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        int index1 = in.readUnsignedShort();
                        int index2 = in.readUnsignedShort();
                        this.pool[i] = new Index2Entry(tag, index1, index2);
                        continue block11;
                    }
                    case 15: {
                        int refKind = in.readUnsignedByte();
                        int index = in.readUnsignedShort();
                        this.pool[i] = new Index2Entry(tag, refKind, index);
                        continue block11;
                    }
                    case 16: {
                        int index = in.readUnsignedShort();
                        this.pool[i] = new IndexEntry(tag, index);
                        continue block11;
                    }
                    case 4: {
                        float fvalue = in.readFloat();
                        this.pool[i] = new ValueEntry(tag, Float.valueOf(fvalue));
                        continue block11;
                    }
                    case 3: {
                        int ivalue = in.readInt();
                        this.pool[i] = new ValueEntry(tag, ivalue);
                        continue block11;
                    }
                    case 5: {
                        long lvalue = in.readLong();
                        this.pool[i] = new ValueEntry(tag, lvalue);
                        ++i;
                        continue block11;
                    }
                    default: {
                        throw ModuleInfo.invalidModuleDescriptor("Bad constant pool entry: " + i);
                    }
                }
            }
        }

        String getClassName(int index) {
            this.checkIndex(index);
            Entry e = this.pool[index];
            if (e.tag != 7) {
                throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Class expected at entry: " + index);
            }
            String value = this.getUtf8(((IndexEntry)e).index);
            this.checkUnqualifiedName("CONSTANT_Class", index, value);
            return value.replace('/', '.');
        }

        String getPackageName(int index) {
            this.checkIndex(index);
            Entry e = this.pool[index];
            if (e.tag != 20) {
                throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Package expected at entry: " + index);
            }
            String value = this.getUtf8(((IndexEntry)e).index);
            this.checkUnqualifiedName("CONSTANT_Package", index, value);
            return value.replace('/', '.');
        }

        String getModuleName(int index) {
            this.checkIndex(index);
            Entry e = this.pool[index];
            if (e.tag != 19) {
                throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module expected at entry: " + index);
            }
            String value = this.getUtf8(((IndexEntry)e).index);
            return this.decodeModuleName(index, value);
        }

        String getUtf8(int index) {
            this.checkIndex(index);
            Entry e = this.pool[index];
            if (e.tag != 1) {
                throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Utf8 expected at entry: " + index);
            }
            return (String)((ValueEntry)e).value;
        }

        void checkIndex(int index) {
            if (index < 1 || index >= this.pool.length) {
                throw ModuleInfo.invalidModuleDescriptor("Index into constant pool out of range");
            }
        }

        void checkUnqualifiedName(String what, int index, String value) {
            int len = value.length();
            if (len == 0) {
                throw ModuleInfo.invalidModuleDescriptor(what + " at entry " + index + " has zero length");
            }
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c != '.' && c != ';' && c != '[') continue;
                throw ModuleInfo.invalidModuleDescriptor(what + " at entry " + index + " has illegal character: '" + c + "'");
            }
        }

        String decodeModuleName(int index, String value) {
            int cp;
            int len = value.length();
            if (len == 0) {
                throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module at entry " + index + " is zero length");
            }
            for (int i = 0; i < len; i += Character.charCount(cp)) {
                cp = value.codePointAt(i);
                if (cp == 58 || cp == 64 || cp < 32) {
                    throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module at entry " + index + " has illegal character: " + Character.getName(cp));
                }
                if (cp != 92) continue;
                return this.decodeModuleName(index, i, value);
            }
            return value;
        }

        String decodeModuleName(int index, int i, String value) {
            int j;
            int cp;
            StringBuilder sb = new StringBuilder();
            for (j = 0; j < i; j += Character.charCount(cp)) {
                cp = value.codePointAt(j);
                sb.appendCodePoint(cp);
            }
            int len = value.length();
            while (i < len) {
                int cp2 = value.codePointAt(i);
                if (cp2 == 58 || cp2 == 64 || cp2 < 32) {
                    throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module at entry " + index + " has illegal character: " + Character.getName(cp2));
                }
                if (cp2 == 92) {
                    j = i + Character.charCount(cp2);
                    if (j >= len) {
                        throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module at entry " + index + " has illegal escape sequence");
                    }
                    int next = value.codePointAt(j);
                    if (next != 92 && next != 58 && next != 64) {
                        throw ModuleInfo.invalidModuleDescriptor("CONSTANT_Module at entry " + index + " has illegal escape sequence");
                    }
                    sb.appendCodePoint(next);
                    i += Character.charCount(next);
                } else {
                    sb.appendCodePoint(cp2);
                }
                i += Character.charCount(cp2);
            }
            return sb.toString();
        }

        private static class Entry {
            final int tag;

            protected Entry(int tag) {
                this.tag = tag;
            }
        }

        private static class ValueEntry
        extends Entry {
            final Object value;

            ValueEntry(int tag, Object value) {
                super(tag);
                this.value = value;
            }
        }

        private static class IndexEntry
        extends Entry {
            final int index;

            IndexEntry(int tag, int index) {
                super(tag);
                this.index = index;
            }
        }

        private static class Index2Entry
        extends Entry {
            final int index1;
            final int index2;

            Index2Entry(int tag, int index1, int index2) {
                super(tag);
                this.index1 = index1;
                this.index2 = index2;
            }
        }
    }
}

