/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleResolution;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.ModuleVisitor;
import jdk.internal.org.objectweb.asm.commons.ModuleHashesAttribute;
import jdk.internal.org.objectweb.asm.commons.ModuleResolutionAttribute;
import jdk.internal.org.objectweb.asm.commons.ModuleTargetAttribute;

public final class ModuleInfoExtender {
    private final InputStream in;
    private Set<String> packages;
    private ModuleDescriptor.Version version;
    private String mainClass;
    private String targetPlatform;
    private ModuleHashes hashes;
    private ModuleResolution moduleResolution;

    private ModuleInfoExtender(InputStream in) {
        this.in = in;
    }

    public ModuleInfoExtender packages(Set<String> packages) {
        this.packages = Collections.unmodifiableSet(packages);
        return this;
    }

    public ModuleInfoExtender version(ModuleDescriptor.Version version) {
        this.version = version;
        return this;
    }

    public ModuleInfoExtender mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public ModuleInfoExtender targetPlatform(String targetPlatform) {
        this.targetPlatform = targetPlatform;
        return this;
    }

    public ModuleInfoExtender hashes(ModuleHashes hashes) {
        this.hashes = hashes;
        return this;
    }

    public ModuleInfoExtender moduleResolution(ModuleResolution mres) {
        this.moduleResolution = mres;
        return this;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }

    public byte[] toByteArray() throws IOException {
        ClassWriter cw = new ClassWriter(3);
        ClassReader cr = new ClassReader(this.in);
        ClassVisitor cv = new ClassVisitor(458752, cw){

            @Override
            public ModuleVisitor visitModule(String name, int flags, String version) {
                ModuleDescriptor.Version v = ModuleInfoExtender.this.version;
                String vs = v != null ? v.toString() : version;
                ModuleVisitor mv = super.visitModule(name, flags, vs);
                if (ModuleInfoExtender.this.mainClass != null) {
                    mv.visitMainClass(ModuleInfoExtender.this.mainClass.replace('.', '/'));
                }
                if (ModuleInfoExtender.this.packages != null) {
                    ModuleInfoExtender.this.packages.stream().sorted().forEach(pn -> mv.visitPackage(pn.replace('.', '/')));
                }
                return new ModuleVisitor(458752, mv){

                    @Override
                    public void visitMainClass(String existingMainClass) {
                        if (ModuleInfoExtender.this.mainClass == null) {
                            super.visitMainClass(existingMainClass);
                        }
                    }

                    @Override
                    public void visitPackage(String existingPackage) {
                        if (ModuleInfoExtender.this.packages == null) {
                            super.visitPackage(existingPackage);
                        }
                    }
                };
            }

            @Override
            public void visitAttribute(Attribute attr) {
                String name = attr.type;
                if (name.equals("ModuleTarget") && ModuleInfoExtender.this.targetPlatform != null) {
                    return;
                }
                if (name.equals("ModuleResolution") && ModuleInfoExtender.this.moduleResolution != null) {
                    return;
                }
                if (name.equals("ModuleHashes") && ModuleInfoExtender.this.hashes != null) {
                    return;
                }
                super.visitAttribute(attr);
            }
        };
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(new ModuleTargetAttribute());
        attrs.add(new ModuleResolutionAttribute());
        attrs.add(new ModuleHashesAttribute());
        cr.accept(cv, attrs.toArray(new Attribute[0]), 0);
        if (this.targetPlatform != null) {
            cw.visitAttribute(new ModuleTargetAttribute(this.targetPlatform));
        }
        if (this.moduleResolution != null) {
            int flags = this.moduleResolution.value();
            cw.visitAttribute(new ModuleResolutionAttribute(flags));
        }
        if (this.hashes != null) {
            String algorithm = this.hashes.algorithm();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<byte[]> values = new ArrayList<byte[]>();
            for (String name : this.hashes.names()) {
                names.add(name);
                values.add(this.hashes.hashFor(name));
            }
            cw.visitAttribute(new ModuleHashesAttribute(algorithm, names, values));
        }
        return cw.toByteArray();
    }

    public static ModuleInfoExtender newExtender(InputStream in) {
        return new ModuleInfoExtender(in);
    }
}

