/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Stream;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.ModuleVisitor;
import jdk.internal.org.objectweb.asm.commons.ModuleResolutionAttribute;
import jdk.internal.org.objectweb.asm.commons.ModuleTargetAttribute;

public final class ModuleInfoWriter {
    private static final Map<ModuleDescriptor.Modifier, Integer> MODULE_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Modifier.OPEN, 32, ModuleDescriptor.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Requires.Modifier, Integer> REQUIRES_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Requires.Modifier.TRANSITIVE, 32, ModuleDescriptor.Requires.Modifier.STATIC, 64, ModuleDescriptor.Requires.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Requires.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Exports.Modifier, Integer> EXPORTS_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Exports.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Exports.Modifier.MANDATED, 32768);
    private static final Map<ModuleDescriptor.Opens.Modifier, Integer> OPENS_MODS_TO_FLAGS = Map.of(ModuleDescriptor.Opens.Modifier.SYNTHETIC, 4096, ModuleDescriptor.Opens.Modifier.MANDATED, 32768);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private ModuleInfoWriter() {
    }

    private static byte[] toModuleInfo(ModuleDescriptor md, ModuleResolution mres, ModuleTarget target) {
        String[] targets;
        int flags;
        ClassWriter cw = new ClassWriter(0);
        cw.visit(54, 32768, "module-info", null, null, null);
        int moduleFlags = md.modifiers().stream().map(MODULE_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
        String vs = md.rawVersion().orElse(null);
        ModuleVisitor mv = cw.visitModule(md.name(), moduleFlags, vs);
        for (ModuleDescriptor.Requires r : md.requires()) {
            flags = r.modifiers().stream().map(REQUIRES_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
            vs = r.rawCompiledVersion().orElse(null);
            mv.visitRequire(r.name(), flags, vs);
        }
        for (ModuleDescriptor.Exports e : md.exports()) {
            flags = e.modifiers().stream().map(EXPORTS_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
            targets = e.targets().toArray(EMPTY_STRING_ARRAY);
            mv.visitExport(e.source().replace('.', '/'), flags, targets);
        }
        for (ModuleDescriptor.Opens opens : md.opens()) {
            flags = opens.modifiers().stream().map(OPENS_MODS_TO_FLAGS::get).reduce(0, (x, y) -> x | y);
            targets = opens.targets().toArray(EMPTY_STRING_ARRAY);
            mv.visitOpen(opens.source().replace('.', '/'), flags, targets);
        }
        md.uses().stream().map(sn -> sn.replace('.', '/')).forEach(mv::visitUse);
        for (ModuleDescriptor.Provides p : md.provides()) {
            mv.visitProvide(p.service().replace('.', '/'), (String[])p.providers().stream().map(pn -> pn.replace('.', '/')).toArray(String[]::new));
        }
        Stream<String> exported = md.exports().stream().map(ModuleDescriptor.Exports::source);
        Stream<String> open = md.opens().stream().map(ModuleDescriptor.Opens::source);
        long exportedOrOpen = Stream.concat(exported, open).distinct().count();
        if ((long)md.packages().size() > exportedOrOpen) {
            md.packages().stream().map(pn -> pn.replace('.', '/')).forEach(mv::visitPackage);
        }
        md.mainClass().map(mc -> mc.replace('.', '/')).ifPresent(mv::visitMainClass);
        mv.visitEnd();
        if (mres != null) {
            cw.visitAttribute(new ModuleResolutionAttribute(mres.value()));
        }
        if (target != null && target.targetPlatform().length() > 0) {
            cw.visitAttribute(new ModuleTargetAttribute(target.targetPlatform()));
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static void write(ModuleDescriptor descriptor, ModuleResolution mres, ModuleTarget target, OutputStream out) throws IOException {
        byte[] bytes = ModuleInfoWriter.toModuleInfo(descriptor, mres, target);
        out.write(bytes);
    }

    public static void write(ModuleDescriptor descriptor, ModuleResolution mres, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, mres, null, out);
    }

    public static void write(ModuleDescriptor descriptor, ModuleTarget target, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, null, target, out);
    }

    public static void write(ModuleDescriptor descriptor, OutputStream out) throws IOException {
        ModuleInfoWriter.write(descriptor, null, null, out);
    }

    public static byte[] toBytes(ModuleDescriptor descriptor) {
        return ModuleInfoWriter.toModuleInfo(descriptor, null, null);
    }

    public static ByteBuffer toByteBuffer(ModuleDescriptor descriptor) {
        byte[] bytes = ModuleInfoWriter.toModuleInfo(descriptor, null, null);
        return ByteBuffer.wrap(bytes);
    }
}

