/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.Configuration;
import java.lang.module.ResolvedModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jdk.internal.loader.ClassLoaders;

public final class ModuleLoaderMap {
    public static Set<String> bootModules() {
        return Modules.bootModules;
    }

    public static Set<String> platformModules() {
        return Modules.platformModules;
    }

    static Function<String, ClassLoader> mappingFunction(Configuration cf) {
        return new Mapper(cf);
    }

    public static boolean isBuiltinMapper(Function<String, ClassLoader> clf) {
        return clf instanceof Mapper;
    }

    private static class Modules {
        private static final Set<String> bootModules = Set.of(new String[]{"@@BOOT_MODULE_NAMES@@"});
        private static final Set<String> platformModules = Set.of(new String[]{"@@PLATFORM_MODULE_NAMES@@"});

        private Modules() {
        }
    }

    private static final class Mapper
    implements Function<String, ClassLoader> {
        private static final ClassLoader PLATFORM_CLASSLOADER = ClassLoaders.platformClassLoader();
        private static final ClassLoader APP_CLASSLOADER = ClassLoaders.appClassLoader();
        private static final Integer PLATFORM_LOADER_INDEX = 1;
        private static final Integer APP_LOADER_INDEX = 2;
        private final Map<String, Integer> map;

        Mapper(Configuration cf) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (ResolvedModule resolvedModule : cf.modules()) {
                String mn = resolvedModule.name();
                if (Modules.bootModules.contains(mn)) continue;
                if (Modules.platformModules.contains(mn)) {
                    map.put(mn, PLATFORM_LOADER_INDEX);
                    continue;
                }
                map.put(mn, APP_LOADER_INDEX);
            }
            this.map = map;
        }

        @Override
        public ClassLoader apply(String name) {
            Integer loader = this.map.get(name);
            if (loader == APP_LOADER_INDEX) {
                return APP_CLASSLOADER;
            }
            if (loader == PLATFORM_LOADER_INDEX) {
                return PLATFORM_CLASSLOADER;
            }
            return null;
        }
    }
}

