/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import jdk.internal.access.JavaLangModuleAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.Resource;
import jdk.internal.module.Checks;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleReferenceImpl;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;
import jdk.internal.module.Resources;
import sun.net.www.ParseUtil;

public final class ModulePatcher {
    private static final JavaLangModuleAccess JLMA = SharedSecrets.getJavaLangModuleAccess();
    private final Map<String, List<Path>> map;

    public ModulePatcher(Map<String, List<String>> input) {
        if (input.isEmpty()) {
            this.map = Map.of();
        } else {
            HashMap<String, List<Path>> map = new HashMap<String, List<Path>>();
            for (Map.Entry<String, List<String>> e : input.entrySet()) {
                String mn = e.getKey();
                List<Path> paths = e.getValue().stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
                map.put(mn, paths);
            }
            this.map = map;
        }
    }

    public ModuleReference patchIfNeeded(ModuleReference mref) {
        ModuleDescriptor descriptor = mref.descriptor();
        String mn = descriptor.name();
        List<Path> paths = this.map.get(mn);
        if (paths == null) {
            return mref;
        }
        HashSet<String> packages = new HashSet<String>();
        boolean isAutomatic = descriptor.isAutomatic();
        try {
            for (Path file : paths) {
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    JarFile jf = new JarFile(file.toString());
                    try {
                        jf.stream().filter(e -> !e.isDirectory() && (!isAutomatic || e.getName().endsWith(".class"))).map(e -> ModulePatcher.toPackageName(file, e)).filter(Checks::isPackageName).forEach(packages::add);
                        continue;
                    }
                    finally {
                        jf.close();
                        continue;
                    }
                }
                if (!Files.isDirectory(file, new LinkOption[0])) continue;
                Path top = file;
                Files.find(top, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile(), new FileVisitOption[0]).filter(path -> (!isAutomatic || path.toString().endsWith(".class")) && !this.isHidden((Path)path)).map(path -> ModulePatcher.toPackageName(top, path)).filter(Checks::isPackageName).forEach(packages::add);
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
        packages.removeAll(descriptor.packages());
        if (!packages.isEmpty()) {
            ModuleDescriptor.Builder builder = JLMA.newModuleBuilder(descriptor.name(), descriptor.isAutomatic(), descriptor.modifiers());
            if (!descriptor.isAutomatic()) {
                descriptor.requires().forEach(builder::requires);
                descriptor.exports().forEach(builder::exports);
                descriptor.opens().forEach(builder::opens);
                descriptor.uses().forEach(builder::uses);
            }
            descriptor.provides().forEach(builder::provides);
            descriptor.version().ifPresent(builder::version);
            descriptor.mainClass().ifPresent(builder::mainClass);
            builder.packages(descriptor.packages());
            builder.packages(packages);
            descriptor = builder.build();
        }
        URI location = mref.location().orElse(null);
        ModuleTarget target = null;
        ModuleHashes recordedHashes = null;
        ModuleHashes.HashSupplier hasher = null;
        ModuleResolution mres = null;
        if (mref instanceof ModuleReferenceImpl) {
            ModuleReferenceImpl impl = (ModuleReferenceImpl)mref;
            target = impl.moduleTarget();
            recordedHashes = impl.recordedHashes();
            hasher = impl.hasher();
            mres = impl.moduleResolution();
        }
        return new ModuleReferenceImpl(descriptor, location, () -> new PatchedModuleReader(paths, mref), this, target, recordedHashes, hasher, mres);
    }

    public boolean hasPatches() {
        return !this.map.isEmpty();
    }

    Set<String> patchedModules() {
        return this.map.keySet();
    }

    private static String toPackageName(Path top, Path file) {
        Path entry = top.relativize(file);
        Path parent = entry.getParent();
        if (parent == null) {
            return ModulePatcher.warnIfModuleInfo(top, entry.toString());
        }
        return parent.toString().replace(File.separatorChar, '.');
    }

    private boolean isHidden(Path file) {
        try {
            return Files.isHidden(file);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private static String toPackageName(Path file, JarEntry entry) {
        String name = entry.getName();
        int index = name.lastIndexOf("/");
        if (index == -1) {
            return ModulePatcher.warnIfModuleInfo(file, name);
        }
        return name.substring(0, index).replace('/', '.');
    }

    private static String warnIfModuleInfo(Path file, String e) {
        if (e.equals("module-info.class")) {
            System.err.println("WARNING: " + e + " ignored in patch: " + file);
        }
        return "";
    }

    public static class PatchedModuleReader
    implements ModuleReader {
        private final List<ResourceFinder> finders;
        private final ModuleReference mref;
        private final URL delegateCodeSourceURL;
        private volatile ModuleReader delegate;

        PatchedModuleReader(List<Path> patches, ModuleReference mref) {
            ArrayList<ResourceFinder> finders = new ArrayList<ResourceFinder>();
            boolean initialized = false;
            try {
                for (Path file : patches) {
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        finders.add(new JarResourceFinder(file));
                        continue;
                    }
                    finders.add(new ExplodedResourceFinder(file));
                }
                initialized = true;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            finally {
                if (!initialized) {
                    PatchedModuleReader.closeAll(finders);
                }
            }
            this.finders = finders;
            this.mref = mref;
            this.delegateCodeSourceURL = PatchedModuleReader.codeSourceURL(mref);
        }

        private static void closeAll(List<ResourceFinder> finders) {
            for (ResourceFinder finder : finders) {
                try {
                    finder.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static URL codeSourceURL(ModuleReference mref) {
            try {
                Optional<URI> ouri = mref.location();
                if (ouri.isPresent()) {
                    return ouri.get().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ModuleReader delegate() throws IOException {
            ModuleReader r = this.delegate;
            if (r == null) {
                PatchedModuleReader patchedModuleReader = this;
                synchronized (patchedModuleReader) {
                    r = this.delegate;
                    if (r == null) {
                        this.delegate = r = this.mref.open();
                    }
                }
            }
            return r;
        }

        private Resource findResourceInPatch(String name) throws IOException {
            if (!name.equals("module-info.class")) {
                for (ResourceFinder finder : this.finders) {
                    Resource r = finder.find(name);
                    if (r == null) continue;
                    return r;
                }
            }
            return null;
        }

        public Resource findResource(String name) throws IOException {
            Resource r = this.findResourceInPatch(name);
            if (r != null) {
                return r;
            }
            final ByteBuffer bb = this.delegate().read(name).orElse(null);
            if (bb == null) {
                return null;
            }
            return new Resource(){

                private <T> T shouldNotGetHere(Class<T> type) {
                    throw new InternalError("should not get here");
                }

                @Override
                public String getName() {
                    return this.shouldNotGetHere(String.class);
                }

                @Override
                public URL getURL() {
                    return this.shouldNotGetHere(URL.class);
                }

                @Override
                public URL getCodeSourceURL() {
                    return delegateCodeSourceURL;
                }

                @Override
                public ByteBuffer getByteBuffer() throws IOException {
                    return bb;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return this.shouldNotGetHere(InputStream.class);
                }

                @Override
                public int getContentLength() throws IOException {
                    return this.shouldNotGetHere(Integer.TYPE);
                }
            };
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            Resource r = this.findResourceInPatch(name);
            if (r != null) {
                URI uri = URI.create(r.getURL().toString());
                return Optional.of(uri);
            }
            return this.delegate().find(name);
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            Resource r = this.findResourceInPatch(name);
            if (r != null) {
                return Optional.of(r.getInputStream());
            }
            return this.delegate().open(name);
        }

        @Override
        public Optional<ByteBuffer> read(String name) throws IOException {
            Resource r = this.findResourceInPatch(name);
            if (r != null) {
                ByteBuffer bb = r.getByteBuffer();
                assert (!bb.isDirect());
                return Optional.of(bb);
            }
            return this.delegate().read(name);
        }

        @Override
        public void release(ByteBuffer bb) {
            if (bb.isDirect()) {
                try {
                    this.delegate().release(bb);
                }
                catch (IOException ioe) {
                    throw new InternalError(ioe);
                }
            }
        }

        @Override
        public Stream<String> list() throws IOException {
            Stream<String> s = this.delegate().list();
            for (ResourceFinder finder : this.finders) {
                s = Stream.concat(s, finder.list());
            }
            return s.distinct();
        }

        @Override
        public void close() throws IOException {
            PatchedModuleReader.closeAll(this.finders);
            this.delegate().close();
        }
    }

    private static class ExplodedResourceFinder
    implements ResourceFinder {
        private final Path dir;

        ExplodedResourceFinder(Path dir) {
            this.dir = dir;
        }

        @Override
        public void close() {
        }

        @Override
        public Resource find(String name) throws IOException {
            Path file = Resources.toFilePath(this.dir, name);
            if (file != null) {
                return this.newResource(name, this.dir, file);
            }
            return null;
        }

        private Resource newResource(final String name, final Path top, final Path file) {
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    try {
                        return file.toUri().toURL();
                    }
                    catch (IOError | IOException e) {
                        return null;
                    }
                }

                @Override
                public URL getCodeSourceURL() {
                    try {
                        return top.toUri().toURL();
                    }
                    catch (IOError | IOException e) {
                        return null;
                    }
                }

                @Override
                public ByteBuffer getByteBuffer() throws IOException {
                    return ByteBuffer.wrap(Files.readAllBytes(file));
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return Files.newInputStream(file, new OpenOption[0]);
                }

                @Override
                public int getContentLength() throws IOException {
                    long size = Files.size(file);
                    return size > Integer.MAX_VALUE ? -1 : (int)size;
                }
            };
        }

        @Override
        public Stream<String> list() throws IOException {
            return Files.walk(this.dir, Integer.MAX_VALUE, new FileVisitOption[0]).map(f -> Resources.toResourceName(this.dir, f)).filter(s -> !s.isEmpty());
        }
    }

    private static class JarResourceFinder
    implements ResourceFinder {
        private final JarFile jf;
        private final URL csURL;

        JarResourceFinder(Path path) throws IOException {
            this.jf = new JarFile(path.toString());
            this.csURL = path.toUri().toURL();
        }

        @Override
        public void close() throws IOException {
            this.jf.close();
        }

        @Override
        public Resource find(final String name) throws IOException {
            final JarEntry entry = this.jf.getJarEntry(name);
            if (entry == null) {
                return null;
            }
            return new Resource(){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public URL getURL() {
                    String encodedPath = ParseUtil.encodePath(name, false);
                    try {
                        return new URL("jar:" + csURL + "!/" + encodedPath);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }

                @Override
                public URL getCodeSourceURL() {
                    return csURL;
                }

                @Override
                public ByteBuffer getByteBuffer() throws IOException {
                    byte[] bytes = this.getInputStream().readAllBytes();
                    return ByteBuffer.wrap(bytes);
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return jf.getInputStream(entry);
                }

                @Override
                public int getContentLength() throws IOException {
                    long size = entry.getSize();
                    return size > Integer.MAX_VALUE ? -1 : (int)size;
                }
            };
        }

        @Override
        public Stream<String> list() throws IOException {
            return this.jf.stream().map(ZipEntry::getName);
        }
    }

    private static interface ResourceFinder
    extends Closeable {
        public Resource find(String var1) throws IOException;

        public Stream<String> list() throws IOException;
    }
}

