/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.module.FindException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import jdk.internal.jmod.JmodFile;
import jdk.internal.module.Checks;
import jdk.internal.module.ModuleInfo;
import jdk.internal.module.ModulePatcher;
import jdk.internal.module.ModuleReferences;
import jdk.internal.perf.PerfCounter;
import sun.nio.cs.UTF_8;

public class ModulePath
implements ModuleFinder {
    private static final String MODULE_INFO = "module-info.class";
    private final Runtime.Version releaseVersion;
    private final boolean isLinkPhase;
    private final ModulePatcher patcher;
    private final Path[] entries;
    private int next;
    private final Map<String, ModuleReference> cachedModules = new HashMap<String, ModuleReference>();
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final PerfCounter scanTime = PerfCounter.newPerfCounter("jdk.module.finder.modulepath.scanTime");
    private static final PerfCounter moduleCount = PerfCounter.newPerfCounter("jdk.module.finder.modulepath.modules");

    private ModulePath(Runtime.Version version, boolean isLinkPhase, ModulePatcher patcher, Path ... entries) {
        this.releaseVersion = version;
        this.isLinkPhase = isLinkPhase;
        this.patcher = patcher;
        for (Path entry : this.entries = (Path[])entries.clone()) {
            Objects.requireNonNull(entry);
        }
    }

    public static ModuleFinder of(ModulePatcher patcher, Path ... entries) {
        return new ModulePath(JarFile.runtimeVersion(), false, patcher, entries);
    }

    public static ModuleFinder of(Path ... entries) {
        return ModulePath.of((ModulePatcher)null, entries);
    }

    public static ModuleFinder of(Runtime.Version version, boolean isLinkPhase, Path ... entries) {
        return new ModulePath(version, isLinkPhase, null, entries);
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        Objects.requireNonNull(name);
        ModuleReference m = this.cachedModules.get(name);
        if (m != null) {
            return Optional.of(m);
        }
        while (this.hasNextEntry()) {
            this.scanNextEntry();
            m = this.cachedModules.get(name);
            if (m == null) continue;
            return Optional.of(m);
        }
        return Optional.empty();
    }

    @Override
    public Set<ModuleReference> findAll() {
        while (this.hasNextEntry()) {
            this.scanNextEntry();
        }
        return this.cachedModules.values().stream().collect(Collectors.toSet());
    }

    private boolean hasNextEntry() {
        return this.next < this.entries.length;
    }

    private void scanNextEntry() {
        if (this.hasNextEntry()) {
            long t0 = System.nanoTime();
            Path entry = this.entries[this.next];
            Map<String, ModuleReference> modules = this.scan(entry);
            ++this.next;
            int initialSize = this.cachedModules.size();
            for (Map.Entry<String, ModuleReference> e : modules.entrySet()) {
                this.cachedModules.putIfAbsent(e.getKey(), e.getValue());
            }
            int added = this.cachedModules.size() - initialSize;
            moduleCount.add(added);
            scanTime.addElapsedTimeFrom(t0);
        }
    }

    private Map<String, ModuleReference> scan(Path entry) {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            return Map.of();
        }
        catch (IOException ioe) {
            throw new FindException(ioe);
        }
        try {
            Path mi;
            if (attrs.isDirectory() && !Files.exists(mi = entry.resolve(MODULE_INFO), new LinkOption[0])) {
                return this.scanDirectory(entry);
            }
            ModuleReference mref = this.readModule(entry, attrs);
            if (mref != null) {
                String name = mref.descriptor().name();
                return Map.of(name, mref);
            }
            String msg = !this.isLinkPhase && entry.toString().endsWith(".jmod") ? "JMOD format not supported at execution time" : "Module format not recognized";
            throw new FindException(msg + ": " + entry);
        }
        catch (IOException ioe) {
            throw new FindException(ioe);
        }
    }

    private Map<String, ModuleReference> scanDirectory(Path dir) throws IOException {
        HashMap<String, ModuleReference> nameToReference = new HashMap<String, ModuleReference>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path entry : stream) {
                String name;
                ModuleReference previous;
                BasicFileAttributes attrs;
                try {
                    attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (NoSuchFileException ignore) {
                    continue;
                }
                ModuleReference mref = this.readModule(entry, attrs);
                if (mref == null || (previous = nameToReference.put(name = mref.descriptor().name(), mref)) == null) continue;
                String fn1 = this.fileName(mref);
                String fn2 = this.fileName(previous);
                throw new FindException("Two versions of module " + name + " found in " + dir + " (" + fn1 + " and " + fn2 + ")");
            }
        }
        return nameToReference;
    }

    private ModuleReference readModule(Path entry, BasicFileAttributes attrs) throws IOException {
        try {
            if (attrs.isDirectory()) {
                return this.readExplodedModule(entry);
            }
            if (attrs.isRegularFile()) {
                String fn = entry.getFileName().toString();
                boolean isDefaultFileSystem = this.isDefaultFileSystem(entry);
                if (fn.endsWith(".jar")) {
                    if (isDefaultFileSystem) {
                        return this.readJar(entry);
                    }
                    Path tmpdir = Files.createTempDirectory("mlib", new FileAttribute[0]);
                    Path target = Files.copy(entry, tmpdir.resolve(fn), new CopyOption[0]);
                    return this.readJar(target);
                }
                if (isDefaultFileSystem && this.isLinkPhase && fn.endsWith(".jmod")) {
                    return this.readJMod(entry);
                }
            }
            return null;
        }
        catch (InvalidModuleDescriptorException e) {
            throw new FindException("Error reading module: " + entry, e);
        }
    }

    private String fileName(ModuleReference mref) {
        URI uri = mref.location().orElse(null);
        if (uri != null) {
            if (uri.getScheme().equalsIgnoreCase("file")) {
                Path file = Path.of(uri);
                return file.getFileName().toString();
            }
            return uri.toString();
        }
        return "<unknown>";
    }

    private Set<String> jmodPackages(JmodFile jf) {
        return jf.stream().filter(e -> e.section() == JmodFile.Section.CLASSES).map(JmodFile.Entry::name).map(this::toPackageName).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    private ModuleReference readJMod(Path file) throws IOException {
        try (JmodFile jf = new JmodFile(file);){
            ModuleInfo.Attributes attrs;
            try (InputStream in = jf.getInputStream(JmodFile.Section.CLASSES, MODULE_INFO);){
                attrs = ModuleInfo.read(in, () -> this.jmodPackages(jf));
            }
            ModuleReference moduleReference = ModuleReferences.newJModModule(attrs, file);
            return moduleReference;
        }
    }

    private Optional<String> toServiceName(String cf) {
        String sn;
        String prefix;
        assert (cf.startsWith(SERVICES_PREFIX));
        int index = cf.lastIndexOf("/") + 1;
        if (index < cf.length() && (prefix = cf.substring(0, index)).equals(SERVICES_PREFIX) && Checks.isClassName(sn = cf.substring(index))) {
            return Optional.of(sn);
        }
        return Optional.empty();
    }

    private String nextLine(BufferedReader reader) throws IOException {
        String ln = reader.readLine();
        if (ln != null) {
            int ci = ln.indexOf(35);
            if (ci >= 0) {
                ln = ln.substring(0, ci);
            }
            ln = ln.trim();
        }
        return ln;
    }

    private ModuleDescriptor deriveModuleDescriptor(JarFile jf) throws IOException {
        String pn;
        String mainClass;
        ModuleDescriptor.Builder builder;
        String fn;
        int i;
        Manifest man = jf.getManifest();
        Attributes attrs = null;
        String moduleName = null;
        if (man != null && (attrs = man.getMainAttributes()) != null) {
            moduleName = attrs.getValue(AUTOMATIC_MODULE_NAME);
        }
        if ((i = (fn = jf.getName()).lastIndexOf(File.separator)) != -1) {
            fn = fn.substring(i + 1);
        }
        String name = fn.substring(0, fn.length() - 4);
        String vs = null;
        Matcher matcher = Patterns.DASH_VERSION.matcher(name);
        if (matcher.find()) {
            int start = matcher.start();
            try {
                String tail = name.substring(start + 1);
                ModuleDescriptor.Version.parse(tail);
                vs = tail;
            }
            catch (IllegalArgumentException tail) {
                // empty catch block
            }
            name = name.substring(0, start);
        }
        if (moduleName != null) {
            try {
                builder = ModuleDescriptor.newAutomaticModule(moduleName);
            }
            catch (IllegalArgumentException e2) {
                throw new FindException(AUTOMATIC_MODULE_NAME + ": " + e2.getMessage());
            }
        } else {
            builder = ModuleDescriptor.newAutomaticModule(ModulePath.cleanModuleName(name));
        }
        if (vs != null) {
            builder.version(vs);
        }
        Map map = jf.versionedStream().filter(e -> !e.isDirectory()).map(ZipEntry::getName).filter(e -> e.endsWith(".class") ^ e.startsWith(SERVICES_PREFIX)).collect(Collectors.partitioningBy(e -> e.startsWith(SERVICES_PREFIX), Collectors.toSet()));
        Set classFiles = map.get(Boolean.FALSE);
        Set configFiles = map.get(Boolean.TRUE);
        Set<String> packages = classFiles.stream().map(this::toPackageName).flatMap(Optional::stream).distinct().collect(Collectors.toSet());
        builder.packages(packages);
        Set serviceNames = configFiles.stream().map(this::toServiceName).flatMap(Optional::stream).collect(Collectors.toSet());
        for (String sn : serviceNames) {
            JarEntry entry = jf.getJarEntry(SERVICES_PREFIX + sn);
            ArrayList<String> providerClasses = new ArrayList<String>();
            try (InputStream in = jf.getInputStream(entry);){
                String cn;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, UTF_8.INSTANCE));
                while ((cn = this.nextLine(reader)) != null) {
                    if (cn.isEmpty()) continue;
                    String pn2 = ModulePath.packageName(cn);
                    if (!packages.contains(pn2)) {
                        String msg = "Provider class " + cn + " not in module";
                        throw new InvalidModuleDescriptorException(msg);
                    }
                    providerClasses.add(cn);
                }
            }
            if (providerClasses.isEmpty()) continue;
            builder.provides(sn, providerClasses);
        }
        if (attrs != null && (mainClass = attrs.getValue(Attributes.Name.MAIN_CLASS)) != null && Checks.isClassName(mainClass = mainClass.replace('/', '.')) && packages.contains(pn = ModulePath.packageName(mainClass))) {
            builder.mainClass(mainClass);
        }
        return builder.build();
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = Patterns.NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = Patterns.REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = Patterns.LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = Patterns.TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        return mn;
    }

    private Set<String> jarPackages(JarFile jf) {
        return jf.versionedStream().filter(e -> !e.isDirectory()).map(ZipEntry::getName).map(this::toPackageName).flatMap(Optional::stream).collect(Collectors.toSet());
    }

    private ModuleReference readJar(Path file) throws IOException {
        ModuleReference moduleReference;
        JarFile jf = new JarFile(file.toFile(), true, 1, this.releaseVersion);
        try {
            ModuleInfo.Attributes attrs;
            JarEntry entry = jf.getJarEntry(MODULE_INFO);
            if (entry == null) {
                try {
                    ModuleDescriptor md = this.deriveModuleDescriptor(jf);
                    attrs = new ModuleInfo.Attributes(md, null, null, null);
                }
                catch (RuntimeException e) {
                    throw new FindException("Unable to derive module descriptor for " + jf.getName(), e);
                }
            } else {
                attrs = ModuleInfo.read(jf.getInputStream(entry), () -> this.jarPackages(jf));
            }
            moduleReference = ModuleReferences.newJarModule(attrs, this.patcher, file);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ZipException e) {
                throw new FindException("Error reading " + file, e);
            }
        }
        jf.close();
        return moduleReference;
    }

    private Set<String> explodedPackages(Path dir) {
        try {
            return Files.find(dir, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile() && !this.isHidden((Path)path), new FileVisitOption[0]).map(path -> dir.relativize((Path)path)).map(this::toPackageName).flatMap(Optional::stream).collect(Collectors.toSet());
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    private ModuleReference readExplodedModule(Path dir) throws IOException {
        ModuleInfo.Attributes attrs;
        Path mi = dir.resolve(MODULE_INFO);
        try (InputStream in = Files.newInputStream(mi, new OpenOption[0]);){
            attrs = ModuleInfo.read(new BufferedInputStream(in), () -> this.explodedPackages(dir));
        }
        catch (NoSuchFileException e) {
            return null;
        }
        return ModuleReferences.newExplodedModule(attrs, this.patcher, dir);
    }

    private static String packageName(String cn) {
        int index = cn.lastIndexOf(46);
        return index == -1 ? "" : cn.substring(0, index);
    }

    private Optional<String> toPackageName(String name) {
        assert (!name.endsWith("/"));
        int index = name.lastIndexOf("/");
        if (index == -1) {
            if (name.endsWith(".class") && !name.equals(MODULE_INFO)) {
                String msg = name + " found in top-level directory (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = name.substring(0, index).replace('/', '.');
        if (Checks.isPackageName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    private Optional<String> toPackageName(Path file) {
        assert (file.getRoot() == null);
        Path parent = file.getParent();
        if (parent == null) {
            String name = file.toString();
            if (name.endsWith(".class") && !name.equals(MODULE_INFO)) {
                String msg = name + " found in top-level directory (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = parent.toString().replace(File.separatorChar, '.');
        if (Checks.isPackageName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    private boolean isHidden(Path file) {
        try {
            return Files.isHidden(file);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean isDefaultFileSystem(Path path) {
        return path.getFileSystem().provider().getScheme().equalsIgnoreCase("file");
    }

    private static class Patterns {
        static final Pattern DASH_VERSION = Pattern.compile("-(\\d+(\\.|$))");
        static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
        static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
        static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
        static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");

        private Patterns() {
        }
    }
}

