/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

class ModulePathValidator {
    private static final String MODULE_INFO = "module-info.class";
    private static final String INDENT = "    ";
    private final Map<String, ModuleReference> nameToModule = new HashMap<String, ModuleReference>();
    private final Map<String, ModuleReference> packageToModule = new HashMap<String, ModuleReference>();
    private final PrintStream out;
    private int errorCount;

    private ModulePathValidator(PrintStream out) {
        this.out = out;
    }

    static int scanAllModules(PrintStream out) {
        ModulePathValidator validator = new ModulePathValidator(out);
        String value = System.getProperty("jdk.module.upgrade.path");
        if (value != null) {
            Stream.of(value.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).forEach(validator::scan);
        }
        ModuleFinder.ofSystem().findAll().stream().sorted(Comparator.comparing(ModuleReference::descriptor)).forEach(validator::process);
        value = System.getProperty("jdk.module.path");
        if (value != null) {
            Stream.of(value.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).forEach(validator::scan);
        }
        return validator.errorCount;
    }

    private void printModule(ModuleReference mref) {
        mref.location().filter(uri -> !ModulePathValidator.isJrt(uri)).ifPresent(uri -> this.out.print(uri + " "));
        ModuleDescriptor descriptor = mref.descriptor();
        this.out.print(descriptor.name());
        if (descriptor.isAutomatic()) {
            this.out.print(" automatic");
        }
        this.out.println();
    }

    private void process(ModuleReference mref) {
        String name = mref.descriptor().name();
        ModuleReference previous = this.nameToModule.putIfAbsent(name, mref);
        if (previous != null) {
            this.printModule(mref);
            this.out.print("    shadowed by ");
            this.printModule(previous);
        } else {
            boolean first = true;
            for (String pkg : mref.descriptor().packages()) {
                previous = this.packageToModule.putIfAbsent(pkg, mref);
                if (previous == null) continue;
                if (first) {
                    this.printModule(mref);
                    first = false;
                    ++this.errorCount;
                }
                String mn = previous.descriptor().name();
                this.out.println("    contains " + pkg + " conflicts with module " + mn);
            }
        }
    }

    private void scan(Path entry) {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignore) {
            return;
        }
        catch (IOException ioe) {
            this.out.println(entry + " " + ioe);
            ++this.errorCount;
            return;
        }
        String fn = entry.getFileName().toString();
        if (attrs.isRegularFile() && fn.endsWith(".jar")) {
            this.scanModule(entry).ifPresent(this::process);
        } else if (attrs.isDirectory()) {
            Path mi = entry.resolve(MODULE_INFO);
            if (Files.exists(mi, new LinkOption[0])) {
                this.scanModule(entry).ifPresent(this::process);
            } else {
                this.scanDirectory(entry);
            }
        }
    }

    private void scanDirectory(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            HashMap<String, Path> moduleToEntry = new HashMap<String, Path>();
            for (Path entry : stream) {
                Path mi;
                BasicFileAttributes attrs;
                try {
                    attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (IOException ioe) {
                    this.out.println(entry + " " + ioe);
                    ++this.errorCount;
                    continue;
                }
                ModuleReference mref = null;
                String fn = entry.getFileName().toString();
                if (attrs.isRegularFile() && fn.endsWith(".jar")) {
                    mref = this.scanModule(entry).orElse(null);
                } else if (attrs.isDirectory() && Files.exists(mi = entry.resolve(MODULE_INFO), new LinkOption[0])) {
                    mref = this.scanModule(entry).orElse(null);
                }
                if (mref == null) continue;
                String name = mref.descriptor().name();
                Path previous = moduleToEntry.putIfAbsent(name, entry);
                if (previous != null) {
                    this.printModule(mref);
                    this.out.println("    contains same module as " + previous.getFileName());
                    ++this.errorCount;
                    continue;
                }
                this.process(mref);
            }
        }
        catch (IOException ioe) {
            this.out.println(dir + " " + ioe);
            ++this.errorCount;
        }
    }

    private Optional<ModuleReference> scanModule(Path entry) {
        ModuleFinder finder = ModuleFinder.of(entry);
        try {
            return finder.findAll().stream().findFirst();
        }
        catch (FindException e) {
            this.out.println(entry);
            this.out.println(INDENT + e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                this.out.println(INDENT + cause);
            }
            ++this.errorCount;
            return Optional.empty();
        }
    }

    private static boolean isJrt(URI uri) {
        return uri != null && uri.getScheme().equalsIgnoreCase("jrt");
    }
}

