/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModulePatcher;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;

public class ModuleReferenceImpl
extends ModuleReference {
    private final URI location;
    private final Supplier<ModuleReader> readerSupplier;
    private final ModulePatcher patcher;
    private final ModuleTarget target;
    private final ModuleHashes recordedHashes;
    private final ModuleHashes.HashSupplier hasher;
    private final ModuleResolution moduleResolution;
    private byte[] cachedHash;
    private int hash;

    public ModuleReferenceImpl(ModuleDescriptor descriptor, URI location, Supplier<ModuleReader> readerSupplier, ModulePatcher patcher, ModuleTarget target, ModuleHashes recordedHashes, ModuleHashes.HashSupplier hasher, ModuleResolution moduleResolution) {
        super(descriptor, Objects.requireNonNull(location));
        this.location = location;
        this.readerSupplier = readerSupplier;
        this.patcher = patcher;
        this.target = target;
        this.recordedHashes = recordedHashes;
        this.hasher = hasher;
        this.moduleResolution = moduleResolution;
    }

    @Override
    public ModuleReader open() throws IOException {
        try {
            return this.readerSupplier.get();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public boolean isPatched() {
        return this.patcher != null;
    }

    public ModuleTarget moduleTarget() {
        return this.target;
    }

    public ModuleHashes recordedHashes() {
        return this.recordedHashes;
    }

    ModuleHashes.HashSupplier hasher() {
        return this.hasher;
    }

    public ModuleResolution moduleResolution() {
        return this.moduleResolution;
    }

    public byte[] computeHash(String algorithm) {
        byte[] result = this.cachedHash;
        if (result != null) {
            return result;
        }
        if (this.hasher == null) {
            return null;
        }
        this.cachedHash = result = this.hasher.generate(algorithm);
        return result;
    }

    public int hashCode() {
        int hc = this.hash;
        if (hc == 0) {
            hc = this.descriptor().hashCode();
            hc = 43 * hc + Objects.hashCode(this.location);
            if ((hc = 43 * hc + Objects.hashCode(this.patcher)) == 0) {
                hc = -1;
            }
            this.hash = hc;
        }
        return hc;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof ModuleReferenceImpl)) {
            return false;
        }
        ModuleReferenceImpl that = (ModuleReferenceImpl)ob;
        return Objects.equals(this.descriptor(), that.descriptor()) && Objects.equals(this.location, that.location) && Objects.equals(this.patcher, that.patcher);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[module ");
        sb.append(this.descriptor().name());
        sb.append(", location=");
        sb.append(this.location);
        if (this.isPatched()) {
            sb.append(" (patched)");
        }
        sb.append("]");
        return sb.toString();
    }
}

