/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import jdk.internal.jmod.JmodFile;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleInfo;
import jdk.internal.module.ModulePatcher;
import jdk.internal.module.ModuleReferenceImpl;
import jdk.internal.module.Resources;
import sun.net.www.ParseUtil;

class ModuleReferences {
    private ModuleReferences() {
    }

    private static ModuleReference newModule(ModuleInfo.Attributes attrs, URI uri, Supplier<ModuleReader> supplier, ModulePatcher patcher, ModuleHashes.HashSupplier hasher) {
        ModuleReference mref = new ModuleReferenceImpl(attrs.descriptor(), uri, supplier, null, attrs.target(), attrs.recordedHashes(), hasher, attrs.moduleResolution());
        if (patcher != null) {
            mref = patcher.patchIfNeeded(mref);
        }
        return mref;
    }

    static ModuleReference newJarModule(ModuleInfo.Attributes attrs, ModulePatcher patcher, Path file) {
        URI uri = file.toUri();
        Supplier<ModuleReader> supplier = () -> new JarModuleReader(file, uri);
        ModuleHashes.HashSupplier hasher = a -> ModuleHashes.computeHash(supplier, a);
        return ModuleReferences.newModule(attrs, uri, supplier, patcher, hasher);
    }

    static ModuleReference newJModModule(ModuleInfo.Attributes attrs, Path file) {
        URI uri = file.toUri();
        Supplier<ModuleReader> supplier = () -> new JModModuleReader(file, uri);
        ModuleHashes.HashSupplier hasher = a -> ModuleHashes.computeHash(supplier, a);
        return ModuleReferences.newModule(attrs, uri, supplier, null, hasher);
    }

    static ModuleReference newExplodedModule(ModuleInfo.Attributes attrs, ModulePatcher patcher, Path dir) {
        Supplier<ModuleReader> supplier = () -> new ExplodedModuleReader(dir);
        return ModuleReferences.newModule(attrs, dir.toUri(), supplier, patcher, null);
    }

    static class ExplodedModuleReader
    implements ModuleReader {
        private final Path dir;
        private volatile boolean closed;

        ExplodedModuleReader(Path dir) {
            this.dir = dir;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                boolean bl = Files.isDirectory(dir, new LinkOption[0]);
            }
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("ModuleReader is closed");
            }
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            this.ensureOpen();
            Path path = Resources.toFilePath(this.dir, name);
            if (path != null) {
                try {
                    return Optional.of(path.toUri());
                }
                catch (IOError e) {
                    throw (IOException)e.getCause();
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            this.ensureOpen();
            Path path = Resources.toFilePath(this.dir, name);
            if (path != null) {
                return Optional.of(Files.newInputStream(path, new OpenOption[0]));
            }
            return Optional.empty();
        }

        @Override
        public Optional<ByteBuffer> read(String name) throws IOException {
            this.ensureOpen();
            Path path = Resources.toFilePath(this.dir, name);
            if (path != null) {
                return Optional.of(ByteBuffer.wrap(Files.readAllBytes(path)));
            }
            return Optional.empty();
        }

        @Override
        public Stream<String> list() throws IOException {
            this.ensureOpen();
            return Files.walk(this.dir, Integer.MAX_VALUE, new FileVisitOption[0]).map(f -> Resources.toResourceName(this.dir, f)).filter(s -> s.length() > 0);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }

    static class JModModuleReader
    extends SafeCloseModuleReader {
        private final JmodFile jf;
        private final URI uri;

        static JmodFile newJmodFile(Path path) {
            try {
                return new JmodFile(path);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }

        JModModuleReader(Path path, URI uri) {
            this.jf = JModModuleReader.newJmodFile(path);
            this.uri = uri;
        }

        private JmodFile.Entry getEntry(String name) {
            Objects.requireNonNull(name);
            return this.jf.getEntry(JmodFile.Section.CLASSES, name);
        }

        @Override
        Optional<URI> implFind(String name) {
            JmodFile.Entry je = this.getEntry(name);
            if (je != null) {
                if (je.isDirectory() && !name.endsWith("/")) {
                    name = name + "/";
                }
                String encodedPath = ParseUtil.encodePath(name, false);
                String uris = "jmod:" + this.uri + "!/" + encodedPath;
                return Optional.of(URI.create(uris));
            }
            return Optional.empty();
        }

        @Override
        Optional<InputStream> implOpen(String name) throws IOException {
            JmodFile.Entry je = this.getEntry(name);
            if (je != null) {
                return Optional.of(this.jf.getInputStream(je));
            }
            return Optional.empty();
        }

        @Override
        Stream<String> implList() throws IOException {
            List<String> names = this.jf.stream().filter(e -> e.section() == JmodFile.Section.CLASSES).map(JmodFile.Entry::name).toList();
            return names.stream();
        }

        @Override
        void implClose() throws IOException {
            this.jf.close();
        }
    }

    static class JarModuleReader
    extends SafeCloseModuleReader {
        private final JarFile jf;
        private final URI uri;

        static JarFile newJarFile(Path path) {
            try {
                return new JarFile(new File(path.toString()), true, 1, JarFile.runtimeVersion());
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }

        JarModuleReader(Path path, URI uri) {
            this.jf = JarModuleReader.newJarFile(path);
            this.uri = uri;
        }

        private JarEntry getEntry(String name) {
            return this.jf.getJarEntry(Objects.requireNonNull(name));
        }

        @Override
        Optional<URI> implFind(String name) throws IOException {
            JarEntry je = this.getEntry(name);
            if (je != null) {
                if (this.jf.isMultiRelease()) {
                    name = je.getRealName();
                }
                if (je.isDirectory() && !name.endsWith("/")) {
                    name = name + "/";
                }
                String encodedPath = ParseUtil.encodePath(name, false);
                String uris = "jar:" + this.uri + "!/" + encodedPath;
                return Optional.of(URI.create(uris));
            }
            return Optional.empty();
        }

        @Override
        Optional<InputStream> implOpen(String name) throws IOException {
            JarEntry je = this.getEntry(name);
            if (je != null) {
                return Optional.of(this.jf.getInputStream(je));
            }
            return Optional.empty();
        }

        @Override
        Stream<String> implList() throws IOException {
            List<String> names = this.jf.versionedStream().map(ZipEntry::getName).toList();
            return names.stream();
        }

        @Override
        void implClose() throws IOException {
            this.jf.close();
        }
    }

    static abstract class SafeCloseModuleReader
    implements ModuleReader {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();
        private boolean closed;

        SafeCloseModuleReader() {
        }

        abstract Optional<URI> implFind(String var1) throws IOException;

        abstract Optional<InputStream> implOpen(String var1) throws IOException;

        abstract Stream<String> implList() throws IOException;

        abstract void implClose() throws IOException;

        @Override
        public final Optional<URI> find(String name) throws IOException {
            this.readLock.lock();
            try {
                if (!this.closed) {
                    Optional<URI> optional = this.implFind(name);
                    return optional;
                }
                throw new IOException("ModuleReader is closed");
            }
            finally {
                this.readLock.unlock();
            }
        }

        @Override
        public final Optional<InputStream> open(String name) throws IOException {
            this.readLock.lock();
            try {
                if (!this.closed) {
                    Optional<InputStream> optional = this.implOpen(name);
                    return optional;
                }
                throw new IOException("ModuleReader is closed");
            }
            finally {
                this.readLock.unlock();
            }
        }

        @Override
        public final Stream<String> list() throws IOException {
            this.readLock.lock();
            try {
                if (!this.closed) {
                    Stream<String> stream = this.implList();
                    return stream;
                }
                throw new IOException("ModuleReader is closed");
            }
            finally {
                this.readLock.unlock();
            }
        }

        @Override
        public final void close() throws IOException {
            this.writeLock.lock();
            try {
                if (!this.closed) {
                    this.closed = true;
                    this.implClose();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

