/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.ModuleReference;
import jdk.internal.module.ModuleReferenceImpl;

public final class ModuleResolution {
    final int value;

    ModuleResolution(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ModuleResolution empty() {
        return new ModuleResolution(0);
    }

    public boolean doNotResolveByDefault() {
        return (this.value & 1) != 0;
    }

    public boolean hasDeprecatedWarning() {
        return (this.value & 2) != 0;
    }

    public boolean hasDeprecatedForRemovalWarning() {
        return (this.value & 4) != 0;
    }

    public boolean hasIncubatingWarning() {
        return (this.value & 8) != 0;
    }

    public ModuleResolution withDoNotResolveByDefault() {
        return new ModuleResolution(this.value | 1);
    }

    public ModuleResolution withDeprecated() {
        if ((this.value & 0xC) != 0) {
            throw new InternalError("cannot add deprecated to " + this.value);
        }
        return new ModuleResolution(this.value | 2);
    }

    public ModuleResolution withDeprecatedForRemoval() {
        if ((this.value & 0xA) != 0) {
            throw new InternalError("cannot add deprecated for removal to " + this.value);
        }
        return new ModuleResolution(this.value | 4);
    }

    public ModuleResolution withIncubating() {
        if ((this.value & 6) != 0) {
            throw new InternalError("cannot add incubating to " + this.value);
        }
        return new ModuleResolution(this.value | 8);
    }

    public static boolean doNotResolveByDefault(ModuleReference mref) {
        ModuleResolution mres;
        if (mref instanceof ModuleReferenceImpl && (mres = ((ModuleReferenceImpl)mref).moduleResolution()) != null) {
            return mres.doNotResolveByDefault();
        }
        return false;
    }

    public static boolean hasIncubatingWarning(ModuleReference mref) {
        ModuleResolution mres;
        if (mref instanceof ModuleReferenceImpl && (mres = ((ModuleReferenceImpl)mref).moduleResolution()) != null) {
            return mres.hasIncubatingWarning();
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[value=" + this.value + "]";
    }
}

