/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import jdk.internal.module.Checks;

public final class Resources {
    private Resources() {
    }

    public static boolean canEncapsulate(String name) {
        int len = name.length();
        if (len > 6 && name.endsWith(".class")) {
            return false;
        }
        return Checks.isPackageName(Resources.toPackageName(name));
    }

    public static String toPackageName(String name) {
        int index = name.lastIndexOf(47);
        if (index == -1 || index == name.length() - 1) {
            return "";
        }
        return name.substring(0, index).replace('/', '.');
    }

    public static String toResourceName(Path dir, Path file) {
        String s = dir.relativize(file).toString().replace(File.separatorChar, '/');
        if (!s.isEmpty() && Files.isDirectory(file, new LinkOption[0])) {
            s = s + "/";
        }
        return s;
    }

    public static Path toFilePath(Path dir, String name) throws IOException {
        Path path;
        boolean expectDirectory = name.endsWith("/");
        if (expectDirectory) {
            name = name.substring(0, name.length() - 1);
        }
        if ((path = Resources.toSafeFilePath(dir.getFileSystem(), name)) != null) {
            Path file = dir.resolve(path);
            try {
                BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isDirectory() || !attrs.isDirectory() && !expectDirectory) {
                    return file;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Path toSafeFilePath(FileSystem fs, String name) {
        Path path;
        int next;
        int off = 0;
        while ((next = name.indexOf(47, off)) != -1) {
            int len = next - off;
            if (!Resources.mayTranslate(name, off, len)) {
                return null;
            }
            off = next + 1;
        }
        int rem = name.length() - off;
        if (!Resources.mayTranslate(name, off, rem)) {
            return null;
        }
        if (File.separatorChar == '/') {
            path = fs.getPath(name, new String[0]);
        } else {
            if (name.contains(File.separator)) {
                return null;
            }
            path = fs.getPath(name.replace('/', File.separatorChar), new String[0]);
        }
        return path.getRoot() == null ? path : null;
    }

    private static boolean mayTranslate(String name, int off, int len) {
        if (len <= 2) {
            boolean starsWithDot;
            if (len == 0) {
                return false;
            }
            boolean bl = starsWithDot = name.charAt(off) == '.';
            if (len == 1 && starsWithDot) {
                return false;
            }
            if (len == 2 && starsWithDot && name.charAt(off + 1) == '.') {
                return false;
            }
        }
        return true;
    }
}

