/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.lang.module.ModuleDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jdk.internal.loader.ClassLoaderValue;

public final class ServicesCatalog {
    private final Map<String, List<ServiceProvider>> map = new ConcurrentHashMap<String, List<ServiceProvider>>(32);
    private static final ClassLoaderValue<ServicesCatalog> CLV = new ClassLoaderValue();

    private ServicesCatalog() {
    }

    public static ServicesCatalog create() {
        return new ServicesCatalog();
    }

    private void addProviders(String service, ServiceProvider ... providers) {
        List<ServiceProvider> list = this.map.get(service);
        if (list == null) {
            list = new CopyOnWriteArrayList<ServiceProvider>(providers);
            List<ServiceProvider> prev = this.map.putIfAbsent(service, list);
            if (prev != null) {
                prev.addAll(list);
            }
        } else if (providers.length == 1) {
            list.add(providers[0]);
        } else {
            list.addAll(Arrays.asList(providers));
        }
    }

    public void register(Module module) {
        ModuleDescriptor descriptor = module.getDescriptor();
        for (ModuleDescriptor.Provides provides : descriptor.provides()) {
            String service = provides.service();
            List<String> providerNames = provides.providers();
            int count = providerNames.size();
            ServiceProvider[] providers = new ServiceProvider[count];
            for (int i = 0; i < count; ++i) {
                providers[i] = new ServiceProvider(module, providerNames.get(i));
            }
            this.addProviders(service, providers);
        }
    }

    public void addProvider(Module module, Class<?> service, Class<?> impl) {
        this.addProviders(service.getName(), new ServiceProvider(module, impl.getName()));
    }

    public List<ServiceProvider> findServices(String service) {
        return this.map.getOrDefault(service, List.of());
    }

    public static ServicesCatalog getServicesCatalogOrNull(ClassLoader loader) {
        return (ServicesCatalog)CLV.get(loader);
    }

    public static ServicesCatalog getServicesCatalog(ClassLoader loader) {
        ServicesCatalog previous;
        ServicesCatalog catalog = (ServicesCatalog)CLV.get(loader);
        if (catalog == null && (previous = CLV.putIfAbsent(loader, catalog = ServicesCatalog.create())) != null) {
            catalog = previous;
        }
        return catalog;
    }

    public static void putServicesCatalog(ClassLoader loader, ServicesCatalog catalog) {
        ServicesCatalog previous = CLV.putIfAbsent(loader, catalog);
        if (previous != null) {
            throw new InternalError();
        }
    }

    public static final class ServiceProvider {
        private final Module module;
        private final String providerName;

        public ServiceProvider(Module module, String providerName) {
            this.module = module;
            this.providerName = providerName;
        }

        public Module module() {
            return this.module;
        }

        public String providerName() {
            return this.providerName;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.providerName);
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof ServiceProvider)) {
                return false;
            }
            ServiceProvider that = (ServiceProvider)ob;
            return Objects.equals(this.module, that.module) && Objects.equals(this.providerName, that.providerName);
        }
    }
}

