/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.module;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.access.JavaNetUriAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.jimage.ImageLocation;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jimage.ImageReaderFactory;
import jdk.internal.module.ModuleBootstrap;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleInfo;
import jdk.internal.module.ModulePath;
import jdk.internal.module.ModuleReferenceImpl;
import jdk.internal.module.ModuleResolution;
import jdk.internal.module.ModuleTarget;
import jdk.internal.module.SystemModules;
import jdk.internal.module.SystemModulesMap;
import jdk.internal.util.StaticProperty;

public final class SystemModuleFinders {
    private static final JavaNetUriAccess JNUA = SharedSecrets.getJavaNetUriAccess();
    private static final boolean USE_FAST_PATH;
    private static volatile ModuleFinder cachedSystemModuleFinder;

    private SystemModuleFinders() {
    }

    static SystemModules allSystemModules() {
        if (USE_FAST_PATH) {
            return SystemModulesMap.allSystemModules();
        }
        return null;
    }

    static SystemModules systemModules(String initialModule) {
        if (USE_FAST_PATH) {
            if (initialModule == null) {
                return SystemModulesMap.defaultSystemModules();
            }
            String[] initialModules = SystemModulesMap.moduleNames();
            for (int i = 0; i < initialModules.length; ++i) {
                String moduleName = initialModules[i];
                if (!initialModule.equals(moduleName)) continue;
                String cn = SystemModulesMap.classNames()[i];
                try {
                    Constructor<?> ctor = Class.forName(cn).getConstructor(new Class[0]);
                    return (SystemModules)ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new InternalError(e);
                }
            }
        }
        return null;
    }

    static ModuleFinder of(SystemModules systemModules) {
        ModuleDescriptor[] descriptors = systemModules.moduleDescriptors();
        ModuleTarget[] targets = systemModules.moduleTargets();
        ModuleHashes[] recordedHashes = systemModules.moduleHashes();
        ModuleResolution[] moduleResolutions = systemModules.moduleResolutions();
        int moduleCount = descriptors.length;
        ModuleReference[] mrefs = new ModuleReference[moduleCount];
        Map.Entry[] map = new Map.Entry[moduleCount];
        Map<String, byte[]> nameToHash = SystemModuleFinders.generateNameToHash(recordedHashes);
        for (int i = 0; i < moduleCount; ++i) {
            ModuleReference mref;
            String name = descriptors[i].name();
            ModuleHashes.HashSupplier hashSupplier = SystemModuleFinders.hashSupplier(nameToHash, name);
            mrefs[i] = mref = SystemModuleFinders.toModuleReference(descriptors[i], targets[i], recordedHashes[i], hashSupplier, moduleResolutions[i]);
            map[i] = Map.entry(name, mref);
        }
        return new SystemModuleFinder(mrefs, map);
    }

    public static ModuleFinder ofSystem() {
        ModuleFinder finder = cachedSystemModuleFinder;
        if (finder != null) {
            return finder;
        }
        String home = StaticProperty.javaHome();
        Path modules = Path.of(home, "lib", "modules");
        if (Files.isRegularFile(modules, new LinkOption[0])) {
            SystemModules systemModules;
            if (USE_FAST_PATH && (systemModules = SystemModuleFinders.allSystemModules()) != null) {
                finder = SystemModuleFinders.of(systemModules);
            }
            if (finder == null) {
                finder = SystemModuleFinders.ofModuleInfos();
            }
            cachedSystemModuleFinder = finder;
            return finder;
        }
        Path dir = Path.of(home, "modules");
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new InternalError("Unable to detect the run-time image");
        }
        final ModuleFinder f = ModulePath.of(ModuleBootstrap.patcher(), dir);
        return new ModuleFinder(){

            @Override
            public Optional<ModuleReference> find(String name) {
                PrivilegedAction<Optional> pa = () -> f.find(name);
                return AccessController.doPrivileged(pa);
            }

            @Override
            public Set<ModuleReference> findAll() {
                PrivilegedAction<Set> pa = f::findAll;
                return AccessController.doPrivileged(pa);
            }
        };
    }

    private static ModuleFinder ofModuleInfos() {
        ModuleInfo.Attributes attrs;
        HashMap<String, ModuleInfo.Attributes> nameToAttributes = new HashMap<String, ModuleInfo.Attributes>();
        HashMap<String, byte[]> nameToHash = new HashMap<String, byte[]>();
        ImageReader reader = SystemImage.reader();
        for (String mn : reader.getModuleNames()) {
            ImageLocation loc = reader.findLocation(mn, "module-info.class");
            attrs = ModuleInfo.read(reader.getResourceBuffer(loc), null);
            nameToAttributes.put(mn, attrs);
            ModuleHashes hashes = attrs.recordedHashes();
            if (hashes == null) continue;
            for (String name : hashes.names()) {
                nameToHash.computeIfAbsent(name, k -> hashes.hashFor(name));
            }
        }
        HashSet<ModuleReference> mrefs = new HashSet<ModuleReference>();
        HashMap<String, ModuleReference> nameToModule = new HashMap<String, ModuleReference>();
        for (Map.Entry e : nameToAttributes.entrySet()) {
            String mn = (String)e.getKey();
            attrs = (ModuleInfo.Attributes)e.getValue();
            ModuleHashes.HashSupplier hashSupplier = SystemModuleFinders.hashSupplier(nameToHash, mn);
            ModuleReference mref = SystemModuleFinders.toModuleReference(attrs.descriptor(), attrs.target(), attrs.recordedHashes(), hashSupplier, attrs.moduleResolution());
            mrefs.add(mref);
            nameToModule.put(mn, mref);
        }
        return new SystemModuleFinder(mrefs, nameToModule);
    }

    static ModuleReference toModuleReference(ModuleDescriptor descriptor, ModuleTarget target, ModuleHashes recordedHashes, ModuleHashes.HashSupplier hasher, ModuleResolution mres) {
        final String mn = descriptor.name();
        final URI uri = JNUA.create("jrt", "/".concat(mn));
        Supplier<ModuleReader> readerSupplier = new Supplier<ModuleReader>(){

            @Override
            public ModuleReader get() {
                return new SystemModuleReader(mn, uri);
            }
        };
        ModuleReference mref = new ModuleReferenceImpl(descriptor, uri, readerSupplier, null, target, recordedHashes, hasher, mres);
        mref = ModuleBootstrap.patcher().patchIfNeeded(mref);
        return mref;
    }

    static Map<String, byte[]> generateNameToHash(ModuleHashes[] recordedHashes) {
        Map<String, byte[]> nameToHash = null;
        boolean secondSeen = false;
        for (ModuleHashes mh : recordedHashes) {
            if (mh == null) continue;
            if (nameToHash == null) {
                nameToHash = mh.hashes();
                continue;
            }
            if (!secondSeen) {
                nameToHash = new HashMap<String, byte[]>(nameToHash);
                secondSeen = true;
            }
            nameToHash.putAll(mh.hashes());
        }
        return nameToHash != null ? nameToHash : Map.of();
    }

    static ModuleHashes.HashSupplier hashSupplier(Map<String, byte[]> nameToHash, String name) {
        final byte[] hash = nameToHash.get(name);
        if (hash != null) {
            return new ModuleHashes.HashSupplier(){

                @Override
                public byte[] generate(String algorithm) {
                    return hash;
                }
            };
        }
        return null;
    }

    static {
        String value = System.getProperty("jdk.system.module.finder.disableFastPath");
        USE_FAST_PATH = value == null ? true : !value.isEmpty() && !Boolean.parseBoolean(value);
    }

    private static class SystemModuleFinder
    implements ModuleFinder {
        final Set<ModuleReference> mrefs;
        final Map<String, ModuleReference> nameToModule;

        SystemModuleFinder(ModuleReference[] array, Map.Entry<String, ModuleReference>[] map) {
            this.mrefs = Set.of(array);
            this.nameToModule = Map.ofEntries(map);
        }

        SystemModuleFinder(Set<ModuleReference> mrefs, Map<String, ModuleReference> nameToModule) {
            this.mrefs = Set.copyOf(mrefs);
            this.nameToModule = Map.copyOf(nameToModule);
        }

        @Override
        public Optional<ModuleReference> find(String name) {
            Objects.requireNonNull(name);
            return Optional.ofNullable(this.nameToModule.get(name));
        }

        @Override
        public Set<ModuleReference> findAll() {
            return this.mrefs;
        }
    }

    private static class SystemImage {
        static final ImageReader READER = ImageReaderFactory.getImageReader();

        private SystemImage() {
        }

        static ImageReader reader() {
            return READER;
        }
    }

    private static class ModuleContentSpliterator
    implements Spliterator<String> {
        final String moduleRoot;
        final Deque<ImageReader.Node> stack;
        Iterator<ImageReader.Node> iterator;

        ModuleContentSpliterator(String module) throws IOException {
            this.moduleRoot = "/modules/" + module;
            this.stack = new ArrayDeque<ImageReader.Node>();
            ImageReader.Node dir = SystemImage.reader().findNode(this.moduleRoot);
            if (dir == null || !dir.isDirectory()) {
                throw new IOException(this.moduleRoot + " not a directory");
            }
            this.stack.push(dir);
            this.iterator = Collections.emptyIterator();
        }

        private String next() throws IOException {
            while (true) {
                if (this.iterator.hasNext()) {
                    ImageReader.Node node = this.iterator.next();
                    String name = node.getName();
                    if (node.isDirectory()) {
                        ImageReader.Node dir = SystemImage.reader().findNode(name);
                        assert (dir.isDirectory());
                        this.stack.push(dir);
                        continue;
                    }
                    return name.substring(this.moduleRoot.length() + 1);
                }
                if (this.stack.isEmpty()) {
                    return null;
                }
                ImageReader.Node dir = this.stack.poll();
                assert (dir.isDirectory());
                this.iterator = dir.getChildren().iterator();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            String next;
            try {
                next = this.next();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            if (next != null) {
                action.accept(next);
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<String> trySplit() {
            return null;
        }

        @Override
        public int characteristics() {
            return 1281;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }
    }

    private static class SystemModuleReader
    implements ModuleReader {
        private final String module;
        private volatile boolean closed;

        private static void checkPermissionToConnect(URI uri) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    URLConnection uc = uri.toURL().openConnection();
                    sm.checkPermission(uc.getPermission());
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
        }

        SystemModuleReader(String module, URI uri) {
            SystemModuleReader.checkPermissionToConnect(uri);
            this.module = module;
        }

        private ImageLocation findImageLocation(String name) throws IOException {
            Objects.requireNonNull(name);
            if (this.closed) {
                throw new IOException("ModuleReader is closed");
            }
            ImageReader imageReader = SystemImage.reader();
            if (imageReader != null) {
                return imageReader.findLocation(this.module, name);
            }
            return null;
        }

        private boolean containsImageLocation(String name) throws IOException {
            Objects.requireNonNull(name);
            if (this.closed) {
                throw new IOException("ModuleReader is closed");
            }
            ImageReader imageReader = SystemImage.reader();
            if (imageReader != null) {
                return imageReader.verifyLocation(this.module, name);
            }
            return false;
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            if (this.containsImageLocation(name)) {
                URI u = JNUA.create("jrt", "/" + this.module + "/" + name);
                return Optional.of(u);
            }
            return Optional.empty();
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            return this.read(name).map(this::toInputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream toInputStream(ByteBuffer bb) {
            try {
                int rem = bb.remaining();
                byte[] bytes = new byte[rem];
                bb.get(bytes);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                return byteArrayInputStream;
            }
            finally {
                this.release(bb);
            }
        }

        @Override
        public Optional<ByteBuffer> read(String name) throws IOException {
            ImageLocation location = this.findImageLocation(name);
            if (location != null) {
                return Optional.of(SystemImage.reader().getResourceBuffer(location));
            }
            return Optional.empty();
        }

        @Override
        public void release(ByteBuffer bb) {
            Objects.requireNonNull(bb);
            ImageReader.releaseByteBuffer(bb);
        }

        @Override
        public Stream<String> list() throws IOException {
            if (this.closed) {
                throw new IOException("ModuleReader is closed");
            }
            ModuleContentSpliterator s = new ModuleContentSpliterator(this.module);
            return StreamSupport.stream(s, false);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

