/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.perf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import jdk.internal.ref.CleanerFactory;
import sun.nio.cs.UTF_8;

public final class Perf {
    private static Perf instance;
    private static final int PERF_MODE_RO = 0;
    private static final int PERF_MODE_RW = 1;

    private Perf() {
    }

    public static Perf getPerf() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            RuntimePermission perm = new RuntimePermission("jdk.internal.perf.Perf.getPerf");
            security.checkPermission(perm);
        }
        return instance;
    }

    public ByteBuffer attach(int lvmid, String mode) throws IllegalArgumentException, IOException {
        if (mode.compareTo("r") == 0) {
            return this.attachImpl(null, lvmid, 0);
        }
        if (mode.compareTo("rw") == 0) {
            return this.attachImpl(null, lvmid, 1);
        }
        throw new IllegalArgumentException("unknown mode");
    }

    public ByteBuffer attach(String user, int lvmid, String mode) throws IllegalArgumentException, IOException {
        if (mode.compareTo("r") == 0) {
            return this.attachImpl(user, lvmid, 0);
        }
        if (mode.compareTo("rw") == 0) {
            return this.attachImpl(user, lvmid, 1);
        }
        throw new IllegalArgumentException("unknown mode");
    }

    private ByteBuffer attachImpl(String user, int lvmid, int mode) throws IllegalArgumentException, IOException {
        ByteBuffer b = this.attach(user, lvmid, mode);
        if (lvmid == 0) {
            return b;
        }
        ByteBuffer dup = b.duplicate();
        CleanerFactory.cleaner().register(dup, new CleanerAction(instance, b));
        return dup;
    }

    private native ByteBuffer attach(String var1, int var2, int var3) throws IllegalArgumentException, IOException;

    private native void detach(ByteBuffer var1);

    public native ByteBuffer createLong(String var1, int var2, int var3, long var4);

    public ByteBuffer createString(String name, int variability, int units, String value, int maxLength) {
        byte[] v = value.getBytes(UTF_8.INSTANCE);
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return this.createByteArray(name, variability, units, v1, Math.max(v1.length, maxLength));
    }

    public ByteBuffer createString(String name, int variability, int units, String value) {
        byte[] v = value.getBytes(UTF_8.INSTANCE);
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return this.createByteArray(name, variability, units, v1, v1.length);
    }

    public native ByteBuffer createByteArray(String var1, int var2, int var3, byte[] var4, int var5);

    public native long highResCounter();

    public native long highResFrequency();

    private static native void registerNatives();

    static {
        Perf.registerNatives();
        instance = new Perf();
    }

    private static class CleanerAction
    implements Runnable {
        private final ByteBuffer bb;
        private final Perf perf;

        CleanerAction(Perf perf, ByteBuffer bb) {
            this.perf = perf;
            this.bb = bb;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.perf.detach(this.bb);
                }
                catch (Throwable th) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)th.toString());
                }
            }
        }
    }

    public static class GetPerfAction
    implements PrivilegedAction<Perf> {
        @Override
        public Perf run() {
            return Perf.getPerf();
        }
    }
}

