/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.perf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.security.AccessController;
import jdk.internal.perf.Perf;

public class PerfCounter {
    private static final Perf perf = AccessController.doPrivileged(new Perf.GetPerfAction());
    private static final int V_Constant = 1;
    private static final int V_Monotonic = 2;
    private static final int V_Variable = 3;
    private static final int U_None = 1;
    private final String name;
    private final LongBuffer lb;

    private PerfCounter(String name, int type) {
        this.name = name;
        ByteBuffer bb = perf.createLong(name, type, 1, 0L);
        bb.order(ByteOrder.nativeOrder());
        this.lb = bb.asLongBuffer();
    }

    public static PerfCounter newPerfCounter(String name) {
        return new PerfCounter(name, 3);
    }

    public static PerfCounter newConstantPerfCounter(String name) {
        PerfCounter c = new PerfCounter(name, 1);
        return c;
    }

    public synchronized long get() {
        return this.lb.get(0);
    }

    public synchronized void set(long newValue) {
        this.lb.put(0, newValue);
    }

    public synchronized void add(long value) {
        long res = this.get() + value;
        this.lb.put(0, res);
    }

    public void increment() {
        this.add(1L);
    }

    public void addTime(long interval) {
        this.add(interval);
    }

    public void addElapsedTimeFrom(long startTime) {
        this.add(System.nanoTime() - startTime);
    }

    public String toString() {
        return this.name + " = " + this.get();
    }

    public static PerfCounter getFindClasses() {
        return CoreCounters.lc;
    }

    public static PerfCounter getFindClassTime() {
        return CoreCounters.lct;
    }

    public static PerfCounter getReadClassBytesTime() {
        return CoreCounters.rcbt;
    }

    public static PerfCounter getParentDelegationTime() {
        return CoreCounters.pdt;
    }

    public static PerfCounter getZipFileCount() {
        return CoreCounters.zfc;
    }

    public static PerfCounter getZipFileOpenTime() {
        return CoreCounters.zfot;
    }

    static class CoreCounters {
        static final PerfCounter pdt = PerfCounter.newPerfCounter("sun.classloader.parentDelegationTime");
        static final PerfCounter lc = PerfCounter.newPerfCounter("sun.classloader.findClasses");
        static final PerfCounter lct = PerfCounter.newPerfCounter("sun.classloader.findClassTime");
        static final PerfCounter rcbt = PerfCounter.newPerfCounter("sun.urlClassLoader.readClassBytesTime");
        static final PerfCounter zfc = PerfCounter.newPerfCounter("sun.zip.zipFiles");
        static final PerfCounter zfot = PerfCounter.newPerfCounter("sun.zip.zipFile.openTime");

        CoreCounters() {
        }
    }
}

