/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupUtil;

public interface CgroupSubsystemController {
    public static final String EMPTY_STR = "";

    public String path();

    public static String getStringValue(CgroupSubsystemController controller, String param) {
        if (controller == null) {
            return null;
        }
        try {
            return CgroupUtil.readStringValue(controller, param);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static long getLongValueMatchingLine(CgroupSubsystemController controller, String param, String match, Function<String, Long> conversion, long defaultRetval) {
        long retval = defaultRetval;
        if (controller == null) {
            return retval;
        }
        try {
            Path filePath = Paths.get(controller.path(), param);
            List<String> lines = CgroupUtil.readAllLinesPrivileged(filePath);
            for (String line : lines) {
                if (!line.startsWith(match)) continue;
                retval = conversion.apply(line);
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retval;
    }

    public static long getLongValue(CgroupSubsystemController controller, String param, Function<String, Long> conversion, long defaultRetval) {
        String strval = CgroupSubsystemController.getStringValue(controller, param);
        if (strval == null) {
            return defaultRetval;
        }
        return conversion.apply(strval);
    }

    public static double getDoubleValue(CgroupSubsystemController controller, String param, double defaultRetval) {
        String strval = CgroupSubsystemController.getStringValue(controller, param);
        if (strval == null) {
            return defaultRetval;
        }
        double retval = Double.parseDouble(strval);
        return retval;
    }

    public static long getLongEntry(CgroupSubsystemController controller, String param, String entryname, long defaultRetval) {
        long l;
        block10: {
            if (controller == null) {
                return defaultRetval;
            }
            Stream<String> lines = CgroupUtil.readFilePrivileged(Paths.get(controller.path(), param));
            try {
                Optional<String> result = lines.map(line -> line.split(" ")).filter(line -> ((String[])line).length == 2 && line[0].equals(entryname)).map(line -> line[1]).findFirst();
                long l2 = l = result.isPresent() ? Long.parseLong(result.get()) : defaultRetval;
                if (lines == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException e) {
                    return defaultRetval;
                }
                catch (IOException e) {
                    return defaultRetval;
                }
            }
            lines.close();
        }
        return l;
    }

    public static int[] stringRangeToIntArray(String range) {
        String[] strs;
        if (range == null || EMPTY_STR.equals(range)) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String str : strs = range.split(",")) {
            if (str.contains("-")) {
                String[] lohi = str.split("-");
                if (lohi.length != 2) continue;
                int lo = Integer.parseInt(lohi[0]);
                int hi = Integer.parseInt(lohi[1]);
                for (int i = lo; i <= hi; ++i) {
                    results.add(i);
                }
                continue;
            }
            results.add(Integer.parseInt(str));
        }
        results.sort(null);
        int[] ints = new int[results.size()];
        int i = 0;
        for (Integer n : results) {
            ints[i++] = n;
        }
        return ints;
    }

    public static long convertStringToLong(String strval, long overflowRetval, long defaultRetval) {
        long retval;
        block3: {
            retval = defaultRetval;
            if (strval == null) {
                return retval;
            }
            try {
                retval = Long.parseLong(strval);
            }
            catch (NumberFormatException e) {
                BigInteger b = new BigInteger(strval);
                if (b.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) break block3;
                return overflowRetval;
            }
        }
        return retval;
    }
}

