/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupInfo;
import jdk.internal.platform.CgroupMetrics;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupUtil;
import jdk.internal.platform.CgroupV1MetricsImpl;
import jdk.internal.platform.cgroupv1.CgroupV1Subsystem;
import jdk.internal.platform.cgroupv2.CgroupV2Subsystem;

public class CgroupSubsystemFactory {
    private static final String CPU_CTRL = "cpu";
    private static final String CPUACCT_CTRL = "cpuacct";
    private static final String CPUSET_CTRL = "cpuset";
    private static final String BLKIO_CTRL = "blkio";
    private static final String MEMORY_CTRL = "memory";
    private static final Pattern MOUNTINFO_PATTERN = Pattern.compile("^[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+([^\\s]+)\\s+([^\\s]+)\\s+[^-]+-\\s+([^\\s]+)\\s+.*$");

    static CgroupMetrics create() {
        Optional<CgroupTypeResult> optResult = null;
        try {
            optResult = CgroupSubsystemFactory.determineType("/proc/self/mountinfo", "/proc/cgroups", "/proc/self/cgroup");
        }
        catch (IOException e) {
            return null;
        }
        catch (UncheckedIOException e) {
            return null;
        }
        if (optResult.isEmpty()) {
            return null;
        }
        CgroupTypeResult result = optResult.get();
        if (!result.isAnyControllersEnabled()) {
            return null;
        }
        if (result.isAnyCgroupV1Controllers() && result.isAnyCgroupV2Controllers()) {
            System.Logger logger = System.getLogger("jdk.internal.platform");
            logger.log(System.Logger.Level.DEBUG, "Mixed cgroupv1 and cgroupv2 not supported. Metrics disabled.");
            return null;
        }
        Map<String, CgroupInfo> infos = result.getInfos();
        if (result.isCgroupV2()) {
            CgroupInfo anyController = infos.get(MEMORY_CTRL);
            CgroupSubsystem subsystem = CgroupV2Subsystem.getInstance(anyController);
            return subsystem != null ? new CgroupMetrics(subsystem) : null;
        }
        CgroupV1Subsystem subsystem = CgroupV1Subsystem.getInstance(infos);
        return subsystem != null ? new CgroupV1MetricsImpl(subsystem) : null;
    }

    public static Optional<CgroupTypeResult> determineType(String mountInfo, String cgroups, String selfCgroup) throws IOException {
        HashMap<String, CgroupInfo> infos = new HashMap<String, CgroupInfo>();
        List<String> lines = CgroupUtil.readAllLinesPrivileged(Paths.get(cgroups, new String[0]));
        for (String line2 : lines) {
            if (line2.startsWith("#")) continue;
            CgroupInfo info = CgroupInfo.fromCgroupsLine(line2);
            switch (info.getName()) {
                case "cpu": {
                    infos.put(CPU_CTRL, info);
                    break;
                }
                case "cpuacct": {
                    infos.put(CPUACCT_CTRL, info);
                    break;
                }
                case "cpuset": {
                    infos.put(CPUSET_CTRL, info);
                    break;
                }
                case "memory": {
                    infos.put(MEMORY_CTRL, info);
                    break;
                }
                case "blkio": {
                    infos.put(BLKIO_CTRL, info);
                }
            }
        }
        boolean isCgroupsV2 = true;
        boolean anyControllersEnabled = false;
        boolean anyCgroupsV2Controller = false;
        boolean anyCgroupsV1Controller = false;
        for (Object info : infos.values()) {
            anyCgroupsV1Controller = anyCgroupsV1Controller || ((CgroupInfo)info).getHierarchyId() != 0;
            anyCgroupsV2Controller = anyCgroupsV2Controller || ((CgroupInfo)info).getHierarchyId() == 0;
            isCgroupsV2 = isCgroupsV2 && ((CgroupInfo)info).getHierarchyId() == 0;
            anyControllersEnabled = anyControllersEnabled || ((CgroupInfo)info).isEnabled();
        }
        lines = CgroupUtil.readAllLinesPrivileged(Paths.get(mountInfo, new String[0]));
        boolean anyCgroupMounted = false;
        for (String line3 : lines) {
            boolean cgroupsControllerFound = CgroupSubsystemFactory.amendCgroupInfos(line3, infos, isCgroupsV2);
            anyCgroupMounted = anyCgroupMounted || cgroupsControllerFound;
        }
        if (!anyCgroupMounted) {
            return Optional.empty();
        }
        try (Stream<String> selfCgroupLines = CgroupUtil.readFilePrivileged(Paths.get(selfCgroup, new String[0]));){
            Consumer<String[]> action = tokens -> CgroupSubsystemFactory.setCgroupV1Path(infos, tokens);
            if (isCgroupsV2) {
                action = tokens -> CgroupSubsystemFactory.setCgroupV2Path(infos, tokens);
            }
            selfCgroupLines.map(line -> line.split(":", 3)).forEach(action);
        }
        CgroupTypeResult result = new CgroupTypeResult(isCgroupsV2, anyControllersEnabled, anyCgroupsV2Controller, anyCgroupsV1Controller, Collections.unmodifiableMap(infos));
        return Optional.of(result);
    }

    private static void setCgroupV2Path(Map<String, CgroupInfo> infos, String[] tokens) {
        int hierarchyId = Integer.parseInt(tokens[0]);
        String cgroupPath = tokens[2];
        for (CgroupInfo info : infos.values()) {
            assert (hierarchyId == info.getHierarchyId() && hierarchyId == 0);
            info.setCgroupPath(cgroupPath);
        }
    }

    private static void setCgroupV1Path(Map<String, CgroupInfo> infos, String[] tokens) {
        String controllerName = tokens[1];
        String cgroupPath = tokens[2];
        if (controllerName != null && cgroupPath != null) {
            String[] stringArray = controllerName.split(",");
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String cName;
                switch (cName = stringArray[i]) {
                    case "memory": 
                    case "cpuset": 
                    case "cpuacct": 
                    case "cpu": 
                    case "blkio": {
                        CgroupInfo info = infos.get(cName);
                        info.setCgroupPath(cgroupPath);
                        continue block10;
                    }
                }
            }
        }
    }

    private static boolean amendCgroupInfos(String mntInfoLine, Map<String, CgroupInfo> infos, boolean isCgroupsV2) {
        Matcher lineMatcher = MOUNTINFO_PATTERN.matcher(mntInfoLine.trim());
        boolean cgroupv1ControllerFound = false;
        boolean cgroupv2ControllerFound = false;
        if (lineMatcher.matches()) {
            String mountRoot = lineMatcher.group(1);
            String mountPath = lineMatcher.group(2);
            String fsType = lineMatcher.group(3);
            if (fsType.equals("cgroup")) {
                String[] controllerNames;
                Path p = Paths.get(mountPath, new String[0]);
                String[] stringArray = controllerNames = p.getFileName().toString().split(",");
                int n = stringArray.length;
                block11: for (int i = 0; i < n; ++i) {
                    String controllerName;
                    switch (controllerName = stringArray[i]) {
                        case "memory": 
                        case "cpu": 
                        case "cpuacct": 
                        case "blkio": {
                            CgroupInfo info = infos.get(controllerName);
                            assert (info.getMountPoint() == null);
                            assert (info.getMountRoot() == null);
                            info.setMountPoint(mountPath);
                            info.setMountRoot(mountRoot);
                            cgroupv1ControllerFound = true;
                            continue block11;
                        }
                        case "cpuset": {
                            CgroupInfo info = infos.get(controllerName);
                            if (info.getMountPoint() != null) {
                                if (!info.getMountPoint().startsWith("/sys/fs/cgroup")) {
                                    info.setMountPoint(mountPath);
                                    info.setMountRoot(mountRoot);
                                }
                            } else {
                                info.setMountPoint(mountPath);
                                info.setMountRoot(mountRoot);
                            }
                            cgroupv1ControllerFound = true;
                            continue block11;
                        }
                    }
                }
            } else if (fsType.equals("cgroup2")) {
                if (isCgroupsV2) {
                    for (CgroupInfo info : infos.values()) {
                        assert (info.getMountPoint() == null);
                        assert (info.getMountRoot() == null);
                        info.setMountPoint(mountPath);
                        info.setMountRoot(mountRoot);
                    }
                }
                cgroupv2ControllerFound = true;
            }
        }
        return cgroupv1ControllerFound || cgroupv2ControllerFound;
    }

    public static final class CgroupTypeResult {
        private final boolean isCgroupV2;
        private final boolean anyControllersEnabled;
        private final boolean anyCgroupV2Controllers;
        private final boolean anyCgroupV1Controllers;
        private final Map<String, CgroupInfo> infos;

        private CgroupTypeResult(boolean isCgroupV2, boolean anyControllersEnabled, boolean anyCgroupV2Controllers, boolean anyCgroupV1Controllers, Map<String, CgroupInfo> infos) {
            this.isCgroupV2 = isCgroupV2;
            this.anyControllersEnabled = anyControllersEnabled;
            this.anyCgroupV1Controllers = anyCgroupV1Controllers;
            this.anyCgroupV2Controllers = anyCgroupV2Controllers;
            this.infos = infos;
        }

        public boolean isCgroupV2() {
            return this.isCgroupV2;
        }

        public boolean isAnyControllersEnabled() {
            return this.anyControllersEnabled;
        }

        public boolean isAnyCgroupV2Controllers() {
            return this.anyCgroupV2Controllers;
        }

        public boolean isAnyCgroupV1Controllers() {
            return this.anyCgroupV1Controllers;
        }

        public Map<String, CgroupInfo> getInfos() {
            return this.infos;
        }
    }
}

