/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.ref;

import java.lang.ref.Cleaner;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import jdk.internal.misc.InnocuousThread;
import jdk.internal.ref.PhantomCleanable;

public final class CleanerImpl
implements Runnable {
    private static Function<Cleaner, CleanerImpl> cleanerImplAccess = null;
    final PhantomCleanable<?> phantomCleanableList;
    final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static void setCleanerImplAccess(Function<Cleaner, CleanerImpl> access) {
        if (cleanerImplAccess != null) {
            throw new InternalError("cleanerImplAccess");
        }
        cleanerImplAccess = access;
    }

    static CleanerImpl getCleanerImpl(Cleaner cleaner) {
        return cleanerImplAccess.apply(cleaner);
    }

    public CleanerImpl() {
        this.phantomCleanableList = new PhantomCleanableRef();
    }

    public void start(Cleaner cleaner, ThreadFactory threadFactory) {
        if (CleanerImpl.getCleanerImpl(cleaner) != this) {
            throw new AssertionError((Object)"wrong cleaner");
        }
        new CleanerCleanable(cleaner);
        if (threadFactory == null) {
            threadFactory = InnocuousThreadFactory.factory();
        }
        Thread thread = threadFactory.newThread(this);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        InnocuousThread mlThread;
        Thread t = Thread.currentThread();
        InnocuousThread innocuousThread = mlThread = t instanceof InnocuousThread ? (InnocuousThread)t : null;
        while (!this.phantomCleanableList.isListEmpty()) {
            if (mlThread != null) {
                mlThread.eraseThreadLocals();
            }
            try {
                Cleaner.Cleanable ref = (Cleaner.Cleanable)((Object)this.queue.remove(60000L));
                if (ref == null) continue;
                ref.clean();
            }
            catch (Throwable throwable) {}
        }
    }

    public static final class PhantomCleanableRef
    extends PhantomCleanable<Object> {
        private final Runnable action;

        public PhantomCleanableRef(Object obj, Cleaner cleaner, Runnable action) {
            super(obj, cleaner);
            this.action = action;
        }

        PhantomCleanableRef() {
            this.action = null;
        }

        @Override
        protected void performCleanup() {
            this.action.run();
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("get");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }
    }

    static final class CleanerCleanable
    extends PhantomCleanable<Cleaner> {
        CleanerCleanable(Cleaner cleaner) {
            super(cleaner, cleaner);
        }

        @Override
        protected void performCleanup() {
        }
    }

    static final class InnocuousThreadFactory
    implements ThreadFactory {
        static final ThreadFactory factory = new InnocuousThreadFactory();
        final AtomicInteger cleanerThreadNumber = new AtomicInteger();

        InnocuousThreadFactory() {
        }

        static ThreadFactory factory() {
            return factory;
        }

        @Override
        public Thread newThread(Runnable r) {
            return InnocuousThread.newThread("Cleaner-" + this.cleanerThreadNumber.getAndIncrement(), r, -1);
        }
    }
}

