/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.ref;

import java.lang.ref.Cleaner;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.util.Objects;
import jdk.internal.ref.CleanerImpl;

public abstract class PhantomCleanable<T>
extends PhantomReference<T>
implements Cleaner.Cleanable {
    PhantomCleanable<?> prev = this;
    PhantomCleanable<?> next = this;
    private final PhantomCleanable<?> list;

    public PhantomCleanable(T referent, Cleaner cleaner) {
        super(Objects.requireNonNull(referent), CleanerImpl.getCleanerImpl((Cleaner)cleaner).queue);
        this.list = CleanerImpl.getCleanerImpl((Cleaner)cleaner).phantomCleanableList;
        this.insert();
        Reference.reachabilityFence(referent);
        Reference.reachabilityFence(cleaner);
    }

    PhantomCleanable() {
        super(null, null);
        this.list = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert() {
        PhantomCleanable<?> phantomCleanable = this.list;
        synchronized (phantomCleanable) {
            this.prev = this.list;
            this.next = this.list.next;
            this.next.prev = this;
            this.list.next = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove() {
        PhantomCleanable<?> phantomCleanable = this.list;
        synchronized (phantomCleanable) {
            if (this.next != this) {
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.prev = this;
                this.next = this;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isListEmpty() {
        PhantomCleanable<?> phantomCleanable = this.list;
        synchronized (phantomCleanable) {
            return this.list == this.list.next;
        }
    }

    @Override
    public final void clean() {
        if (this.remove()) {
            super.clear();
            this.performCleanup();
        }
    }

    @Override
    public void clear() {
        if (this.remove()) {
            super.clear();
        }
    }

    protected abstract void performCleanup();

    @Override
    public final boolean isEnqueued() {
        throw new UnsupportedOperationException("isEnqueued");
    }

    @Override
    public final boolean enqueue() {
        throw new UnsupportedOperationException("enqueue");
    }
}

