/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.reflect;

import java.util.ArrayList;
import java.util.List;
import jdk.internal.reflect.ClassFileAssembler;

class Label {
    private final List<PatchInfo> patches = new ArrayList<PatchInfo>();

    void add(ClassFileAssembler asm, short instrBCI, short patchBCI, int stackDepth) {
        this.patches.add(new PatchInfo(asm, instrBCI, patchBCI, stackDepth));
    }

    public void bind() {
        for (PatchInfo patch : this.patches) {
            short curBCI = patch.asm.getLength();
            short offset = (short)(curBCI - patch.instrBCI);
            patch.asm.emitShort(patch.patchBCI, offset);
            patch.asm.setStack(patch.stackDepth);
        }
    }

    static class PatchInfo {
        final ClassFileAssembler asm;
        final short instrBCI;
        final short patchBCI;
        final int stackDepth;

        PatchInfo(ClassFileAssembler asm, short instrBCI, short patchBCI, int stackDepth) {
            this.asm = asm;
            this.instrBCI = instrBCI;
            this.patchBCI = patchBCI;
            this.stackDepth = stackDepth;
        }
    }
}

